/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.location;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.MapView;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseActivity;
import io.rong.imkit.plugin.location.AmapInfoWindowAdapter;
import io.rong.message.LocationMessage;

public class AMapPreviewActivity
extends RongBaseActivity {
    private MapView mAMapView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_location_preview_activity);
        this.mAMapView = (MapView)this.findViewById(R.id.rc_ext_amap);
        this.mAMapView.onCreate(savedInstanceState);
        TextView title = (TextView)this.findViewById(R.id.rc_action_bar_title);
        title.setText(R.string.rc_plugin_location);
        this.onCreateActionbar(new RongBaseActivity.ActionBar(this));
        this.initMap();
    }

    private void initMap() {
        AMap amap = this.mAMapView.getMap();
        amap.setMyLocationEnabled(false);
        amap.getUiSettings().setTiltGesturesEnabled(false);
        amap.getUiSettings().setZoomControlsEnabled(false);
        amap.getUiSettings().setMyLocationButtonEnabled(false);
        Intent intent = this.getIntent();
        LocationMessage locationMessage = (LocationMessage)intent.getParcelableExtra("location");
        double lat = locationMessage.getLat();
        double lng = locationMessage.getLng();
        String poi = locationMessage.getPoi();
        MarkerOptions markerOptions = new MarkerOptions().anchor(0.5f, 0.5f).position(new LatLng(lat, lng)).title(poi).snippet(lat + "," + lng).draggable(false);
        Marker marker = amap.addMarker(markerOptions);
        amap.setInfoWindowAdapter((AMap.InfoWindowAdapter)new AmapInfoWindowAdapter((Context)this));
        marker.showInfoWindow();
        amap.moveCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)new CameraPosition.Builder().target(new LatLng(lat, lng)).zoom(16.0f).bearing(0.0f).build()));
    }

    protected void onDestroy() {
        this.mAMapView.onDestroy();
        super.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        this.mAMapView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mAMapView.onPause();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mAMapView.onSaveInstanceState(outState);
    }
}

