/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.tools;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imageloader.core.assist.FailReason;
import io.rong.imageloader.core.imageaware.ImageAware;
import io.rong.imageloader.core.imageaware.ImageViewAware;
import io.rong.imageloader.core.listener.ImageLoadingListener;
import io.rong.imageloader.core.listener.ImageLoadingProgressListener;
import io.rong.imkit.R;
import io.rong.imkit.fragment.BaseFragment;
import io.rong.imkit.plugin.image.AlbumBitmapCacheHelper;
import io.rong.imkit.plugin.image.HackyViewPager;
import io.rong.imkit.widget.PicturePopupWindow;
import io.rong.imlib.RongCommonDefine;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import io.rong.photoview.PhotoView;
import io.rong.photoview.PhotoViewAttacher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PhotoFragment
extends BaseFragment {
    private static final String TAG = "PhotoFragment";
    private static final int IMAGE_MESSAGE_COUNT = 10;
    private HackyViewPager mViewPager;
    private ImageMessage mCurrentImageMessage;
    private Conversation.ConversationType mConversationType;
    private int mCurrentMessageId;
    private String mTargetId = null;
    private int mCurrentIndex = 0;
    private PhotoDownloadListener mDownloadListener;
    private ImageAware mDownloadingImageAware;
    private ImageAdapter mImageAdapter;
    private boolean isFirstTime = false;
    private ViewPager.OnPageChangeListener mPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            RLog.i((String)PhotoFragment.TAG, (String)("onPageSelected. position:" + position));
            PhotoFragment.this.mCurrentIndex = position;
            View view = PhotoFragment.this.mViewPager.findViewById(position);
            if (view != null) {
                PhotoFragment.this.mImageAdapter.updatePhotoView(position, view, PhotoFragment.this.mDownloadListener);
            }
            if (position == PhotoFragment.this.mImageAdapter.getCount() - 1) {
                PhotoFragment.this.getConversationImageUris(PhotoFragment.this.mImageAdapter.getItem(position).getMessageId(), RongCommonDefine.GetMessageDirection.BEHIND);
            } else if (position == 0) {
                PhotoFragment.this.getConversationImageUris(PhotoFragment.this.mImageAdapter.getItem(position).getMessageId(), RongCommonDefine.GetMessageDirection.FRONT);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_photo, container, true);
        this.mViewPager = (HackyViewPager)view.findViewById(R.id.viewpager);
        return view;
    }

    public void initPhoto(Message currentMessage, PhotoDownloadListener downloadListener) {
        if (currentMessage == null) {
            return;
        }
        this.mCurrentImageMessage = (ImageMessage)currentMessage.getContent();
        this.mConversationType = currentMessage.getConversationType();
        this.mCurrentMessageId = currentMessage.getMessageId();
        this.mTargetId = currentMessage.getTargetId();
        this.mDownloadListener = downloadListener;
        if (this.mCurrentMessageId < 0) {
            RLog.e((String)TAG, (String)"The value of messageId is wrong!");
            return;
        }
        this.mImageAdapter = new ImageAdapter();
        this.isFirstTime = true;
        this.mViewPager.setOnPageChangeListener(this.mPageChangeListener);
        this.getConversationImageUris(this.mCurrentMessageId, RongCommonDefine.GetMessageDirection.FRONT);
        this.getConversationImageUris(this.mCurrentMessageId, RongCommonDefine.GetMessageDirection.BEHIND);
    }

    private void getConversationImageUris(int mesageId, final RongCommonDefine.GetMessageDirection direction) {
        if (this.mConversationType != null && !TextUtils.isEmpty((CharSequence)this.mTargetId)) {
            RongIMClient.getInstance().getHistoryMessages(this.mConversationType, this.mTargetId, "RC:ImgMsg", mesageId, 10, direction, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Message>>(){

                public void onSuccess(List<Message> messages) {
                    ArrayList<ImageInfo> lists = new ArrayList<ImageInfo>();
                    if (messages != null) {
                        if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT)) {
                            Collections.reverse(messages);
                        }
                        for (int i = 0; i < messages.size(); ++i) {
                            Uri largeImageUri;
                            Message message = messages.get(i);
                            if (!(message.getContent() instanceof ImageMessage)) continue;
                            ImageMessage imageMessage = (ImageMessage)message.getContent();
                            Uri uri = largeImageUri = imageMessage.getLocalUri() == null ? imageMessage.getRemoteUri() : imageMessage.getLocalUri();
                            if (imageMessage.getThumUri() == null || largeImageUri == null) continue;
                            lists.add(new ImageInfo(message.getMessageId(), imageMessage.getThumUri(), largeImageUri));
                        }
                    }
                    if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT) && PhotoFragment.this.isFirstTime) {
                        lists.add(new ImageInfo(PhotoFragment.this.mCurrentMessageId, PhotoFragment.this.mCurrentImageMessage.getThumUri(), PhotoFragment.this.mCurrentImageMessage.getLocalUri() == null ? PhotoFragment.this.mCurrentImageMessage.getRemoteUri() : PhotoFragment.this.mCurrentImageMessage.getLocalUri()));
                        PhotoFragment.this.mImageAdapter.addData(lists, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        PhotoFragment.this.mViewPager.setAdapter(PhotoFragment.this.mImageAdapter);
                        PhotoFragment.this.isFirstTime = false;
                        PhotoFragment.this.mViewPager.setCurrentItem(lists.size() - 1);
                        PhotoFragment.this.mCurrentIndex = lists.size() - 1;
                    } else if (lists.size() > 0) {
                        PhotoFragment.this.mImageAdapter.addData(lists, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        PhotoFragment.this.mImageAdapter.notifyDataSetChanged();
                        if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT)) {
                            PhotoFragment.this.mViewPager.setCurrentItem(lists.size());
                            PhotoFragment.this.mCurrentIndex = lists.size();
                        }
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onRestoreUI() {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private class ImageInfo {
        private int messageId;
        private Uri thumbUri;
        private Uri largeImageUri;

        ImageInfo(int messageId, Uri thumbnail, Uri largeImageUri) {
            this.messageId = messageId;
            this.thumbUri = thumbnail;
            this.largeImageUri = largeImageUri;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public Uri getLargeImageUri() {
            return this.largeImageUri;
        }

        public Uri getThumbUri() {
            return this.thumbUri;
        }
    }

    private class ImageAdapter
    extends PagerAdapter {
        private ArrayList<ImageInfo> mImageList = new ArrayList();
        private PicturePopupWindow menuWindow;
        private View.OnClickListener onMenuWindowClick = new View.OnClickListener(){

            public void onClick(View v) {
                if (v.getId() == R.id.rc_content) {
                    // empty if block
                }
                ImageAdapter.this.menuWindow.dismiss();
            }
        };

        private ImageAdapter() {
        }

        private View newView(Context context, final ImageInfo imageInfo) {
            View result = LayoutInflater.from((Context)context).inflate(R.layout.rc_fr_image, null);
            ViewHolder holder = new ViewHolder();
            holder.progressBar = (ProgressBar)result.findViewById(R.id.rc_progress);
            holder.progressText = (TextView)result.findViewById(R.id.rc_txt);
            holder.photoView = (PhotoView)result.findViewById(R.id.rc_photoView);
            holder.photoView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    Uri uri = imageInfo.getLargeImageUri();
                    File file = null;
                    if (uri != null) {
                        file = uri.getScheme().startsWith("http") || uri.getScheme().startsWith("https") ? ImageLoader.getInstance().getDiskCache().get(uri.toString()) : new File(uri.getPath());
                    }
                    ImageAdapter.this.menuWindow = new PicturePopupWindow((Context)PhotoFragment.this.getActivity(), file);
                    ImageAdapter.this.menuWindow.showAtLocation(v, 81, 0, 0);
                    ImageAdapter.this.menuWindow.setOutsideTouchable(false);
                    return false;
                }
            });
            holder.photoView.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

                @Override
                public void onPhotoTap(View view, float x, float y) {
                    PhotoFragment.this.getActivity().finish();
                }

                @Override
                public void onOutsidePhotoTap() {
                }
            });
            result.setTag((Object)holder);
            return result;
        }

        public void addData(ArrayList<ImageInfo> newImages, boolean direction) {
            if (newImages == null || newImages.size() == 0) {
                return;
            }
            if (this.mImageList.size() == 0) {
                this.mImageList.addAll(newImages);
            } else if (direction && !PhotoFragment.this.isFirstTime && !this.isDuplicate(newImages.get(0).getMessageId())) {
                ArrayList<ImageInfo> temp = new ArrayList<ImageInfo>();
                temp.addAll(this.mImageList);
                this.mImageList.clear();
                this.mImageList.addAll(newImages);
                this.mImageList.addAll(this.mImageList.size(), temp);
            } else if (!PhotoFragment.this.isFirstTime && !this.isDuplicate(newImages.get(0).getMessageId())) {
                this.mImageList.addAll(this.mImageList.size(), newImages);
            }
        }

        private boolean isDuplicate(int messageId) {
            for (ImageInfo info : this.mImageList) {
                if (info.getMessageId() != messageId) continue;
                return true;
            }
            return false;
        }

        public ImageInfo getItem(int index) {
            return this.mImageList.get(index);
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public int getCount() {
            return this.mImageList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            RLog.i((String)PhotoFragment.TAG, (String)("instantiateItem.position:" + position));
            View imageView = this.newView(container.getContext(), this.mImageList.get(position));
            this.updatePhotoView(position, imageView, PhotoFragment.this.mDownloadListener);
            imageView.setId(position);
            container.addView(imageView);
            return imageView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            RLog.i((String)PhotoFragment.TAG, (String)("destroyItem.position:" + position));
            ViewHolder holder = (ViewHolder)container.findViewById(position).getTag();
            holder.photoView.setImageURI(null);
            container.removeView((View)object);
        }

        private void updatePhotoView(int position, View view, final PhotoDownloadListener downloadListener) {
            final ViewHolder holder = (ViewHolder)view.getTag();
            Uri originalUri = this.mImageList.get(position).getLargeImageUri();
            Uri thumbUri = this.mImageList.get(position).getThumbUri();
            if (originalUri == null || thumbUri == null) {
                RLog.e((String)PhotoFragment.TAG, (String)"large uri and thumbnail uri of the image should not be null.");
                return;
            }
            File file = originalUri.getScheme().startsWith("http") || originalUri.getScheme().startsWith("https") ? ImageLoader.getInstance().getDiskCache().get(originalUri.toString()) : new File(originalUri.getPath());
            if (file != null && file.exists()) {
                if (PhotoFragment.this.mDownloadListener != null) {
                    PhotoFragment.this.mDownloadListener.onDownloaded(originalUri);
                }
                AlbumBitmapCacheHelper.getInstance().addPathToShowlist(file.getAbsolutePath());
                Bitmap bitmap = AlbumBitmapCacheHelper.getInstance().getBitmap(file.getAbsolutePath(), 0, 0, new AlbumBitmapCacheHelper.ILoadImageCallback(){

                    @Override
                    public void onLoadImageCallBack(Bitmap bitmap, String p, Object ... objects) {
                        if (bitmap == null) {
                            return;
                        }
                        holder.photoView.setImageBitmap(bitmap);
                    }
                }, position);
                if (bitmap != null) {
                    holder.photoView.setImageBitmap(bitmap);
                } else {
                    Drawable drawable2 = Drawable.createFromPath((String)thumbUri.getPath());
                    holder.photoView.setImageDrawable(drawable2);
                }
            } else if (position != PhotoFragment.this.mCurrentIndex) {
                Drawable drawable3 = Drawable.createFromPath((String)thumbUri.getPath());
                holder.photoView.setImageDrawable(drawable3);
            } else {
                ImageViewAware imageAware = new ImageViewAware(holder.photoView);
                if (PhotoFragment.this.mDownloadingImageAware != null) {
                    ImageLoader.getInstance().cancelDisplayTask(PhotoFragment.this.mDownloadingImageAware);
                }
                ImageLoader.getInstance().displayImage(originalUri.toString(), imageAware, this.createDisplayImageOptions(thumbUri), new ImageLoadingListener(){

                    @Override
                    public void onLoadingStarted(String imageUri, View view) {
                        holder.progressText.setVisibility(0);
                        holder.progressBar.setVisibility(0);
                        holder.progressText.setText((CharSequence)"0%");
                    }

                    @Override
                    public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                        if (downloadListener != null) {
                            downloadListener.onDownloadError();
                        }
                        holder.progressText.setVisibility(8);
                        holder.progressBar.setVisibility(8);
                    }

                    @Override
                    public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                        if (downloadListener != null) {
                            downloadListener.onDownloaded(Uri.parse((String)imageUri));
                        }
                        holder.progressText.setVisibility(8);
                        holder.progressBar.setVisibility(8);
                    }

                    @Override
                    public void onLoadingCancelled(String imageUri, View view) {
                        holder.progressText.setVisibility(8);
                        holder.progressText.setVisibility(8);
                    }
                }, new ImageLoadingProgressListener(){

                    @Override
                    public void onProgressUpdate(String imageUri, View view, int current, int total) {
                        holder.progressText.setText((CharSequence)(current * 100 / total + "%"));
                        if (current == total) {
                            holder.progressText.setVisibility(8);
                            holder.progressBar.setVisibility(8);
                        } else {
                            holder.progressText.setVisibility(0);
                            holder.progressBar.setVisibility(0);
                        }
                    }
                });
                PhotoFragment.this.mDownloadingImageAware = imageAware;
            }
        }

        private DisplayImageOptions createDisplayImageOptions(Uri uri) {
            DisplayImageOptions.Builder builder = new DisplayImageOptions.Builder();
            Drawable drawable2 = Drawable.createFromPath((String)uri.getPath());
            return builder.resetViewBeforeLoading(false).cacheInMemory(false).cacheOnDisk(true).bitmapConfig(Bitmap.Config.RGB_565).showImageForEmptyUri(drawable2).showImageOnFail(drawable2).showImageOnLoading(drawable2).handler(new Handler()).build();
        }

        public class ViewHolder {
            ProgressBar progressBar;
            TextView progressText;
            PhotoView photoView;
        }
    }

    public static interface PhotoDownloadListener {
        public void onDownloaded(Uri var1);

        public void onDownloadError();
    }
}

