/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.tools;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.webkit.DownloadListener;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.common.RongWebView;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseActivity;
import java.util.List;

public class RongWebviewActivity
extends RongBaseActivity {
    private static final String TAG = "RongWebviewActivity";
    private String mPrevUrl;
    private RongWebView mWebView;
    private ProgressBar mProgressBar;
    protected TextView mWebViewTitle;
    private OnTitleReceivedListener onTitleReceivedListener;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_ac_webview);
        Intent intent = this.getIntent();
        this.mWebView = (RongWebView)this.findViewById(R.id.rc_webview);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.rc_web_progressbar);
        this.mWebViewTitle = (TextView)this.findViewById(R.id.rc_action_bar_title);
        this.mWebView.setVerticalScrollbarOverlay(true);
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        if (Build.VERSION.SDK_INT > 11) {
            this.mWebView.getSettings().setDisplayZoomControls(false);
        }
        this.mWebView.getSettings().setSupportZoom(true);
        this.mWebView.setWebViewClient((WebViewClient)new RongWebviewClient());
        this.mWebView.setWebChromeClient((WebChromeClient)new RongWebChromeClient());
        this.mWebView.setDownloadListener((DownloadListener)new RongWebViewDownLoadListener());
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setDefaultTextEncodingName("utf-8");
        String url = intent.getStringExtra("url");
        Uri data = intent.getData();
        if (url != null) {
            this.mPrevUrl = url;
            this.mWebView.loadUrl(url);
            String title = intent.getStringExtra("title");
            if (this.mWebViewTitle != null && !TextUtils.isEmpty((CharSequence)title)) {
                this.mWebViewTitle.setText((CharSequence)title);
            }
        } else if (data != null) {
            this.mPrevUrl = data.toString();
            this.mWebView.loadUrl(data.toString());
        }
        this.onCreateActionbar(new RongBaseActivity.ActionBar(this));
    }

    public void setOnTitleReceivedListener(OnTitleReceivedListener onTitleReceivedListener) {
        this.onTitleReceivedListener = onTitleReceivedListener;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean checkIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List apps = packageManager.queryIntentActivities(intent, 0);
        return apps.size() > 0;
    }

    private class RongWebViewDownLoadListener
    implements DownloadListener {
        private RongWebViewDownLoadListener() {
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (RongWebviewActivity.this.checkIntent((Context)RongWebviewActivity.this, intent)) {
                RongWebviewActivity.this.startActivity(intent);
                if (uri.getScheme().equals("file") && uri.toString().endsWith(".txt")) {
                    RongWebviewActivity.this.finish();
                }
            }
        }
    }

    private class RongWebChromeClient
    extends WebChromeClient {
        private RongWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                RongWebviewActivity.this.mProgressBar.setVisibility(8);
            } else {
                if (RongWebviewActivity.this.mProgressBar.getVisibility() == 8) {
                    RongWebviewActivity.this.mProgressBar.setVisibility(0);
                }
                RongWebviewActivity.this.mProgressBar.setProgress(newProgress);
            }
            super.onProgressChanged(view, newProgress);
        }

        public void onReceivedTitle(WebView view, String title) {
            if (RongWebviewActivity.this.mWebViewTitle != null && TextUtils.isEmpty((CharSequence)RongWebviewActivity.this.mWebViewTitle.getText())) {
                RongWebviewActivity.this.mWebViewTitle.setText((CharSequence)title);
            }
            if (RongWebviewActivity.this.onTitleReceivedListener != null) {
                RongWebviewActivity.this.onTitleReceivedListener.onTitleReceived(title);
            }
        }

        public void onCloseWindow(WebView window) {
            super.onCloseWindow(window);
            if (!RongWebviewActivity.this.isFinishing()) {
                RongWebviewActivity.this.finish();
            }
        }
    }

    private class RongWebviewClient
    extends WebViewClient {
        private RongWebviewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (RongWebviewActivity.this.mPrevUrl != null) {
                if (!RongWebviewActivity.this.mPrevUrl.equals(url)) {
                    if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        Uri content_url = Uri.parse((String)url);
                        intent.setData(content_url);
                        intent.setFlags(0x10000000);
                        intent.setFlags(0x20000000);
                        try {
                            RongWebviewActivity.this.startActivity(intent);
                        }
                        catch (Exception e) {
                            RLog.e((String)RongWebviewActivity.TAG, (String)("not apps install for this intent =" + e.toString()));
                            RLog.e((String)RongWebviewActivity.TAG, (String)"RongWebviewClient", (Throwable)e);
                        }
                        return true;
                    }
                    RongWebviewActivity.this.mPrevUrl = url;
                    RongWebviewActivity.this.mWebView.loadUrl(url);
                    return true;
                }
                return false;
            }
            RongWebviewActivity.this.mPrevUrl = url;
            RongWebviewActivity.this.mWebView.loadUrl(url);
            return true;
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            if (RongWebviewActivity.this.getResources().getBoolean(R.bool.rc_open_https_certificate)) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)RongWebviewActivity.this);
                builder.setMessage(R.string.rc_notification_error_ssl_cert_invalid);
                builder.setPositiveButton(R.string.rc_dialog_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton(R.string.rc_dialog_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            } else {
                handler.proceed();
            }
        }
    }

    public static interface OnTitleReceivedListener {
        public void onTitleReceived(String var1);
    }
}

