/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.userInfoCache;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.cache.RongCache;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.IRongCacheListener;
import io.rong.imkit.userInfoCache.RongConversationInfo;
import io.rong.imkit.userInfoCache.RongDatabaseDao;
import io.rong.imkit.utils.StringUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.UserInfo;
import java.io.File;
import java.util.List;

public class RongUserInfoManager
implements Handler.Callback {
    private static final String TAG = "RongUserInfoManager";
    private static final int USER_CACHE_MAX_COUNT = 256;
    private static final int PUBLIC_ACCOUNT_CACHE_MAX_COUNT = 64;
    private static final int GROUP_CACHE_MAX_COUNT = 128;
    private static final int DISCUSSION_CACHE_MAX_COUNT = 16;
    private static final int EVENT_GET_USER_INFO = 2;
    private static final int EVENT_GET_GROUP_INFO = 3;
    private static final int EVENT_GET_GROUP_USER_INFO = 4;
    private static final int EVENT_GET_DISCUSSION = 5;
    private static final int EVENT_UPDATE_USER_INFO = 7;
    private static final int EVENT_UPDATE_GROUP_USER_INFO = 8;
    private static final int EVENT_UPDATE_GROUP_INFO = 9;
    private static final int EVENT_UPDATE_DISCUSSION = 10;
    private static final int EVENT_LOGOUT = 11;
    private static final int EVENT_CLEAR_CACHE = 12;
    private static final String GROUP_PREFIX = "groups";
    private RongDatabaseDao mRongDatabaseDao;
    private RongCache<String, UserInfo> mUserInfoCache = new RongCache(256);
    private RongCache<String, GroupUserInfo> mGroupUserInfoCache = new RongCache(256);
    private RongCache<String, RongConversationInfo> mGroupCache = new RongCache(128);
    private RongCache<String, RongConversationInfo> mDiscussionCache = new RongCache(16);
    private RongCache<String, PublicServiceProfile> mPublicServiceProfileCache;
    private RongCache<String, String> mRequestCache = new RongCache(64);
    private IRongCacheListener mCacheListener;
    private boolean mIsCacheUserInfo = true;
    private boolean mIsCacheGroupInfo = true;
    private boolean mIsCacheGroupUserInfo = true;
    private Handler mWorkHandler;
    private String mAppKey;
    private String mUserId;
    private boolean mInitialized;
    private Context mContext;

    private RongUserInfoManager() {
        this.mPublicServiceProfileCache = new RongCache(64);
        HandlerThread workThread = new HandlerThread(TAG);
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper(), (Handler.Callback)this);
        this.mInitialized = false;
    }

    public void setIsCacheUserInfo(boolean mIsCacheUserInfo) {
        this.mIsCacheUserInfo = mIsCacheUserInfo;
    }

    public void setIsCacheGroupInfo(boolean mIsCacheGroupInfo) {
        this.mIsCacheGroupInfo = mIsCacheGroupInfo;
    }

    public void setIsCacheGroupUserInfo(boolean mIsCacheGroupUserInfo) {
        this.mIsCacheGroupUserInfo = mIsCacheGroupUserInfo;
    }

    public static RongUserInfoManager getInstance() {
        return SingletonHolder.sInstance;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean handleMessage(Message msg) {
        if (TextUtils.isEmpty((CharSequence)this.mUserId)) {
            if (TextUtils.isEmpty((CharSequence)RongIMClient.getInstance().getCurrentUserId())) {
                RLog.i((String)TAG, (String)"user hasn't connected, return directly!");
                return true;
            }
            this.mUserId = RongIMClient.getInstance().getCurrentUserId();
            RLog.i((String)TAG, (String)("userId:" + this.mUserId));
            this.mRongDatabaseDao = new RongDatabaseDao();
            this.mRongDatabaseDao.open(this.mContext, this.mAppKey, this.mUserId);
        } else if (!this.mUserId.equals(RongIMClient.getInstance().getCurrentUserId())) {
            this.clearUserInfoCache();
            RLog.d((String)TAG, (String)("user changed, old userId = " + this.mUserId + ", current userId = " + RongIMClient.getInstance().getCurrentUserId()));
            this.mUserId = RongIMClient.getInstance().getCurrentUserId();
            if (this.mRongDatabaseDao != null) {
                this.mRongDatabaseDao.close();
                this.mRongDatabaseDao.open(this.mContext, this.mAppKey, this.mUserId);
            }
        }
        switch (msg.what) {
            case 3: {
                String groupId = (String)msg.obj;
                Group group = null;
                String cacheGroupId = GROUP_PREFIX + groupId;
                if (this.mRongDatabaseDao != null) {
                    group = this.mRongDatabaseDao.getGroupInfo(groupId);
                }
                if (group != null && group.getPortraitUri() != null) {
                    Uri uri = group.getPortraitUri();
                    if (uri.toString().toLowerCase().startsWith("file://")) {
                        File file = new File(uri.toString().substring(7));
                        if (!file.exists()) {
                            group = null;
                        }
                    } else if (uri.toString().equals("")) {
                        group = null;
                    }
                }
                if (group == null) {
                    if (this.mCacheListener != null) {
                        group = this.mCacheListener.getGroupInfo(groupId);
                    }
                    if (group != null && this.mRongDatabaseDao != null) {
                        this.mRongDatabaseDao.putGroupInfo(group);
                    }
                }
                if (group == null) return false;
                RongConversationInfo conversationInfo = new RongConversationInfo(Conversation.ConversationType.GROUP.getValue() + "", group.getId(), group.getName(), group.getPortraitUri());
                this.mGroupCache.put(groupId, conversationInfo);
                this.mRequestCache.remove(cacheGroupId);
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onGroupUpdated(group);
                return false;
            }
            case 4: {
                GroupUserInfo groupUserInfo = null;
                String groupId = StringUtils.getArg1((String)msg.obj);
                String userId = StringUtils.getArg2((String)msg.obj);
                if (this.mRongDatabaseDao != null) {
                    groupUserInfo = this.mRongDatabaseDao.getGroupUserInfo(groupId, userId);
                }
                if (groupUserInfo == null) {
                    if (this.mCacheListener != null) {
                        groupUserInfo = this.mCacheListener.getGroupUserInfo(groupId, userId);
                    }
                    if (groupUserInfo != null && this.mRongDatabaseDao != null) {
                        this.mRongDatabaseDao.putGroupUserInfo(groupUserInfo);
                    }
                }
                if (groupUserInfo == null) return false;
                this.mGroupUserInfoCache.put((String)msg.obj, groupUserInfo);
                this.mRequestCache.remove((String)msg.obj);
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onGroupUserInfoUpdated(groupUserInfo);
                return false;
            }
            case 5: {
                final String discussionId = (String)msg.obj;
                Discussion discussion = null;
                if (this.mRongDatabaseDao != null) {
                    discussion = this.mRongDatabaseDao.getDiscussionInfo(discussionId);
                }
                if (discussion != null) {
                    RongConversationInfo conversationInfo = new RongConversationInfo(Conversation.ConversationType.DISCUSSION.getValue() + "", discussion.getId(), discussion.getName(), null);
                    this.mDiscussionCache.put(discussionId, conversationInfo);
                    if (this.mCacheListener == null) return false;
                    this.mCacheListener.onDiscussionUpdated(discussion);
                    return false;
                }
                RongIM.getInstance().getDiscussion(discussionId, new RongIMClient.ResultCallback<Discussion>(){

                    public void onSuccess(Discussion discussion) {
                        if (discussion != null) {
                            if (RongUserInfoManager.this.mRongDatabaseDao != null) {
                                RongUserInfoManager.this.mRongDatabaseDao.putDiscussionInfo(discussion);
                            }
                            RongConversationInfo conversationInfo = new RongConversationInfo(Conversation.ConversationType.DISCUSSION.getValue() + "", discussion.getId(), discussion.getName(), null);
                            RongUserInfoManager.this.mDiscussionCache.put(discussionId, conversationInfo);
                            if (RongUserInfoManager.this.mCacheListener != null) {
                                RongUserInfoManager.this.mCacheListener.onDiscussionUpdated(discussion);
                            }
                        }
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
                return false;
            }
            case 8: {
                GroupUserInfo groupUserInfo = (GroupUserInfo)msg.obj;
                String key = StringUtils.getKey(groupUserInfo.getGroupId(), groupUserInfo.getUserId());
                GroupUserInfo oldGroupUserInfo = this.mGroupUserInfoCache.put(key, groupUserInfo);
                if (oldGroupUserInfo != null) {
                    if (oldGroupUserInfo.getNickname() == null) return false;
                    if (groupUserInfo.getNickname() == null) return false;
                    if (oldGroupUserInfo.getNickname().equals(groupUserInfo.getNickname())) return false;
                }
                this.mRequestCache.remove(key);
                if (this.mRongDatabaseDao != null) {
                    this.mRongDatabaseDao.putGroupUserInfo(groupUserInfo);
                }
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onGroupUserInfoUpdated(groupUserInfo);
                return false;
            }
            case 9: {
                Group group = (Group)msg.obj;
                RongConversationInfo conversationInfo = new RongConversationInfo(Conversation.ConversationType.GROUP.getValue() + "", group.getId(), group.getName(), group.getPortraitUri());
                RongConversationInfo oldConversationInfo = this.mGroupCache.put(conversationInfo.getId(), conversationInfo);
                if (oldConversationInfo != null && oldConversationInfo.getName() != null && oldConversationInfo.getUri() != null && conversationInfo.getName() == null) {
                    if (conversationInfo.getUri() == null) return false;
                }
                String cachedGroupId = GROUP_PREFIX + group.getId();
                this.mRequestCache.remove(cachedGroupId);
                if (this.mRongDatabaseDao != null) {
                    this.mRongDatabaseDao.putGroupInfo(group);
                }
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onGroupUpdated(group);
                return false;
            }
            case 10: {
                Discussion discussion = (Discussion)msg.obj;
                RongConversationInfo conversationInfo = new RongConversationInfo(Conversation.ConversationType.DISCUSSION.getValue() + "", discussion.getId(), discussion.getName(), null);
                RongConversationInfo oldConversationInfo = this.mDiscussionCache.put(conversationInfo.getId(), conversationInfo);
                if (oldConversationInfo != null) {
                    if (oldConversationInfo.getName() == null) return false;
                    if (conversationInfo.getName() == null) return false;
                    if (oldConversationInfo.getName().equals(conversationInfo.getName())) return false;
                }
                if (this.mRongDatabaseDao != null) {
                    this.mRongDatabaseDao.putDiscussionInfo(discussion);
                }
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onDiscussionUpdated(discussion);
                return false;
            }
            case 2: {
                String userId = (String)msg.obj;
                UserInfo userInfo = null;
                if (this.mRongDatabaseDao != null) {
                    userInfo = this.mRongDatabaseDao.getUserInfo(userId);
                }
                if (userInfo != null && userInfo.getPortraitUri() != null) {
                    Uri uri = userInfo.getPortraitUri();
                    if (uri.toString().toLowerCase().startsWith("file://")) {
                        File file = new File(uri.toString().substring(7));
                        if (!file.exists()) {
                            userInfo = null;
                        }
                    } else if (uri.toString().equals("")) {
                        userInfo = null;
                    }
                }
                if (userInfo == null) {
                    if (this.mCacheListener != null) {
                        userInfo = this.mCacheListener.getUserInfo(userId);
                    }
                    if (userInfo != null) {
                        this.putUserInfoInDB(userInfo);
                    }
                }
                if (userInfo == null) return false;
                this.putUserInfoInCache(userInfo);
                this.mRequestCache.remove(userId);
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onUserInfoUpdated(userInfo);
                return false;
            }
            case 7: {
                UserInfo userInfo = (UserInfo)msg.obj;
                UserInfo oldUserInfo = this.putUserInfoInCache(userInfo);
                if (oldUserInfo != null && oldUserInfo.getName() != null && oldUserInfo.getPortraitUri() != null && userInfo.getName() == null) {
                    if (userInfo.getPortraitUri() == null) return false;
                }
                this.putUserInfoInDB(userInfo);
                this.mRequestCache.remove(userInfo.getUserId());
                if (this.mCacheListener == null) return false;
                this.mCacheListener.onUserInfoUpdated(userInfo);
                return false;
            }
            case 11: {
                this.clearUserInfoCache();
                this.mInitialized = false;
                this.mUserId = null;
                this.mAppKey = null;
                if (this.mRongDatabaseDao == null) return false;
                this.mRongDatabaseDao.close();
                this.mRongDatabaseDao = null;
                return false;
            }
            case 12: {
                this.mRequestCache.clear();
                return false;
            }
        }
        return false;
    }

    public void init(Context context, String appKey, IRongCacheListener listener) {
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            RLog.e((String)TAG, (String)"init, appkey is null.");
            return;
        }
        if (this.mInitialized) {
            RLog.d((String)TAG, (String)"has been init, no need init again");
            return;
        }
        this.mContext = context;
        this.mAppKey = appKey;
        this.mCacheListener = listener;
        this.mInitialized = true;
    }

    private void clearUserInfoCache() {
        if (this.mUserInfoCache != null) {
            this.mUserInfoCache.clear();
        }
        if (this.mDiscussionCache != null) {
            this.mDiscussionCache.clear();
        }
        if (this.mGroupCache != null) {
            this.mGroupCache.clear();
        }
        if (this.mGroupUserInfoCache != null) {
            this.mGroupUserInfoCache.clear();
        }
        if (this.mPublicServiceProfileCache != null) {
            this.mPublicServiceProfileCache.clear();
        }
        this.mRequestCache.clear();
    }

    public void uninit() {
        RLog.i((String)TAG, (String)"uninit");
        this.mWorkHandler.sendEmptyMessage(11);
    }

    private UserInfo putUserInfoInCache(UserInfo info) {
        if (this.mUserInfoCache != null) {
            return this.mUserInfoCache.put(info.getUserId(), info);
        }
        return null;
    }

    private void insertUserInfoInDB(UserInfo info) {
        if (this.mRongDatabaseDao != null) {
            this.mRongDatabaseDao.insertUserInfo(info);
        }
    }

    private void putUserInfoInDB(UserInfo info) {
        if (this.mRongDatabaseDao != null) {
            this.mRongDatabaseDao.putUserInfo(info);
        }
    }

    public UserInfo getUserInfo(String id2) {
        RLog.i((String)TAG, (String)("getUserInfo : " + id2));
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        UserInfo info = null;
        if (this.mIsCacheUserInfo) {
            info = this.mUserInfoCache.get(id2);
            if (info == null) {
                String cachedId = this.mRequestCache.get(id2);
                if (cachedId != null) {
                    return null;
                }
                this.mRequestCache.put(id2, id2);
                Message message = Message.obtain();
                message.what = 2;
                message.obj = id2;
                this.mWorkHandler.sendMessage(message);
                if (!this.mWorkHandler.hasMessages(12)) {
                    this.mWorkHandler.sendEmptyMessageDelayed(12, 30000L);
                }
            }
        } else if (this.mCacheListener != null) {
            info = this.mCacheListener.getUserInfo(id2);
        }
        return info;
    }

    public List<UserInfo> getAllUserInfo() {
        RLog.i((String)TAG, (String)"getAllUserInfo");
        if (this.mRongDatabaseDao != null) {
            return this.mRongDatabaseDao.getAllUserInfo();
        }
        RLog.i((String)TAG, (String)"mRongDatabaseDao is null");
        return null;
    }

    public GroupUserInfo getGroupUserInfo(String gId, String id2) {
        if (TextUtils.isEmpty((CharSequence)gId) || TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        RLog.d((String)TAG, (String)("getGroupUserInfo : " + gId + ", " + id2));
        String key = StringUtils.getKey(gId, id2);
        GroupUserInfo info = null;
        if (this.mIsCacheGroupUserInfo) {
            info = this.mGroupUserInfoCache.get(key);
            if (info == null) {
                String cachedId = this.mRequestCache.get(key);
                if (cachedId != null) {
                    return null;
                }
                this.mRequestCache.put(key, key);
                Message message = Message.obtain();
                message.what = 4;
                message.obj = key;
                this.mWorkHandler.sendMessage(message);
                if (!this.mWorkHandler.hasMessages(12)) {
                    this.mWorkHandler.sendEmptyMessageDelayed(12, 30000L);
                }
            }
        } else if (this.mCacheListener != null) {
            info = this.mCacheListener.getGroupUserInfo(gId, id2);
        }
        return info;
    }

    public Group getGroupInfo(String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        RLog.i((String)TAG, (String)("getGroupInfo : " + id2));
        Group groupInfo = null;
        if (this.mIsCacheGroupInfo) {
            RongConversationInfo info = this.mGroupCache.get(id2);
            if (info == null) {
                String cachedId = this.mRequestCache.get(id2);
                if (cachedId != null) {
                    return null;
                }
                this.mRequestCache.put(id2, id2);
                Message message = Message.obtain();
                message.what = 3;
                message.obj = id2;
                this.mWorkHandler.sendMessage(message);
                if (!this.mWorkHandler.hasMessages(12)) {
                    this.mWorkHandler.sendEmptyMessageDelayed(12, 30000L);
                }
            } else {
                groupInfo = new Group(info.getId(), info.getName(), info.getUri());
            }
        } else if (this.mCacheListener != null) {
            groupInfo = this.mCacheListener.getGroupInfo(id2);
        }
        return groupInfo;
    }

    public Discussion getDiscussionInfo(String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        Discussion discussionInfo = null;
        RongConversationInfo info = this.mDiscussionCache.get(id2);
        if (info == null) {
            Message message = Message.obtain();
            message.what = 5;
            message.obj = id2;
            this.mWorkHandler.sendMessage(message);
        } else {
            discussionInfo = new Discussion(info.getId(), info.getName());
        }
        return discussionInfo;
    }

    public PublicServiceProfile getPublicServiceProfile(final Conversation.PublicServiceType type, final String id2) {
        if (type == null || TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        final String key = StringUtils.getKey(type.getValue() + "", id2);
        PublicServiceProfile info = this.mPublicServiceProfileCache.get(key);
        if (info == null) {
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (RongContext.getInstance() != null && RongContext.getInstance().getPublicServiceProfileProvider() != null) {
                        PublicServiceProfile result = RongContext.getInstance().getPublicServiceProfileProvider().getPublicServiceProfile(type, id2);
                        if (result != null) {
                            RongUserInfoManager.this.mPublicServiceProfileCache.put(key, result);
                            if (RongUserInfoManager.this.mCacheListener != null) {
                                RongUserInfoManager.this.mCacheListener.onPublicServiceProfileUpdated(result);
                            }
                        }
                    } else {
                        RongIM.getInstance().getPublicServiceProfile(type, id2, new RongIMClient.ResultCallback<PublicServiceProfile>(){

                            public void onSuccess(PublicServiceProfile result) {
                                if (result != null) {
                                    RongUserInfoManager.this.mPublicServiceProfileCache.put(key, result);
                                    if (RongUserInfoManager.this.mCacheListener != null) {
                                        RongUserInfoManager.this.mCacheListener.onPublicServiceProfileUpdated(result);
                                    }
                                }
                            }

                            public void onError(RongIMClient.ErrorCode e) {
                            }
                        });
                    }
                }
            });
        }
        return info;
    }

    public void setUserInfo(UserInfo info) {
        if (this.mIsCacheUserInfo) {
            Message message = Message.obtain();
            message.what = 7;
            message.obj = info;
            this.mWorkHandler.sendMessage(message);
        } else if (this.mCacheListener != null) {
            this.mCacheListener.onUserInfoUpdated(info);
        }
    }

    public void setGroupUserInfo(GroupUserInfo info) {
        if (this.mIsCacheGroupUserInfo) {
            Message message = Message.obtain();
            message.what = 8;
            message.obj = info;
            this.mWorkHandler.sendMessage(message);
        } else if (this.mCacheListener != null) {
            this.mCacheListener.onGroupUserInfoUpdated(info);
        }
    }

    public void setGroupInfo(Group group) {
        if (this.mIsCacheGroupInfo) {
            Message message = Message.obtain();
            message.what = 9;
            message.obj = group;
            this.mWorkHandler.sendMessage(message);
        } else if (this.mCacheListener != null) {
            this.mCacheListener.onGroupUpdated(group);
        }
    }

    public void setDiscussionInfo(Discussion discussion) {
        Message message = Message.obtain();
        message.what = 10;
        message.obj = discussion;
        this.mWorkHandler.sendMessage(message);
    }

    public void setPublicServiceProfile(PublicServiceProfile profile) {
        String key = StringUtils.getKey(profile.getConversationType().getValue() + "", profile.getTargetId());
        PublicServiceProfile oldInfo = this.mPublicServiceProfileCache.put(key, profile);
        if ((oldInfo == null || oldInfo.getName() != null && profile.getName() != null && !oldInfo.getName().equals(profile.getName()) || oldInfo.getPortraitUri() != null && profile.getPortraitUri() != null && !oldInfo.getPortraitUri().toString().equals(profile.getPortraitUri().toString())) && this.mCacheListener != null) {
            this.mCacheListener.onPublicServiceProfileUpdated(profile);
        }
    }

    private static class SingletonHolder {
        static RongUserInfoManager sInstance = new RongUserInfoManager();

        private SingletonHolder() {
        }
    }
}

