/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import io.rong.imkit.R;

public class OptionsPopupDialog
extends AlertDialog {
    private Context mContext;
    private ListView mListView;
    private String[] arrays;
    private OnOptionsItemClickedListener mItemClickedListener;

    public static OptionsPopupDialog newInstance(Context context, String[] arrays) {
        OptionsPopupDialog optionsPopupDialog = new OptionsPopupDialog(context, arrays);
        return optionsPopupDialog;
    }

    public OptionsPopupDialog(Context context, String[] arrays) {
        super(context);
        this.mContext = context;
        this.arrays = arrays;
    }

    protected void onStart() {
        super.onStart();
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.rc_dialog_popup_options, null);
        this.mListView = (ListView)view.findViewById(R.id.rc_list_dialog_popup_options);
        ArrayAdapter adapter = new ArrayAdapter(this.mContext, R.layout.rc_dialog_popup_options_item, R.id.rc_dialog_popup_item_name, (Object[])this.arrays);
        this.mListView.setAdapter((ListAdapter)adapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (OptionsPopupDialog.this.mItemClickedListener != null) {
                    OptionsPopupDialog.this.mItemClickedListener.onOptionsItemClicked(position);
                    OptionsPopupDialog.this.dismiss();
                }
            }
        });
        this.setContentView(view);
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.width = this.getPopupWidth();
        layoutParams.height = -2;
        this.getWindow().setAttributes(layoutParams);
    }

    public OptionsPopupDialog setOptionsPopupDialogListener(OnOptionsItemClickedListener itemListener) {
        this.mItemClickedListener = itemListener;
        return this;
    }

    private int getPopupWidth() {
        int distanceToBorder = (int)this.mContext.getResources().getDimension(R.dimen.rc_popup_dialog_distance_to_edge);
        return this.getScreenWidth() - 2 * distanceToBorder;
    }

    private int getScreenWidth() {
        return ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public void show() {
        Activity activity;
        if (this.mContext instanceof Activity && (activity = (Activity)this.mContext).isFinishing()) {
            return;
        }
        super.show();
    }

    public static interface OnOptionsItemClickedListener {
        public void onOptionsItemClicked(int var1);
    }
}

