/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.os.Handler;
import android.os.HandlerThread;
import io.rong.common.RLog;
import io.rong.imkit.RongContext;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageProviderUserInfoHelper {
    private static final String TAG = "MessageProviderUserInfoHelper";
    private ConcurrentHashMap<MessageContent, List<String>> mMessageIdUserIdsMap = new ConcurrentHashMap();
    private static MessageProviderUserInfoHelper mHelper;
    ArrayList<String> cacheUserIds = new ArrayList();
    HandlerThread mWorkThread = new HandlerThread("MessageProviderUserInfoHelper");
    Handler mUserInfoHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageProviderUserInfoHelper getInstance() {
        if (mHelper != null) return mHelper;
        Class<MessageProviderUserInfoHelper> clazz = MessageProviderUserInfoHelper.class;
        synchronized (MessageProviderUserInfoHelper.class) {
            if (mHelper != null) return mHelper;
            mHelper = new MessageProviderUserInfoHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mHelper;
        }
    }

    MessageProviderUserInfoHelper() {
        this.mWorkThread.start();
        this.mUserInfoHandler = new Handler(this.mWorkThread.getLooper());
    }

    synchronized void setCacheUserId(String userId) {
        if (!this.cacheUserIds.contains(userId)) {
            this.cacheUserIds.add(userId);
        }
    }

    synchronized void removeCacheUserId(String userId) {
        if (this.cacheUserIds.contains(userId)) {
            this.cacheUserIds.remove(userId);
        }
    }

    public synchronized boolean isCacheUserId(String userId) {
        return this.cacheUserIds.contains(userId);
    }

    public void registerMessageUserInfo(MessageContent message, String userId) {
        RLog.i((String)TAG, (String)("registerMessageUserInfo userId:" + userId));
        List<String> userIdList = this.mMessageIdUserIdsMap.get(message);
        if (userIdList == null) {
            userIdList = new ArrayList<String>();
            this.mMessageIdUserIdsMap.put(message, userIdList);
        }
        if (!userIdList.contains(userId)) {
            userIdList.add(userId);
        }
        this.setCacheUserId(userId);
    }

    public void notifyMessageUpdate(final String userId) {
        Iterator<Map.Entry<MessageContent, List<String>>> messageUserIdsIterator = this.mMessageIdUserIdsMap.entrySet().iterator();
        this.mUserInfoHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MessageProviderUserInfoHelper.this.removeCacheUserId(userId);
            }
        }, 500L);
        while (messageUserIdsIterator.hasNext()) {
            Map.Entry<MessageContent, List<String>> userIdMessageEntry = messageUserIdsIterator.next();
            List<String> userIdList = userIdMessageEntry.getValue();
            if (userIdList == null) continue;
            if (userIdList.contains(userId)) {
                userIdList.remove(userId);
            }
            if (userIdList.isEmpty()) {
                RongContext.getInstance().getEventBus().post(userIdMessageEntry.getKey());
                this.mMessageIdUserIdsMap.remove(userIdMessageEntry.getKey());
                RLog.d((String)TAG, (String)("notifyMessageUpdate --notify--" + userIdMessageEntry.getKey().toString()));
                continue;
            }
            RLog.d((String)TAG, (String)("notifyMessageUpdate --wait--" + userId));
        }
    }

    public boolean isRequestGetUserInfo() {
        return !this.mMessageIdUserIdsMap.isEmpty();
    }
}

