/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import io.rong.common.RLog;
import java.lang.reflect.Method;

public class NotificationUtil {
    private static final String TAG = NotificationUtil.class.getSimpleName();

    public static void showNotification(Context context, String title, String content, PendingIntent intent, int notificationId, int defaults) {
        Notification notification = NotificationUtil.createNotification(context, title, content, intent, defaults);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (notification != null) {
            nm.notify(notificationId, notification);
        }
    }

    public static void showNotification(Context context, String title, String content, PendingIntent intent, int notificationId) {
        NotificationUtil.showNotification(context, title, content, intent, notificationId, -1);
    }

    public static void clearNotification(Context context, int notificationId) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.cancel(notificationId);
    }

    private static Notification createNotification(Context context, String title, String content, PendingIntent pendingIntent, int defaults) {
        Notification notification;
        String tickerText = context.getResources().getString(context.getResources().getIdentifier("rc_notification_ticker_text", "string", context.getPackageName()));
        if (Build.VERSION.SDK_INT < 11) {
            try {
                notification = new Notification(context.getApplicationInfo().icon, (CharSequence)tickerText, System.currentTimeMillis());
                Class<Notification> classType = Notification.class;
                Method method = classType.getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                method.invoke((Object)notification, context, title, content, pendingIntent);
                notification.flags = 48;
                notification.defaults = -1;
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"createNotification", (Throwable)e);
                return null;
            }
        }
        boolean isLollipop = Build.VERSION.SDK_INT >= 21;
        int smallIcon = context.getResources().getIdentifier("notification_small_icon", "drawable", context.getPackageName());
        if (smallIcon <= 0 || !isLollipop) {
            smallIcon = context.getApplicationInfo().icon;
        }
        Drawable loadIcon = context.getApplicationInfo().loadIcon(context.getPackageManager());
        Bitmap appIcon = null;
        try {
            if (Build.VERSION.SDK_INT >= 26 && loadIcon instanceof AdaptiveIconDrawable) {
                appIcon = Bitmap.createBitmap((int)loadIcon.getIntrinsicWidth(), (int)loadIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(appIcon);
                loadIcon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                loadIcon.draw(canvas);
            } else {
                appIcon = ((BitmapDrawable)loadIcon).getBitmap();
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"createNotification", (Throwable)e);
        }
        Notification.Builder builder = new Notification.Builder(context);
        builder.setLargeIcon(appIcon);
        builder.setSmallIcon(smallIcon);
        builder.setTicker((CharSequence)tickerText);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)content);
        builder.setContentIntent(pendingIntent);
        builder.setAutoCancel(true);
        builder.setOngoing(true);
        builder.setDefaults(defaults);
        notification = builder.getNotification();
        return notification;
    }

    public static int getRingerMode(Context context) {
        AudioManager audio = (AudioManager)context.getSystemService("audio");
        return audio.getRingerMode();
    }
}

