/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import io.rong.imkit.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RongDateUtils {
    private static final int OTHER = 2014;
    private static final int TODAY = 6;
    private static final int YESTERDAY = 15;

    public static int judgeDate(Date date) {
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.set(11, 0);
        calendarToday.set(12, 0);
        calendarToday.set(13, 0);
        calendarToday.set(14, 0);
        Calendar calendarYesterday = Calendar.getInstance();
        calendarYesterday.add(5, -1);
        calendarYesterday.set(11, 0);
        calendarYesterday.set(12, 0);
        calendarYesterday.set(13, 0);
        calendarYesterday.set(14, 0);
        Calendar calendarTomorrow = Calendar.getInstance();
        calendarTomorrow.add(5, 1);
        calendarTomorrow.set(11, 0);
        calendarTomorrow.set(12, 0);
        calendarTomorrow.set(13, 0);
        calendarTomorrow.set(14, 0);
        Calendar calendarTarget = Calendar.getInstance();
        calendarTarget.setTime(date);
        if (calendarTarget.before(calendarYesterday)) {
            return 2014;
        }
        if (calendarTarget.before(calendarToday)) {
            return 15;
        }
        if (calendarTarget.before(calendarTomorrow)) {
            return 6;
        }
        return 2014;
    }

    private static String getWeekDay(Context context, int dayInWeek) {
        String weekDay = "";
        switch (dayInWeek) {
            case 1: {
                weekDay = context.getResources().getString(R.string.rc_sunsay_format);
                break;
            }
            case 2: {
                weekDay = context.getResources().getString(R.string.rc_monday_format);
                break;
            }
            case 3: {
                weekDay = context.getResources().getString(R.string.rc_tuesday_format);
                break;
            }
            case 4: {
                weekDay = context.getResources().getString(R.string.rc_wednesday_format);
                break;
            }
            case 5: {
                weekDay = context.getResources().getString(R.string.rc_thuresday_format);
                break;
            }
            case 6: {
                weekDay = context.getResources().getString(R.string.rc_friday_format);
                break;
            }
            case 7: {
                weekDay = context.getResources().getString(R.string.rc_saturday_format);
                break;
            }
        }
        return weekDay;
    }

    public static boolean isTime24Hour(Context context) {
        String timeFormat = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"time_12_24");
        return timeFormat != null && timeFormat.equals("24");
    }

    private static String getTimeString(long dateMillis, Context context) {
        if (dateMillis <= 0L) {
            return "";
        }
        Date date = new Date(dateMillis);
        String formatTime = null;
        if (RongDateUtils.isTime24Hour(context)) {
            formatTime = RongDateUtils.formatDate(date, "HH:mm");
        } else {
            Calendar calendarTime = Calendar.getInstance();
            calendarTime.setTimeInMillis(dateMillis);
            int hour = calendarTime.get(10);
            if (calendarTime.get(9) == 0) {
                if (hour < 6) {
                    if (hour == 0) {
                        hour = 12;
                    }
                    formatTime = context.getResources().getString(R.string.rc_daybreak_format);
                } else if (hour >= 6 && hour < 12) {
                    formatTime = context.getResources().getString(R.string.rc_morning_format);
                }
            } else if (hour == 0) {
                formatTime = context.getResources().getString(R.string.rc_noon_format);
                hour = 12;
            } else if (hour >= 1 && hour <= 5) {
                formatTime = context.getResources().getString(R.string.rc_afternoon_format);
            } else if (hour >= 6 && hour <= 11) {
                formatTime = context.getResources().getString(R.string.rc_night_format);
            }
            int minuteInt = calendarTime.get(12);
            String minuteStr = Integer.toString(minuteInt);
            String timeStr = null;
            if (minuteInt < 10) {
                minuteStr = "0" + minuteStr;
            }
            timeStr = Integer.toString(hour) + ":" + minuteStr;
            formatTime = context.getResources().getConfiguration().locale.getCountry().equals("CN") ? formatTime + timeStr : timeStr + " " + formatTime;
        }
        return formatTime;
    }

    private static String getDateTimeString(long dateMillis, boolean showTime, Context context) {
        if (dateMillis <= 0L) {
            return "";
        }
        String formatDate = null;
        Date date = new Date(dateMillis);
        int type = RongDateUtils.judgeDate(date);
        long time = System.currentTimeMillis();
        Calendar calendarCur = Calendar.getInstance();
        Calendar calendardate = Calendar.getInstance();
        calendardate.setTimeInMillis(dateMillis);
        calendarCur.setTimeInMillis(time);
        int month = calendardate.get(2);
        int year = calendardate.get(1);
        int weekInMonth = calendardate.get(4);
        int monthCur = calendarCur.get(2);
        int yearCur = calendarCur.get(1);
        int weekInMonthCur = calendarCur.get(4);
        switch (type) {
            case 6: {
                formatDate = RongDateUtils.getTimeString(dateMillis, context);
                break;
            }
            case 15: {
                String formatString = context.getResources().getString(R.string.rc_yesterday_format);
                if (showTime) {
                    formatDate = formatString + " " + RongDateUtils.getTimeString(dateMillis, context);
                    break;
                }
                formatDate = formatString;
                break;
            }
            case 2014: {
                formatDate = year == yearCur ? (month == monthCur && weekInMonth == weekInMonthCur ? RongDateUtils.getWeekDay(context, calendardate.get(7)) : (context.getResources().getConfiguration().locale.getCountry().equals("CN") ? RongDateUtils.formatDate(date, "M" + context.getResources().getString(R.string.rc_month_format) + "d" + context.getResources().getString(R.string.rc_day_format)) : RongDateUtils.formatDate(date, "M/d"))) : (context.getResources().getConfiguration().locale.getCountry().equals("CN") ? RongDateUtils.formatDate(date, "yyyy" + context.getResources().getString(R.string.rc_year_format) + "M" + context.getResources().getString(R.string.rc_month_format) + "d" + context.getResources().getString(R.string.rc_day_format)) : RongDateUtils.formatDate(date, "M/d/yy"));
                if (!showTime) break;
                formatDate = formatDate + " " + RongDateUtils.getTimeString(dateMillis, context);
                break;
            }
        }
        return formatDate;
    }

    public static String getConversationListFormatDate(long dateMillis, Context context) {
        String formatDate = RongDateUtils.getDateTimeString(dateMillis, false, context);
        return formatDate;
    }

    public static String getConversationFormatDate(long dateMillis, Context context) {
        String formatDate = RongDateUtils.getDateTimeString(dateMillis, true, context);
        return formatDate;
    }

    public static boolean isShowChatTime(long currentTime, long preTime, int interval) {
        int typePre;
        int typeCurrent = RongDateUtils.judgeDate(new Date(currentTime));
        if (typeCurrent == (typePre = RongDateUtils.judgeDate(new Date(preTime)))) {
            return currentTime - preTime > (long)(interval * 1000);
        }
        return true;
    }

    public static String formatDate(Date date, String fromat) {
        SimpleDateFormat sdf = new SimpleDateFormat(fromat);
        return sdf.format(date);
    }
}

