/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import io.rong.common.RLog;
import java.util.List;

public class SystemUtils {
    public static String getCurProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcessInfos = mActivityManager.getRunningAppProcesses();
        if (runningAppProcessInfos == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : runningAppProcessInfos) {
            if (appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return null;
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isInBackground(Context context) {
        boolean isInBackground = true;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            List runningProcesses = am.getRunningAppProcesses();
            if (runningProcesses == null) {
                return true;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.importance != 100) continue;
                for (String activeProcess : processInfo.pkgList) {
                    if (!activeProcess.equals(context.getPackageName())) continue;
                    RLog.d((String)"SystemUtils", (String)("the process is in foreground:" + activeProcess));
                    return false;
                }
            }
        } else {
            List taskInfo = am.getRunningTasks(1);
            ComponentName componentInfo = ((ActivityManager.RunningTaskInfo)taskInfo.get((int)0)).topActivity;
            if (componentInfo.getPackageName().equals(context.getPackageName())) {
                isInBackground = false;
            }
        }
        return isInBackground;
    }
}

