/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import io.rong.common.RLog;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imageloader.core.assist.FailReason;
import io.rong.imageloader.core.assist.ImageSize;
import io.rong.imageloader.core.assist.LoadedFrom;
import io.rong.imageloader.core.display.CircleBitmapDisplayer;
import io.rong.imageloader.core.display.RoundedBitmapDisplayer;
import io.rong.imageloader.core.display.SimpleBitmapDisplayer;
import io.rong.imageloader.core.imageaware.ImageViewAware;
import io.rong.imageloader.core.listener.ImageLoadingListener;
import io.rong.imageloader.core.process.BitmapProcessor;
import io.rong.imkit.R;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.IImageLoadingListener;
import io.rong.imkit.widget.RCMessageFrameLayout;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;

public class AsyncImageView
extends ImageView {
    private static final String TAG = "AsyncImageView";
    private boolean isCircle;
    private float minShortSideSize = 0.0f;
    private int mCornerRadius = 0;
    private static final int AVATAR_SIZE = 80;
    private Drawable mDefaultDrawable;
    private WeakReference<Bitmap> mWeakBitmap;
    private WeakReference<Bitmap> mShardWeakBitmap;
    private boolean mHasMask;

    public AsyncImageView(Context context) {
        super(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AsyncImageView);
        int resId = a.getResourceId(R.styleable.AsyncImageView_RCDefDrawable, 0);
        this.isCircle = a.getInt(R.styleable.AsyncImageView_RCShape, 0) == 1;
        this.minShortSideSize = a.getDimension(R.styleable.AsyncImageView_RCMinShortSideSize, 0.0f);
        this.mCornerRadius = (int)a.getDimension(R.styleable.AsyncImageView_RCCornerRadius, 0.0f);
        this.mHasMask = a.getBoolean(R.styleable.AsyncImageView_RCMask, false);
        if (resId != 0) {
            this.mDefaultDrawable = this.getResources().getDrawable(resId);
        }
        a.recycle();
        if (this.mDefaultDrawable != null) {
            DisplayImageOptions options = this.createDisplayImageOptions(resId, false);
            Drawable drawable2 = options.getImageForEmptyUri(null);
            Bitmap bitmap = this.drawableToBitmap(drawable2);
            ImageViewAware imageViewAware = new ImageViewAware(this);
            options.getDisplayer().display(bitmap, imageViewAware, LoadedFrom.DISC_CACHE);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mHasMask) {
            Bitmap bitmap = this.mWeakBitmap == null ? null : (Bitmap)this.mWeakBitmap.get();
            Drawable drawable2 = this.getDrawable();
            RCMessageFrameLayout parent = (RCMessageFrameLayout)this.getParent();
            Drawable background = parent.getBackgroundDrawable();
            if (bitmap == null || bitmap.isRecycled()) {
                int width = this.getWidth();
                int height = this.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                try {
                    bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                catch (OutOfMemoryError e) {
                    RLog.e((String)TAG, (String)"onDraw OutOfMemoryError");
                    RLog.e((String)TAG, (String)"onDraw", (Throwable)e);
                    System.gc();
                }
                if (bitmap != null) {
                    Canvas rCanvas = new Canvas(bitmap);
                    if (drawable2 != null) {
                        drawable2.setBounds(0, 0, width, height);
                        drawable2.draw(rCanvas);
                        if (background != null && background instanceof NinePatchDrawable) {
                            NinePatchDrawable patchDrawable = (NinePatchDrawable)background;
                            patchDrawable.setBounds(0, 0, width, height);
                            Paint maskPaint = patchDrawable.getPaint();
                            maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                            patchDrawable.draw(rCanvas);
                        }
                        this.mWeakBitmap = new WeakReference<Bitmap>(bitmap);
                    }
                    canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    this.getShardImage(background, bitmap, canvas);
                }
            } else {
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                this.getShardImage(background, bitmap, canvas);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    private void getShardImage(Drawable drawable_bg, Bitmap bp, Canvas canvas) {
        Bitmap bitmap;
        int width = bp.getWidth();
        int height = bp.getHeight();
        Bitmap bitmap2 = bitmap = this.mShardWeakBitmap == null ? null : (Bitmap)this.mShardWeakBitmap.get();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (bitmap == null || bitmap.isRecycled()) {
            try {
                bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                RLog.e((String)TAG, (String)"getShardImage OutOfMemoryError");
                RLog.e((String)TAG, (String)"getShardImage", (Throwable)e);
                System.gc();
            }
            if (bitmap != null) {
                Canvas rCanvas = new Canvas(bitmap);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                Rect rect = new Rect(0, 0, width, height);
                Rect rectF = new Rect(0, 0, width, height);
                BitmapDrawable drawable_in = new BitmapDrawable(bp);
                drawable_in.setBounds(rectF);
                drawable_in.draw(rCanvas);
                if (drawable_bg instanceof NinePatchDrawable) {
                    NinePatchDrawable patchDrawable = (NinePatchDrawable)drawable_bg;
                    patchDrawable.setBounds(rect);
                    Paint maskPaint = patchDrawable.getPaint();
                    maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OVER));
                    patchDrawable.draw(rCanvas);
                }
                this.mShardWeakBitmap = new WeakReference<Bitmap>(bitmap);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            }
        } else {
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }

    protected void onDetachedFromWindow() {
        Bitmap bitmap;
        if (this.mWeakBitmap != null) {
            bitmap = (Bitmap)this.mWeakBitmap.get();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            this.mWeakBitmap = null;
        }
        if (this.mShardWeakBitmap != null) {
            bitmap = (Bitmap)this.mShardWeakBitmap.get();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            this.mShardWeakBitmap = null;
        }
        super.onDetachedFromWindow();
    }

    public void invalidate() {
        Bitmap bitmap;
        if (this.mWeakBitmap != null) {
            bitmap = (Bitmap)this.mWeakBitmap.get();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            this.mWeakBitmap = null;
        }
        if (this.mShardWeakBitmap != null) {
            bitmap = (Bitmap)this.mShardWeakBitmap.get();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            this.mShardWeakBitmap = null;
        }
        super.invalidate();
    }

    public void setDefaultDrawable() {
        if (this.mDefaultDrawable != null) {
            DisplayImageOptions options = this.createDisplayImageOptions(0, false);
            Bitmap bitmap = this.drawableToBitmap(this.mDefaultDrawable);
            ImageViewAware imageViewAware = new ImageViewAware(this);
            options.getDisplayer().display(bitmap, imageViewAware, LoadedFrom.DISC_CACHE);
        }
    }

    public void setResource(Uri imageUri) {
        DisplayImageOptions options = this.createDisplayImageOptions(0, true);
        if (imageUri != null) {
            File file = new File(imageUri.getPath());
            if (!file.exists()) {
                ImageViewAware imageViewAware = new ImageViewAware(this);
                ImageLoader.getInstance().displayImage(imageUri.toString(), imageViewAware, options, null, null);
            } else {
                Bitmap bitmap = this.getBitmap(imageUri);
                if (bitmap != null) {
                    this.setLayoutParam(bitmap);
                    this.setImageBitmap(bitmap);
                } else {
                    this.setImageBitmap(null);
                    ViewGroup.LayoutParams params = this.getLayoutParams();
                    params.height = RongUtils.dip2px(80.0f);
                    params.width = RongUtils.dip2px(110.0f);
                    this.setLayoutParams(params);
                }
            }
        }
    }

    public void setCircle(boolean circle) {
        this.isCircle = circle;
    }

    public void setLocationResource(Uri imageUri, int defRes, final int w, final int h, final IImageLoadingListener loadingListener) {
        DisplayImageOptions.Builder builder = new DisplayImageOptions.Builder();
        DisplayImageOptions options = builder.resetViewBeforeLoading(false).cacheInMemory(false).cacheOnDisk(true).bitmapConfig(Bitmap.Config.ARGB_8888).showImageOnLoading(defRes).preProcessor(new BitmapProcessor(){

            @Override
            public Bitmap process(Bitmap bitmap) {
                int widthOrg = bitmap.getWidth();
                int heightOrg = bitmap.getHeight();
                int xTopLeft = (widthOrg - w) / 2;
                int yTopLeft = (heightOrg - h) / 2;
                if (xTopLeft <= 0 || yTopLeft <= 0) {
                    return bitmap;
                }
                try {
                    Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)xTopLeft, (int)yTopLeft, (int)w, (int)h);
                    if (!bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                    return result;
                }
                catch (OutOfMemoryError e) {
                    return null;
                }
            }
        }).build();
        ImageLoader.getInstance().displayImage(imageUri == null ? null : imageUri.toString(), this, options, new ImageLoadingListener(){

            @Override
            public void onLoadingStarted(String imageUri, View view) {
            }

            @Override
            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                loadingListener.onLoadingFail();
            }

            @Override
            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                File file = ImageLoader.getInstance().getDiskCache().get(imageUri);
                if (file != null && file.exists()) {
                    loadingListener.onLoadingComplete(Uri.fromFile((File)file));
                } else {
                    loadingListener.onLoadingFail();
                }
            }

            @Override
            public void onLoadingCancelled(String imageUri, View view) {
                loadingListener.onLoadingFail();
            }
        });
    }

    public void setResource(String imageUri, int defaultResId) {
        if (imageUri == null && defaultResId <= 0) {
            return;
        }
        DisplayImageOptions options = this.createDisplayImageOptions(defaultResId, true);
        ImageLoader.getInstance().displayImage(imageUri, (ImageView)this, options);
    }

    private Bitmap drawableToBitmap(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    public void setAvatar(String imageUri, int defaultResId) {
        ImageViewAware imageViewAware = new ImageViewAware(this);
        ImageSize imageSize = new ImageSize(80, 80);
        DisplayImageOptions options = this.createDisplayImageOptions(defaultResId, true);
        ImageLoader.getInstance().displayImage(imageUri, imageViewAware, options, imageSize, null, null);
    }

    public void setAvatar(String uid, String name, int defaultResId) {
        ImageViewAware imageViewAware = new ImageViewAware(this);
        ImageSize imageSize = new ImageSize(80, 80);
        String[] arr = new String[]{name, uid};
        DisplayImageOptions options = this.createDisplayImageOptions(defaultResId, true, arr);
        String key = "";
        if (!TextUtils.isEmpty((CharSequence)name)) {
            key = URLEncoder.encode(name);
        }
        ImageLoader.getInstance().displayImage("avatar://" + uid + key, imageViewAware, options, imageSize, null, null);
    }

    public void setAvatar(Uri imageUri) {
        if (imageUri != null) {
            ImageViewAware imageViewAware = new ImageViewAware(this);
            ImageSize imageSize = new ImageSize(80, 80);
            DisplayImageOptions options = this.createDisplayImageOptions(0, true);
            ImageLoader.getInstance().displayImage(imageUri.toString(), imageViewAware, options, imageSize, null, null);
        }
    }

    public void setBitmap(Bitmap bitmap) {
        this.setLayoutParam(bitmap);
        this.setImageBitmap(bitmap);
    }

    private Bitmap getBitmap(Uri uri) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options = new BitmapFactory.Options();
        try {
            bitmap = BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("getBitmap Exception : " + uri));
            RLog.e((String)TAG, (String)"getBitmap", (Throwable)e);
        }
        return bitmap;
    }

    private DisplayImageOptions createDisplayImageOptions(int defaultResId, boolean cacheInMemory) {
        return this.createDisplayImageOptions(defaultResId, cacheInMemory, null);
    }

    private DisplayImageOptions createDisplayImageOptions(int defaultResId, boolean cacheInMemory, Object extraForDownloader) {
        DisplayImageOptions.Builder builder = new DisplayImageOptions.Builder();
        Drawable defaultDrawable = this.mDefaultDrawable;
        if (defaultResId > 0) {
            try {
                defaultDrawable = this.getContext().getResources().getDrawable(defaultResId);
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
        }
        if (defaultDrawable != null) {
            builder.showImageOnLoading(defaultDrawable);
            builder.showImageForEmptyUri(defaultDrawable);
            builder.showImageOnFail(defaultDrawable);
        }
        if (extraForDownloader != null) {
            builder.extraForDownloader(extraForDownloader);
        }
        if (this.isCircle) {
            builder.displayer(new CircleBitmapDisplayer());
        } else if (this.mCornerRadius > 0) {
            builder.displayer(new RoundedBitmapDisplayer(this.mCornerRadius));
        } else {
            builder.displayer(new SimpleBitmapDisplayer());
        }
        DisplayImageOptions options = builder.resetViewBeforeLoading(false).cacheInMemory(cacheInMemory).cacheOnDisk(true).bitmapConfig(Bitmap.Config.RGB_565).build();
        return options;
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setCornerRadius(int mCornerRadius) {
        this.mCornerRadius = mCornerRadius;
    }

    private void setLayoutParam(Bitmap bitmap) {
        float width = bitmap.getWidth();
        float height = bitmap.getHeight();
        int minSize = 100;
        if (this.minShortSideSize > 0.0f) {
            if (width <= this.minShortSideSize || height <= this.minShortSideSize) {
                int finalWidth;
                int finalHeight;
                float scale = width / height;
                if (scale > 1.0f) {
                    finalHeight = (int)(this.minShortSideSize / scale);
                    if (finalHeight < minSize) {
                        finalHeight = minSize;
                    }
                    finalWidth = (int)this.minShortSideSize;
                } else {
                    finalHeight = (int)this.minShortSideSize;
                    finalWidth = (int)(this.minShortSideSize * scale);
                    if (finalWidth < minSize) {
                        finalWidth = minSize;
                    }
                }
                ViewGroup.LayoutParams params = this.getLayoutParams();
                params.height = finalHeight;
                params.width = finalWidth;
                this.setLayoutParams(params);
            } else {
                ViewGroup.LayoutParams params = this.getLayoutParams();
                params.height = (int)height;
                params.width = (int)width;
                this.setLayoutParams(params);
            }
        }
    }
}

