/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.TextView;
import io.rong.imkit.widget.ILinkClickListener;

public class LinkTextViewMovementMethod
extends LinkMovementMethod {
    private long mLastActionDownTime;
    private ILinkClickListener mListener;

    public LinkTextViewMovementMethod(ILinkClickListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    long actionUpTime = System.currentTimeMillis();
                    if (actionUpTime - this.mLastActionDownTime > (long)ViewConfiguration.getLongPressTimeout()) {
                        return true;
                    }
                    String url = null;
                    if (link[0] instanceof URLSpan) {
                        url = ((URLSpan)link[0]).getURL();
                    }
                    if (this.mListener != null && this.mListener.onLinkClick(url)) {
                        return true;
                    }
                    link[0].onClick((View)widget);
                } else if (action == 0) {
                    this.mLastActionDownTime = System.currentTimeMillis();
                }
                return true;
            }
            Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
            return false;
        }
        return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
    }
}

