/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.PopupWindow;
import android.widget.Toast;
import io.rong.common.FileUtils;
import io.rong.imkit.R;
import io.rong.imkit.utilities.RongUtils;
import java.io.File;

public class PicturePopupWindow
extends PopupWindow {
    private Button btn_save_pic;
    private Button btn_cancel;

    public PicturePopupWindow(final Context context, final File imageFile) {
        super(context);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View menuView = inflater.inflate(R.layout.rc_pic_popup_window, null);
        menuView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicturePopupWindow.this.dismiss();
            }
        });
        this.btn_save_pic = (Button)menuView.findViewById(R.id.rc_content);
        this.btn_save_pic.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String saveImagePath = RongUtils.getImageSavePath(v.getContext());
                if (imageFile != null && imageFile.exists()) {
                    String name = System.currentTimeMillis() + ".jpg";
                    FileUtils.copyFile((File)imageFile, (String)(saveImagePath + File.separator), (String)name);
                    MediaScannerConnection.scanFile((Context)context, (String[])new String[]{saveImagePath + File.separator + name}, null, null);
                    Toast.makeText((Context)context, (CharSequence)String.format(context.getString(R.string.rc_save_picture_at), saveImagePath + File.separator + name), (int)0).show();
                } else {
                    Toast.makeText((Context)context, (CharSequence)context.getString(R.string.rc_src_file_not_found), (int)0).show();
                }
                PicturePopupWindow.this.dismiss();
            }
        });
        this.btn_cancel = (Button)menuView.findViewById(R.id.rc_btn_cancel);
        this.btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicturePopupWindow.this.dismiss();
            }
        });
        this.setContentView(menuView);
        this.setWidth(-1);
        this.setHeight(-2);
        this.setFocusable(true);
        ColorDrawable dw = new ColorDrawable(-1342177280);
        this.setBackgroundDrawable((Drawable)dw);
    }
}

