/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.imlib.model.UserInfo;

public class ConversationAddMemberAdapter
extends BaseAdapter<UserInfo> {
    LayoutInflater mInflater;
    Boolean isDeleteState = false;
    String mCreatorId = null;
    private OnDeleteIconListener mDeleteIconListener;

    public ConversationAddMemberAdapter(Context context) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.isDeleteState = false;
    }

    @Override
    protected View newView(Context context, int position, ViewGroup group) {
        View result = this.mInflater.inflate(R.layout.rc_item_conversation_member, null);
        ViewHolder holder = new ViewHolder();
        holder.mMemberIcon = (AsyncImageView)((Object)this.findViewById(result, 16908294));
        holder.mMemberName = (TextView)this.findViewById(result, 16908308);
        holder.mDeleteIcon = (ImageView)this.findViewById(result, 16908295);
        holder.mMemberDeIcon = (ImageView)this.findViewById(result, 16908296);
        result.setTag((Object)holder);
        return result;
    }

    @Override
    protected void bindView(View v, final int position, UserInfo data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (data.getUserId().equals("RongAddBtn") || data.getUserId().equals("RongDelBtn")) {
            holder.mMemberIcon.setVisibility(4);
            holder.mMemberDeIcon.setVisibility(0);
            if (data.getUserId().equals("RongAddBtn")) {
                holder.mMemberDeIcon.setImageResource(R.drawable.rc_ic_setting_friends_add);
            } else {
                holder.mMemberDeIcon.setImageResource(R.drawable.rc_ic_setting_friends_delete);
            }
            holder.mMemberName.setVisibility(4);
            holder.mDeleteIcon.setVisibility(8);
        } else {
            holder.mMemberIcon.setVisibility(0);
            holder.mMemberDeIcon.setVisibility(8);
            if (data.getPortraitUri() != null) {
                holder.mMemberIcon.setResource(data.getPortraitUri().toString(), R.drawable.rc_default_portrait);
            }
            if (data.getName() != null) {
                holder.mMemberName.setText((CharSequence)data.getName());
            } else {
                holder.mMemberName.setText((CharSequence)"");
            }
            if (this.isDeleteState() && !data.getUserId().equals(this.getCreatorId())) {
                holder.mDeleteIcon.setVisibility(0);
                holder.mDeleteIcon.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ConversationAddMemberAdapter.this.mDeleteIconListener != null) {
                            ConversationAddMemberAdapter.this.mDeleteIconListener.onDeleteIconClick(v, position);
                        }
                    }
                });
            } else {
                holder.mDeleteIcon.setVisibility(4);
            }
        }
    }

    public long getItemId(int position) {
        UserInfo info = (UserInfo)this.getItem(position);
        if (info == null) {
            return 0L;
        }
        return info.hashCode();
    }

    public void setDeleteState(boolean state) {
        this.isDeleteState = state;
    }

    public boolean isDeleteState() {
        return this.isDeleteState;
    }

    public void setCreatorId(String id2) {
        this.mCreatorId = id2;
    }

    public String getCreatorId() {
        return this.mCreatorId;
    }

    public void setDeleteIconListener(OnDeleteIconListener listener) {
        this.mDeleteIconListener = listener;
    }

    public static interface OnDeleteIconListener {
        public void onDeleteIconClick(View var1, int var2);
    }

    class ViewHolder {
        AsyncImageView mMemberIcon;
        TextView mMemberName;
        ImageView mDeleteIcon;
        ImageView mMemberDeIcon;

        ViewHolder() {
        }
    }
}

