/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.mention.RongMentionManager;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utils.RongDateUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.DebouncedOnClickListener;
import io.rong.imkit.widget.ProviderContainerView;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.destruct.DestructionTaskManager;
import io.rong.imlib.location.message.RealTimeLocationJoinMessage;
import io.rong.imlib.location.message.RealTimeLocationStartMessage;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.ReadReceiptInfo;
import io.rong.imlib.model.UnknownMessage;
import io.rong.imlib.model.UserInfo;
import io.rong.message.GroupNotificationMessage;
import io.rong.message.HistoryDividerMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.RecallNotificationMessage;
import io.rong.message.TextMessage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageListAdapter
extends BaseAdapter<UIMessage> {
    private static final String TAG = "MessageListAdapter";
    private static long readReceiptRequestInterval = 120L;
    private LayoutInflater mInflater;
    private Context mContext;
    private OnItemHandlerListener mOnItemHandlerListener;
    boolean evaForRobot = false;
    boolean robotMode = true;
    protected boolean timeGone = false;
    private boolean isShowCheckbox;
    private int maxMessageSelectedCount = -1;
    private OnMessageCheckedChanged messageCheckedChanged;
    private OnSelectedCountDidExceed selectedCountDidExceed;

    public MessageListAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        try {
            if (RongContext.getInstance() != null) {
                readReceiptRequestInterval = RongContext.getInstance().getResources().getInteger(R.integer.rc_read_receipt_request_interval);
            } else {
                RLog.e((String)TAG, (String)"SDK isn't init, use default readReceiptRequestInterval. Please refer to http://support.rongcloud.cn/kb/Mjc2 about how to init.");
            }
        }
        catch (Resources.NotFoundException e) {
            RLog.e((String)TAG, (String)"MessageListAdapter rc_read_receipt_request_interval not configure in rc_config.xml", (Throwable)e);
        }
    }

    public void setMaxMessageSelectedCount(int maxMessageSelectedCount) {
        this.maxMessageSelectedCount = maxMessageSelectedCount;
    }

    public void setSelectedCountDidExceed(OnSelectedCountDidExceed selectedCountDidExceed) {
        this.selectedCountDidExceed = selectedCountDidExceed;
    }

    public void setOnItemHandlerListener(OnItemHandlerListener onItemHandlerListener) {
        this.mOnItemHandlerListener = onItemHandlerListener;
    }

    protected OnItemHandlerListener getItemHandlerListener() {
        return this.mOnItemHandlerListener;
    }

    public boolean isShowCheckbox() {
        return this.isShowCheckbox;
    }

    public void setShowCheckbox(boolean showCheckbox) {
        this.isShowCheckbox = showCheckbox;
    }

    public void setMessageCheckedChanged(OnMessageCheckedChanged messageCheckedChanged) {
        this.messageCheckedChanged = messageCheckedChanged;
    }

    public long getItemId(int position) {
        UIMessage message = (UIMessage)this.getItem(position);
        if (message == null) {
            return -1L;
        }
        return message.getMessageId();
    }

    public int getPositionBySendTime(long sentTime) {
        for (int i = 0; i < this.getCount(); ++i) {
            UIMessage message = (UIMessage)this.getItem(i);
            if (message.getSentTime() <= sentTime) continue;
            return i;
        }
        return this.getCount();
    }

    @Override
    protected View newView(Context context, int position, ViewGroup group) {
        View result = this.mInflater.inflate(R.layout.rc_item_message, null);
        ViewHolder holder = new ViewHolder();
        holder.leftIconView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_left));
        holder.rightIconView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_right));
        holder.nameView = (TextView)this.findViewById(result, R.id.rc_title);
        holder.contentView = (ProviderContainerView)((Object)this.findViewById(result, R.id.rc_content));
        holder.layout = (ViewGroup)this.findViewById(result, R.id.rc_layout);
        holder.progressBar = (ProgressBar)this.findViewById(result, R.id.rc_progress);
        holder.warning = (ImageView)this.findViewById(result, R.id.rc_warning);
        holder.readReceipt = (TextView)this.findViewById(result, R.id.rc_read_receipt);
        holder.readReceiptRequest = (TextView)this.findViewById(result, R.id.rc_read_receipt_request);
        holder.readReceiptStatus = (TextView)this.findViewById(result, R.id.rc_read_receipt_status);
        holder.message_check = (CheckBox)this.findViewById(result, R.id.message_check);
        holder.checkboxLayout = (LinearLayout)this.findViewById(result, R.id.ll_message_check);
        holder.time = (TextView)this.findViewById(result, R.id.rc_time);
        holder.sentStatus = (TextView)this.findViewById(result, R.id.rc_sent_status);
        holder.layoutItem = (RelativeLayout)this.findViewById(result, R.id.rc_layout_item_message);
        holder.sendTimeView = (TextView)this.findViewById(result, R.id.countdown_time_send);
        holder.receiveTimeView = (TextView)this.findViewById(result, R.id.countdown_time_receive);
        this.timeGone = holder.time.getVisibility() == 8;
        result.setTag((Object)holder);
        return result;
    }

    protected boolean getNeedEvaluate(UIMessage data) {
        String extra = "";
        String robotEva = "";
        String sid = "";
        if (data != null && data.getConversationType() != null && data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE)) {
            if (data.getContent() instanceof TextMessage) {
                extra = ((TextMessage)data.getContent()).getExtra();
                if (TextUtils.isEmpty((CharSequence)extra)) {
                    return false;
                }
                try {
                    JSONObject jsonObj = new JSONObject(extra);
                    robotEva = jsonObj.optString("robotEva");
                    sid = jsonObj.optString("sid");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (data.getMessageDirection() == Message.MessageDirection.RECEIVE && data.getContent() instanceof TextMessage && this.evaForRobot && this.robotMode && !TextUtils.isEmpty((CharSequence)robotEva) && !TextUtils.isEmpty((CharSequence)sid) && !data.getIsHistoryMessage()) {
                return true;
            }
        }
        return false;
    }

    public List<Message> getCheckedMessage() {
        ArrayList<Message> checkedMessage = new ArrayList<Message>();
        for (int i = 0; i < this.getCount(); ++i) {
            UIMessage uiMessage = (UIMessage)this.getItem(i);
            if (!uiMessage.isChecked()) continue;
            checkedMessage.add(uiMessage.getMessage());
        }
        return checkedMessage;
    }

    private void bindViewClickEvent(View convertView, View contentView, final int position, final UIMessage data) {
        final ViewHolder holder = (ViewHolder)convertView.getTag();
        View.OnClickListener viewClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (MessageListAdapter.this.isShowCheckbox()) {
                    boolean checked;
                    boolean bl = checked = !data.isChecked();
                    if (MessageListAdapter.this.maxMessageSelectedCount != -1 && MessageListAdapter.this.getCheckedMessage().size() >= MessageListAdapter.this.maxMessageSelectedCount && checked) {
                        if (MessageListAdapter.this.selectedCountDidExceed != null) {
                            MessageListAdapter.this.selectedCountDidExceed.onSelectedCountDidExceed();
                        }
                        return;
                    }
                    data.setChecked(checked);
                    holder.message_check.setChecked(checked);
                    if (MessageListAdapter.this.messageCheckedChanged != null) {
                        MessageListAdapter.this.messageCheckedChanged.onCheckedEnable(MessageListAdapter.this.getCheckedMessage().size() > 0);
                    }
                }
            }
        };
        View.OnTouchListener viewTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (MessageListAdapter.this.isShowCheckbox() && event.getAction() == 1) {
                    boolean checked;
                    boolean bl = checked = !data.isChecked();
                    if (MessageListAdapter.this.maxMessageSelectedCount != -1 && MessageListAdapter.this.getCheckedMessage().size() >= MessageListAdapter.this.maxMessageSelectedCount && checked) {
                        if (MessageListAdapter.this.selectedCountDidExceed != null) {
                            MessageListAdapter.this.selectedCountDidExceed.onSelectedCountDidExceed();
                        }
                        return true;
                    }
                    data.setChecked(checked);
                    holder.message_check.setChecked(checked);
                    if (MessageListAdapter.this.messageCheckedChanged != null) {
                        MessageListAdapter.this.messageCheckedChanged.onCheckedEnable(MessageListAdapter.this.getCheckedMessage().size() > 0);
                    }
                    return true;
                }
                return false;
            }
        };
        NoDoubleClickListener contentClickListener = new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                if (RongContext.getInstance().getConversationBehaviorListener() != null ? RongContext.getInstance().getConversationBehaviorListener().onMessageClick(MessageListAdapter.this.mContext, v, data.getMessage()) : RongContext.getInstance().getConversationClickListener() != null && RongContext.getInstance().getConversationClickListener().onMessageClick(MessageListAdapter.this.mContext, v, data.getMessage())) {
                    return;
                }
                IContainerItemProvider.MessageProvider provider = MessageListAdapter.this.getNeedEvaluate(data) ? RongContext.getInstance().getEvaluateProvider() : RongContext.getInstance().getMessageTemplate(data.getContent().getClass());
                if (provider != null) {
                    provider.onItemClick(v, position, data.getContent(), data);
                }
            }

            public void onClick(View v) {
                long currentTime = Calendar.getInstance().getTimeInMillis();
                if (currentTime - this.lastClickTime > 500L) {
                    this.lastClickTime = currentTime;
                    this.onNoDoubleClick(v);
                }
            }
        };
        View.OnLongClickListener contentLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (MessageListAdapter.this.isShowCheckbox()) {
                    return true;
                }
                if (RongContext.getInstance().getConversationBehaviorListener() != null ? RongContext.getInstance().getConversationBehaviorListener().onMessageLongClick(MessageListAdapter.this.mContext, v, data.getMessage()) : RongContext.getInstance().getConversationClickListener() != null && RongContext.getInstance().getConversationClickListener().onMessageLongClick(MessageListAdapter.this.mContext, v, data.getMessage())) {
                    return true;
                }
                IContainerItemProvider.MessageProvider provider = MessageListAdapter.this.getNeedEvaluate(data) ? RongContext.getInstance().getEvaluateProvider() : RongContext.getInstance().getMessageTemplate(data.getContent().getClass());
                if (provider != null) {
                    provider.onItemLongClick(v, position, data.getContent(), data);
                }
                return true;
            }
        };
        View.OnClickListener iconClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                UserInfo userInfo = data.getUserInfo();
                if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                    if (userInfo == null) {
                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                    }
                    UserInfo userInfo2 = userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), null, null) : userInfo;
                }
                if (RongContext.getInstance().getConversationBehaviorListener() != null) {
                    RongContext.getInstance().getConversationBehaviorListener().onUserPortraitClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo);
                } else if (RongContext.getInstance().getConversationClickListener() != null) {
                    RongContext.getInstance().getConversationClickListener().onUserPortraitClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo, data.getTargetId());
                }
            }
        };
        View.OnLongClickListener iconLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                GroupUserInfo groupUserInfo;
                UserInfo userInfo = data.getUserInfo();
                if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                    if (userInfo == null) {
                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                    }
                    UserInfo userInfo2 = userInfo = userInfo == null ? new UserInfo(data.getSenderUserId(), null, null) : userInfo;
                }
                if (data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(data.getTargetId(), data.getSenderUserId())) != null && !TextUtils.isEmpty((CharSequence)groupUserInfo.getNickname()) && userInfo != null) {
                    userInfo.setName(groupUserInfo.getNickname());
                }
                if (data.getMessageDirection().equals((Object)Message.MessageDirection.SEND)) {
                    if (RongContext.getInstance().getConversationBehaviorListener() != null) {
                        return RongContext.getInstance().getConversationBehaviorListener().onUserPortraitLongClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo);
                    }
                    if (RongContext.getInstance().getConversationClickListener() != null) {
                        return RongContext.getInstance().getConversationClickListener().onUserPortraitLongClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo, data.getTargetId());
                    }
                } else {
                    Object conversationListener = RongContext.getInstance().getConversationListener();
                    if (conversationListener != null && (conversationListener instanceof RongIM.ConversationClickListener && ((RongIM.ConversationClickListener)conversationListener).onUserPortraitLongClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo, data.getTargetId()) || conversationListener instanceof RongIM.ConversationBehaviorListener && ((RongIM.ConversationBehaviorListener)conversationListener).onUserPortraitLongClick(MessageListAdapter.this.mContext, data.getConversationType(), userInfo))) {
                        return true;
                    }
                    if (RongContext.getInstance().getResources().getBoolean(R.bool.rc_enable_mentioned_message) && (data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) || data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION))) {
                        RongMentionManager.getInstance().mentionMember(data.getConversationType(), data.getTargetId(), data.getSenderUserId());
                        return true;
                    }
                }
                return true;
            }
        };
        if (this.isShowCheckbox() && this.allowShowCheckButton(data.getMessage())) {
            convertView.setOnClickListener(viewClickListener);
            contentView.setOnTouchListener(viewTouchListener);
            holder.rightIconView.setOnClickListener(viewClickListener);
            holder.leftIconView.setOnClickListener(viewClickListener);
        } else {
            contentView.setOnClickListener((View.OnClickListener)contentClickListener);
            contentView.setOnLongClickListener(contentLongClickListener);
            holder.rightIconView.setOnClickListener(iconClickListener);
            holder.leftIconView.setOnClickListener(iconClickListener);
            holder.rightIconView.setOnLongClickListener(iconLongClickListener);
            holder.leftIconView.setOnLongClickListener(iconLongClickListener);
        }
        holder.warning.setOnClickListener((View.OnClickListener)new DebouncedOnClickListener(){

            @Override
            public void onDebouncedClick(View view) {
                if (MessageListAdapter.this.getItemHandlerListener() != null) {
                    MessageListAdapter.this.getItemHandlerListener().onWarningViewClick(position, data.getMessage(), view);
                }
            }
        });
    }

    @Override
    protected void bindView(View v, int position, final UIMessage data) {
        Uri portrait;
        ProviderTag tag;
        IContainerItemProvider.MessageProvider provider;
        if (data == null) {
            return;
        }
        final ViewHolder holder = (ViewHolder)v.getTag();
        if (holder == null) {
            RLog.e((String)TAG, (String)"view holder is null !");
            return;
        }
        if (this.getNeedEvaluate(data)) {
            provider = RongContext.getInstance().getEvaluateProvider();
            tag = RongContext.getInstance().getMessageProviderTag(data.getContent().getClass());
        } else if (RongContext.getInstance() != null && data.getContent() != null) {
            provider = RongContext.getInstance().getMessageTemplate(data.getContent().getClass());
            if (provider == null) {
                provider = RongContext.getInstance().getMessageTemplate(UnknownMessage.class);
                tag = RongContext.getInstance().getMessageProviderTag(UnknownMessage.class);
            } else {
                tag = RongContext.getInstance().getMessageProviderTag(data.getContent().getClass());
            }
            if (provider == null) {
                RLog.e((String)TAG, (String)(data.getObjectName() + " message provider not found !"));
                return;
            }
        } else {
            RLog.e((String)TAG, (String)"Message is null !");
            return;
        }
        View v1 = null;
        try {
            v1 = holder.contentView.inflate(provider);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"bindView contentView inflate error", (Throwable)e);
            provider = RongContext.getInstance().getMessageTemplate(UnknownMessage.class);
            tag = RongContext.getInstance().getMessageProviderTag(UnknownMessage.class);
            v1 = holder.contentView.inflate(provider);
        }
        final View view = v1;
        provider.bindView(view, position, data);
        if (tag == null) {
            RLog.e((String)TAG, (String)("Can not find ProviderTag for " + data.getObjectName()));
            return;
        }
        if (tag.hide()) {
            holder.contentView.setVisibility(8);
            holder.time.setVisibility(8);
            holder.nameView.setVisibility(8);
            holder.leftIconView.setVisibility(8);
            holder.rightIconView.setVisibility(8);
            holder.layoutItem.setVisibility(8);
            holder.layoutItem.setPadding(0, 0, 0, 0);
        } else {
            holder.contentView.setVisibility(0);
            holder.layoutItem.setVisibility(0);
            holder.layoutItem.setPadding(RongUtils.dip2px(8.0f), RongUtils.dip2px(6.0f), RongUtils.dip2px(8.0f), RongUtils.dip2px(6.0f));
        }
        if (data.getContent().isDestruct()) {
            this.updateCountDownView(holder, v, position, data);
        }
        if (data.getMessageDirection() == Message.MessageDirection.SEND) {
            if (tag.showPortrait()) {
                holder.rightIconView.setVisibility(0);
                holder.leftIconView.setVisibility(8);
            } else {
                holder.leftIconView.setVisibility(8);
                holder.rightIconView.setVisibility(8);
            }
            if (!tag.centerInHorizontal()) {
                this.setGravity((View)holder.layout, 5);
                holder.contentView.containerViewRight();
                holder.nameView.setGravity(5);
            } else {
                this.setGravity((View)holder.layout, 17);
                holder.contentView.containerViewCenter();
                holder.nameView.setGravity(1);
                holder.contentView.setBackgroundColor(0);
            }
            boolean readRec = false;
            try {
                readRec = this.mContext.getResources().getBoolean(R.bool.rc_read_receipt);
            }
            catch (Resources.NotFoundException e) {
                RLog.e((String)TAG, (String)"bindView rc_read_receipt not configure in rc_config.xml", (Throwable)e);
            }
            if (data.getSentStatus() == Message.SentStatus.SENDING) {
                if (tag.showProgress()) {
                    holder.progressBar.setVisibility(0);
                } else {
                    holder.progressBar.setVisibility(8);
                }
                holder.warning.setVisibility(8);
                holder.readReceipt.setVisibility(8);
            } else if (data.getSentStatus() == Message.SentStatus.FAILED) {
                holder.progressBar.setVisibility(8);
                holder.warning.setVisibility(0);
                holder.readReceipt.setVisibility(8);
            } else if (data.getSentStatus() == Message.SentStatus.SENT) {
                holder.progressBar.setVisibility(8);
                holder.warning.setVisibility(8);
                holder.readReceipt.setVisibility(8);
            } else if (readRec && data.getSentStatus() == Message.SentStatus.READ) {
                holder.progressBar.setVisibility(8);
                holder.warning.setVisibility(8);
                if (data.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE) && tag.showReadState()) {
                    holder.readReceipt.setVisibility(0);
                } else {
                    holder.readReceipt.setVisibility(8);
                }
            } else {
                holder.progressBar.setVisibility(8);
                holder.warning.setVisibility(8);
                holder.readReceipt.setVisibility(8);
            }
            holder.readReceiptRequest.setVisibility(8);
            holder.readReceiptStatus.setVisibility(8);
            if (readRec && RongContext.getInstance().isReadReceiptConversationType(data.getConversationType()) && (data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) || data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION))) {
                if (this.allowReadReceiptRequest(data.getMessage()) && !TextUtils.isEmpty((CharSequence)data.getUId())) {
                    long serverTime;
                    boolean isLastSentMessage = true;
                    for (int i = position + 1; i < this.getCount(); ++i) {
                        if (((UIMessage)this.getItem(i)).getMessageDirection() != Message.MessageDirection.SEND) continue;
                        isLastSentMessage = false;
                        break;
                    }
                    if ((serverTime = System.currentTimeMillis() - RongIMClient.getInstance().getDeltaTime()) - data.getSentTime() < readReceiptRequestInterval * 1000L && isLastSentMessage && (data.getReadReceiptInfo() == null || !data.getReadReceiptInfo().isReadReceiptMessage())) {
                        holder.readReceiptRequest.setVisibility(0);
                    }
                }
                if (this.allowReadReceiptRequest(data.getMessage()) && data.getReadReceiptInfo() != null && data.getReadReceiptInfo().isReadReceiptMessage()) {
                    if (data.getReadReceiptInfo().getRespondUserIdList() != null) {
                        holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), data.getReadReceiptInfo().getRespondUserIdList().size()));
                    } else {
                        holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), 0));
                    }
                    holder.readReceiptStatus.setVisibility(0);
                }
            }
            holder.nameView.setVisibility(8);
            holder.readReceiptRequest.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RongIMClient.getInstance().sendReadReceiptRequest(data.getMessage(), new RongIMClient.OperationCallback(){

                        public void onSuccess() {
                            ReadReceiptInfo readReceiptInfo = data.getReadReceiptInfo();
                            if (readReceiptInfo == null) {
                                readReceiptInfo = new ReadReceiptInfo();
                                data.setReadReceiptInfo(readReceiptInfo);
                            }
                            readReceiptInfo.setIsReadReceiptMessage(true);
                            holder.readReceiptStatus.setText((CharSequence)String.format(view.getResources().getString(R.string.rc_read_receipt_status), 0));
                            holder.readReceiptRequest.setVisibility(8);
                            holder.readReceiptStatus.setVisibility(0);
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                            RLog.e((String)MessageListAdapter.TAG, (String)("sendReadReceiptRequest failed, errorCode = " + errorCode));
                        }
                    });
                }
            });
            holder.readReceiptStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MessageListAdapter.this.mOnItemHandlerListener != null) {
                        MessageListAdapter.this.mOnItemHandlerListener.onReadReceiptStateClick(data.getMessage());
                    }
                }
            });
            if (!tag.showWarning()) {
                holder.warning.setVisibility(8);
            }
            holder.receiveTimeView.setVisibility(8);
            if (data.getContent().isDestruct()) {
                holder.sendTimeView.setVisibility(0);
            }
        } else {
            if (tag.showPortrait()) {
                holder.rightIconView.setVisibility(8);
                holder.leftIconView.setVisibility(0);
            } else {
                holder.leftIconView.setVisibility(8);
                holder.rightIconView.setVisibility(8);
            }
            if (!tag.centerInHorizontal()) {
                this.setGravity((View)holder.layout, 3);
                holder.contentView.containerViewLeft();
                holder.nameView.setGravity(3);
            } else {
                this.setGravity((View)holder.layout, 17);
                holder.contentView.containerViewCenter();
                holder.nameView.setGravity(1);
                holder.contentView.setBackgroundColor(0);
            }
            holder.progressBar.setVisibility(8);
            holder.warning.setVisibility(8);
            holder.readReceipt.setVisibility(8);
            holder.readReceiptRequest.setVisibility(8);
            holder.readReceiptStatus.setVisibility(8);
            holder.nameView.setVisibility(0);
            if (data.getConversationType() == Conversation.ConversationType.PRIVATE || !tag.showSummaryWithName() || data.getConversationType() == Conversation.ConversationType.PUBLIC_SERVICE || data.getConversationType() == Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                holder.nameView.setVisibility(8);
            } else {
                UserInfo userInfo = data.getUserInfo();
                if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                    if (userInfo == null && data.getMessage() != null && data.getMessage().getContent() != null) {
                        userInfo = data.getMessage().getContent().getUserInfo();
                    }
                    if (userInfo != null) {
                        holder.nameView.setText((CharSequence)userInfo.getName());
                    } else {
                        holder.nameView.setText((CharSequence)data.getSenderUserId());
                    }
                } else if (data.getConversationType() == Conversation.ConversationType.GROUP) {
                    GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(data.getTargetId(), data.getSenderUserId());
                    if (groupUserInfo != null && !TextUtils.isEmpty((CharSequence)groupUserInfo.getNickname())) {
                        holder.nameView.setText((CharSequence)groupUserInfo.getNickname());
                    } else {
                        if (userInfo == null) {
                            userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                        }
                        if (userInfo == null) {
                            holder.nameView.setText((CharSequence)data.getSenderUserId());
                        } else {
                            holder.nameView.setText((CharSequence)userInfo.getName());
                        }
                    }
                } else {
                    if (userInfo == null) {
                        userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                    }
                    if (userInfo == null) {
                        holder.nameView.setText((CharSequence)data.getSenderUserId());
                    } else {
                        holder.nameView.setText((CharSequence)userInfo.getName());
                    }
                }
            }
            holder.sendTimeView.setVisibility(8);
            if (data.getContent().isDestruct()) {
                holder.receiveTimeView.setVisibility(0);
            }
        }
        if (!data.getContent().isDestruct()) {
            holder.sendTimeView.setVisibility(8);
            holder.receiveTimeView.setVisibility(8);
        }
        if (holder.rightIconView.getVisibility() == 0) {
            UserInfo userInfo = data.getUserInfo();
            portrait = null;
            if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getUserInfo() != null && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                if (userInfo != null) {
                    portrait = userInfo.getPortraitUri();
                }
                holder.rightIconView.setAvatar(portrait != null ? portrait.toString() : null, 0);
            } else if ((data.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) || data.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE)) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                if (userInfo != null) {
                    portrait = userInfo.getPortraitUri();
                    holder.rightIconView.setAvatar(portrait != null ? portrait.toString() : null, 0);
                } else {
                    ConversationKey mKey = ConversationKey.obtain(data.getTargetId(), data.getConversationType());
                    PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                    portrait = publicServiceProfile.getPortraitUri();
                    holder.rightIconView.setAvatar(portrait != null ? portrait.toString() : null, 0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                if (userInfo == null) {
                    userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                }
                if (userInfo != null && userInfo.getPortraitUri() != null) {
                    holder.rightIconView.setAvatar(userInfo.getPortraitUri().toString(), 0);
                } else {
                    holder.rightIconView.setAvatar(null, 0);
                }
            }
        } else if (holder.leftIconView.getVisibility() == 0) {
            UserInfo userInfo = data.getUserInfo();
            portrait = null;
            if (data.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                if (userInfo == null && data.getMessage() != null && data.getMessage().getContent() != null) {
                    userInfo = data.getMessage().getContent().getUserInfo();
                }
                if (userInfo != null) {
                    portrait = userInfo.getPortraitUri();
                    holder.leftIconView.setAvatar(portrait != null ? portrait.toString() : null, R.drawable.rc_cs_default_portrait);
                }
            } else if ((data.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) || data.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE)) && data.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                if (userInfo != null) {
                    portrait = userInfo.getPortraitUri();
                    holder.leftIconView.setAvatar(portrait != null ? portrait.toString() : null, 0);
                } else {
                    ConversationKey mKey = ConversationKey.obtain(data.getTargetId(), data.getConversationType());
                    PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                    if (publicServiceProfile != null && publicServiceProfile.getPortraitUri() != null) {
                        holder.leftIconView.setAvatar(publicServiceProfile.getPortraitUri().toString(), 0);
                    } else {
                        holder.leftIconView.setAvatar(null, 0);
                    }
                }
            } else if (!TextUtils.isEmpty((CharSequence)data.getSenderUserId())) {
                if (userInfo == null) {
                    userInfo = RongUserInfoManager.getInstance().getUserInfo(data.getSenderUserId());
                }
                if (userInfo != null && userInfo.getPortraitUri() != null) {
                    holder.leftIconView.setAvatar(userInfo.getPortraitUri().toString(), 0);
                } else {
                    holder.leftIconView.setAvatar(null, 0);
                }
            }
        }
        this.bindViewClickEvent(v, view, position, data);
        if (tag.hide()) {
            holder.time.setVisibility(8);
            return;
        }
        if (!this.timeGone) {
            String time = RongDateUtils.getConversationFormatDate(data.getSentTime(), view.getContext());
            holder.time.setText((CharSequence)time);
            if (position == 0) {
                if (data.getMessage() != null && data.getMessage().getContent() != null && data.getMessage().getContent() instanceof HistoryDividerMessage) {
                    holder.time.setVisibility(8);
                } else {
                    holder.time.setVisibility(0);
                }
            } else {
                UIMessage pre = (UIMessage)this.getItem(position - 1);
                if (RongDateUtils.isShowChatTime(data.getSentTime(), pre.getSentTime(), 180)) {
                    holder.time.setVisibility(0);
                } else {
                    holder.time.setVisibility(8);
                }
            }
        }
        if (this.isShowCheckbox() && this.allowShowCheckButton(data.getMessage())) {
            holder.checkboxLayout.setVisibility(0);
            holder.message_check.setFocusable(false);
            holder.message_check.setClickable(false);
            holder.message_check.setChecked(data.isChecked());
        } else {
            holder.checkboxLayout.setVisibility(8);
            data.setChecked(false);
        }
        if (this.messageCheckedChanged != null) {
            this.messageCheckedChanged.onCheckedEnable(this.getCheckedMessage().size() > 0);
        }
    }

    private void updateCountDownView(final ViewHolder holder, final View v, int position, final UIMessage data) {
        MessageContent messageContent = data.getContent();
        if (data.getMessage().getReadTime() > 0L) {
            long readTime = data.getMessage().getReadTime();
            long serverTime = System.currentTimeMillis() - RongIMClient.getInstance().getDeltaTime();
            long delay = messageContent.getDestructTime() - (serverTime - readTime) / 1000L;
            if (delay <= 0L) {
                this.remove(position);
                this.notifyDataSetChanged();
                return;
            }
            if (data.getMessageDirection() == Message.MessageDirection.RECEIVE) {
                if (delay <= 30L) {
                    String leftTime = this.mContext.getResources().getString(R.string.rc_time_count_down, new Object[]{delay});
                    holder.receiveTimeView.setText((CharSequence)leftTime);
                    holder.receiveTimeView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                } else {
                    Drawable drawable2 = this.mContext.getResources().getDrawable(R.drawable.rc_count_down_message_bubble);
                    holder.receiveTimeView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
                    holder.receiveTimeView.setText(null);
                }
            } else if (delay <= 30L) {
                String leftTime = this.mContext.getResources().getString(R.string.rc_time_count_down, new Object[]{delay});
                holder.sendTimeView.setText((CharSequence)leftTime);
                holder.sendTimeView.setCompoundDrawables(null, null, null, null);
            } else {
                Drawable drawable3 = this.mContext.getResources().getDrawable(R.drawable.rc_count_down_message_bubble);
                holder.sendTimeView.setCompoundDrawablesWithIntrinsicBounds(drawable3, null, null, null);
                holder.sendTimeView.setText(null);
            }
            holder.time.setTag((Object)data.getMessage().getMessageId());
            RongIM.getInstance().createDestructionTask(data.getMessage(), new DestructionTaskManager.OnOverTimeChangeListener(){

                public void onOverTimeChanged(final int messageId, final long leftTime) {
                    v.post(new Runnable(){

                        @Override
                        public void run() {
                            if (leftTime <= 30L) {
                                Object msgIdTag = holder.time.getTag();
                                int tag = -1;
                                if (msgIdTag != null) {
                                    tag = (Integer)msgIdTag;
                                }
                                if (tag == messageId) {
                                    String time = MessageListAdapter.this.mContext.getResources().getString(R.string.rc_time_count_down, new Object[]{leftTime});
                                    if (data.getMessageDirection() == Message.MessageDirection.RECEIVE) {
                                        holder.receiveTimeView.setText((CharSequence)time);
                                        holder.receiveTimeView.setCompoundDrawables(null, null, null, null);
                                    } else {
                                        holder.sendTimeView.setText((CharSequence)time);
                                        holder.sendTimeView.setCompoundDrawables(null, null, null, null);
                                    }
                                }
                                return;
                            }
                        }
                    });
                }

                public void onMessageDestruct(int messageId) {
                }
            }, "ConversationFragment");
        }
    }

    protected void setGravity(View view, int gravity) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)view.getLayoutParams();
        params.gravity = gravity;
    }

    public void setEvaluateForRobot(boolean needEvaluate) {
        this.evaForRobot = needEvaluate;
    }

    public void setRobotMode(boolean robotMode) {
        this.robotMode = robotMode;
    }

    public boolean allowReadReceiptRequest(Message message) {
        return message != null && message.getContent() != null && message.getContent() instanceof TextMessage;
    }

    protected boolean allowShowCheckButton(Message message) {
        MessageContent messageContent;
        return message == null || (messageContent = message.getContent()) == null || !(messageContent instanceof InformationNotificationMessage) && !(messageContent instanceof GroupNotificationMessage) && !(messageContent instanceof RecallNotificationMessage) && !(messageContent instanceof RealTimeLocationStartMessage) && !(messageContent instanceof RealTimeLocationJoinMessage);
    }

    private abstract class NoDoubleClickListener
    implements View.OnClickListener {
        public static final int MIN_CLICK_DELAY_TIME = 500;
        public long lastClickTime = 0L;

        private NoDoubleClickListener() {
        }

        public abstract void onNoDoubleClick(View var1);
    }

    public static interface OnItemHandlerListener {
        public boolean onWarningViewClick(int var1, Message var2, View var3);

        public void onReadReceiptStateClick(Message var1);
    }

    public static interface OnMessageCheckedChanged {
        public void onCheckedEnable(boolean var1);
    }

    public static interface OnSelectedCountDidExceed {
        public void onSelectedCountDidExceed();
    }

    protected class ViewHolder {
        public AsyncImageView leftIconView;
        public AsyncImageView rightIconView;
        public TextView nameView;
        public ProviderContainerView contentView;
        public ProgressBar progressBar;
        public ImageView warning;
        public TextView readReceipt;
        public TextView readReceiptRequest;
        public TextView readReceiptStatus;
        public ViewGroup layout;
        public TextView time;
        public TextView sentStatus;
        public RelativeLayout layoutItem;
        public CheckBox message_check;
        public LinearLayout checkboxLayout;
        public TextView sendTimeView;
        public TextView receiveTimeView;

        protected ViewHolder() {
        }
    }
}

