/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.AutoLinkTextView;
import io.rong.imkit.widget.ILinkClickListener;
import io.rong.imkit.widget.LinkTextViewMovementMethod;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class EvaluateTextMessageItemProvider
extends IContainerItemProvider.MessageProvider<TextMessage> {
    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_text_message_evaluate, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (AutoLinkTextView)view.findViewById(R.id.evaluate_text);
        holder.tv_prompt = (TextView)view.findViewById(R.id.tv_prompt);
        holder.iv_yes = (ImageView)view.findViewById(R.id.iv_yes);
        holder.iv_no = (ImageView)view.findViewById(R.id.iv_no);
        holder.iv_complete = (ImageView)view.findViewById(R.id.iv_complete);
        holder.layout_praise = (RelativeLayout)view.findViewById(R.id.layout_praise);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public Spannable getContentSummary(TextMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, TextMessage data) {
        if (data == null) {
            return null;
        }
        String content = data.getContent();
        if (content != null) {
            if (content.length() > 100) {
                content = content.substring(0, 100);
            }
            return new SpannableString(AndroidEmoji.ensure(content));
        }
        return null;
    }

    @Override
    public void onItemClick(View view, int position, TextMessage content, UIMessage message) {
    }

    @Override
    public void bindView(final View v, final int position, final TextMessage content, final UIMessage data) {
        final ViewHolder holder = (ViewHolder)v.getTag();
        if (data.getMessageDirection() == Message.MessageDirection.SEND) {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_right);
        } else {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_left);
        }
        if (data.getEvaluated()) {
            holder.iv_yes.setVisibility(8);
            holder.iv_no.setVisibility(8);
            holder.iv_complete.setVisibility(0);
            holder.tv_prompt.setText((CharSequence)"\u611f\u8c22\u60a8\u7684\u8bc4\u4ef7");
        } else {
            holder.iv_yes.setVisibility(0);
            holder.iv_no.setVisibility(0);
            holder.iv_complete.setVisibility(8);
            holder.tv_prompt.setText((CharSequence)"\u60a8\u5bf9\u6211\u7684\u56de\u7b54");
        }
        holder.iv_yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String extra = ((TextMessage)data.getContent()).getExtra();
                String knowledgeId = "";
                if (!TextUtils.isEmpty((CharSequence)extra)) {
                    try {
                        JSONObject jsonObj = new JSONObject(extra);
                        knowledgeId = jsonObj.optString("sid");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                RongIMClient.getInstance().evaluateCustomService(data.getSenderUserId(), true, knowledgeId);
                holder.iv_complete.setVisibility(0);
                holder.iv_yes.setVisibility(8);
                holder.iv_no.setVisibility(8);
                holder.tv_prompt.setText((CharSequence)"\u611f\u8c22\u60a8\u7684\u8bc4\u4ef7");
                data.setEvaluated(true);
            }
        });
        holder.iv_no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String extra = ((TextMessage)data.getContent()).getExtra();
                String knowledgeId = "";
                if (!TextUtils.isEmpty((CharSequence)extra)) {
                    try {
                        JSONObject jsonObj = new JSONObject(extra);
                        knowledgeId = jsonObj.optString("sid");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                RongIMClient.getInstance().evaluateCustomService(data.getSenderUserId(), false, knowledgeId);
                holder.iv_complete.setVisibility(0);
                holder.iv_yes.setVisibility(8);
                holder.iv_no.setVisibility(8);
                holder.tv_prompt.setText((CharSequence)"\u611f\u8c22\u60a8\u7684\u8bc4\u4ef7");
                data.setEvaluated(true);
            }
        });
        final AutoLinkTextView textView = holder.message;
        if (data.getTextMessageContent() != null) {
            int len = data.getTextMessageContent().length();
            if (v.getHandler() != null && len > 500) {
                v.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        textView.setText((CharSequence)data.getTextMessageContent());
                    }
                }, 50L);
            } else {
                textView.setText((CharSequence)data.getTextMessageContent());
            }
        }
        holder.message.setClickable(true);
        holder.message.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        holder.message.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v1) {
                EvaluateTextMessageItemProvider.this.onItemLongClick(v, position, content, data);
                return false;
            }
        });
        holder.message.setMovementMethod((MovementMethod)new LinkTextViewMovementMethod(new ILinkClickListener(){

            @Override
            public boolean onLinkClick(String link) {
                String str;
                RongIM.ConversationBehaviorListener listener = RongContext.getInstance().getConversationBehaviorListener();
                RongIM.ConversationClickListener clickListener = RongContext.getInstance().getConversationClickListener();
                boolean result = false;
                if (listener != null) {
                    result = listener.onMessageLinkClick(v.getContext(), link);
                } else if (clickListener != null) {
                    result = clickListener.onMessageLinkClick(v.getContext(), link, data.getMessage());
                }
                if ((listener == null && clickListener == null || !result) && ((str = link.toLowerCase()).startsWith("http") || str.startsWith("https"))) {
                    Intent intent = new Intent("io.rong.imkit.intent.action.webview");
                    intent.setPackage(v.getContext().getPackageName());
                    intent.putExtra("url", link);
                    v.getContext().startActivity(intent);
                    result = true;
                }
                return result;
            }
        }));
    }

    private static class ViewHolder {
        AutoLinkTextView message;
        TextView tv_prompt;
        ImageView iv_yes;
        ImageView iv_no;
        ImageView iv_complete;
        RelativeLayout layout_praise;
        boolean longClick;

        private ViewHolder() {
        }
    }
}

