/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.GroupNotificationMessageData;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.UserInfo;
import io.rong.message.GroupNotificationMessage;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@ProviderTag(messageContent=GroupNotificationMessage.class, showPortrait=false, centerInHorizontal=true, showProgress=false, showSummaryWithName=false)
public class GroupNotificationMessageItemProvider
extends IContainerItemProvider.MessageProvider<GroupNotificationMessage> {
    private static final String TAG = GroupNotificationMessageItemProvider.class.getSimpleName();

    @Override
    public void bindView(View view, int i, GroupNotificationMessage groupNotificationMessage, UIMessage uiMessage) {
        block35: {
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            try {
                String operator;
                UserInfo userInfo;
                GroupNotificationMessageData data;
                if (groupNotificationMessage == null || uiMessage == null) break block35;
                if (groupNotificationMessage != null && groupNotificationMessage.getData() == null) {
                    return;
                }
                try {
                    data = this.jsonToBean(groupNotificationMessage.getData());
                }
                catch (Exception e) {
                    RLog.e((String)TAG, (String)"bindView", (Throwable)e);
                    return;
                }
                String operation = groupNotificationMessage.getOperation();
                String operatorNickname = data.getOperatorNickname();
                String operatorUserId = groupNotificationMessage.getOperatorUserId();
                String currentUserId = RongIM.getInstance().getCurrentUserId();
                if (operatorNickname == null && (userInfo = RongUserInfoManager.getInstance().getUserInfo(operatorUserId)) != null && (operatorNickname = userInfo.getName()) == null) {
                    operatorNickname = groupNotificationMessage.getOperatorUserId();
                }
                List<String> memberList = data.getTargetUserDisplayNames();
                List<String> memberIdList = data.getTargetUserIds();
                String memberName = null;
                String memberUserId = null;
                RongContext context = RongContext.getInstance();
                if (memberIdList != null && memberIdList.size() == 1) {
                    memberUserId = memberIdList.get(0);
                }
                if (memberList != null) {
                    if (memberList.size() == 1) {
                        memberName = memberList.get(0);
                    } else if (memberIdList.size() > 1) {
                        StringBuilder sb = new StringBuilder();
                        for (String s : memberList) {
                            sb.append(s);
                            sb.append(context.getString(R.string.rc_item_divided_string));
                        }
                        String str = sb.toString();
                        memberName = str.substring(0, str.length() - 1);
                    }
                }
                if (TextUtils.isEmpty((CharSequence)operation)) break block35;
                if (operation.equals("Add")) {
                    if (operatorUserId.equals(memberUserId)) {
                        viewHolder.contentTextView.setText((CharSequence)(memberName + context.getString(R.string.rc_item_join_group)));
                    } else {
                        Object inviteMsg;
                        String invitedName;
                        if (!groupNotificationMessage.getOperatorUserId().equals(RongIM.getInstance().getCurrentUserId())) {
                            String inviteName = operatorNickname;
                            invitedName = memberName;
                            inviteMsg = context.getString(R.string.rc_item_invitation, new Object[]{inviteName, invitedName});
                        } else {
                            invitedName = memberName;
                            inviteMsg = context.getString(R.string.rc_item_you_invitation, new Object[]{invitedName});
                        }
                        viewHolder.contentTextView.setText((CharSequence)inviteMsg);
                    }
                    break block35;
                }
                if (operation.equals("Kicked")) {
                    if (memberIdList != null) {
                        for (String userId : memberIdList) {
                            String removeMsg;
                            String kickedName;
                            if (currentUserId.equals(userId)) {
                                operator = operatorNickname;
                                viewHolder.contentTextView.setText((CharSequence)context.getString(R.string.rc_item_you_remove_self, new Object[]{operator}));
                                continue;
                            }
                            if (!operatorUserId.equals(currentUserId)) {
                                operator = operatorNickname;
                                kickedName = memberName;
                                removeMsg = context.getString(R.string.rc_item_remove_group_member, new Object[]{operator, kickedName});
                            } else {
                                kickedName = memberName;
                                removeMsg = context.getString(R.string.rc_item_you_remove_group_member, new Object[]{kickedName});
                            }
                            viewHolder.contentTextView.setText((CharSequence)removeMsg);
                        }
                    }
                    break block35;
                }
                if (operation.equals("Create")) {
                    String createMsg;
                    GroupNotificationMessageData createGroupData = new GroupNotificationMessageData();
                    try {
                        createGroupData = this.jsonToBean(groupNotificationMessage.getData());
                    }
                    catch (Exception e) {
                        RLog.e((String)TAG, (String)"bindView", (Throwable)e);
                        return;
                    }
                    if (!operatorUserId.equals(currentUserId)) {
                        String name = operatorNickname;
                        createMsg = context.getString(R.string.rc_item_created_group, new Object[]{name});
                    } else {
                        createMsg = context.getString(R.string.rc_item_you_created_group);
                    }
                    viewHolder.contentTextView.setText((CharSequence)createMsg);
                    break block35;
                }
                if (operation.equals("Dismiss")) {
                    viewHolder.contentTextView.setText((CharSequence)(operatorNickname + context.getString(R.string.rc_item_dismiss_groups)));
                } else if (operation.equals("Quit")) {
                    viewHolder.contentTextView.setText((CharSequence)(operatorNickname + context.getString(R.string.rc_item_quit_groups)));
                } else if (operation.equals("Rename")) {
                    String changeMsg;
                    String groupName;
                    if (!operatorUserId.equals(currentUserId)) {
                        operator = operatorNickname;
                        groupName = data.getTargetGroupName();
                        changeMsg = context.getString(R.string.rc_item_change_group_name, new Object[]{operator, groupName});
                    } else {
                        groupName = data.getTargetGroupName();
                        changeMsg = context.getString(R.string.rc_item_you_change_group_name, new Object[]{groupName});
                    }
                    viewHolder.contentTextView.setText((CharSequence)changeMsg);
                }
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"bindView", (Throwable)e);
            }
        }
    }

    @Override
    public Spannable getContentSummary(GroupNotificationMessage groupNotificationMessage) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, GroupNotificationMessage groupNotificationMessage) {
        try {
            SpannableString spannableStringSummary;
            block39: {
                String operator;
                GroupNotificationMessageData data;
                if (groupNotificationMessage != null && groupNotificationMessage.getData() == null) {
                    return null;
                }
                try {
                    data = this.jsonToBean(groupNotificationMessage.getData());
                }
                catch (Exception e) {
                    RLog.e((String)TAG, (String)"getContentSummary", (Throwable)e);
                    return null;
                }
                String operation = groupNotificationMessage.getOperation();
                String operatorNickname = data.getOperatorNickname();
                String operatorUserId = groupNotificationMessage.getOperatorUserId();
                String currentUserId = RongIM.getInstance().getCurrentUserId();
                if (operatorNickname == null) {
                    UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(operatorUserId);
                    if (userInfo != null) {
                        operatorNickname = userInfo.getName();
                    }
                    if (operatorNickname == null) {
                        operatorNickname = groupNotificationMessage.getOperatorUserId();
                    }
                }
                List<String> memberList = data.getTargetUserDisplayNames();
                List<String> memberIdList = data.getTargetUserIds();
                String memberName = null;
                String memberUserId = null;
                if (memberIdList != null && memberIdList.size() == 1) {
                    memberUserId = memberIdList.get(0);
                }
                if (memberList != null) {
                    if (memberList.size() == 1) {
                        memberName = memberList.get(0);
                    } else if (memberIdList.size() > 1) {
                        StringBuilder sb = new StringBuilder();
                        for (String s : memberList) {
                            sb.append(s);
                            sb.append(context.getString(R.string.rc_item_divided_string));
                        }
                        String str = sb.toString();
                        memberName = str.substring(0, str.length() - 1);
                    }
                }
                spannableStringSummary = new SpannableString((CharSequence)"");
                if (operation.equals("Add")) {
                    try {
                        String invitationMsg;
                        String invitedName;
                        if (operatorUserId.equals(memberUserId)) {
                            spannableStringSummary = new SpannableString((CharSequence)(operatorNickname + context.getString(R.string.rc_item_join_group)));
                            break block39;
                        }
                        if (!operatorUserId.equals(currentUserId)) {
                            String inviteName = operatorNickname;
                            invitedName = memberName;
                            invitationMsg = context.getString(R.string.rc_item_invitation, new Object[]{inviteName, invitedName});
                        } else {
                            invitedName = memberName;
                            invitationMsg = context.getString(R.string.rc_item_you_invitation, new Object[]{invitedName});
                        }
                        spannableStringSummary = new SpannableString((CharSequence)invitationMsg);
                    }
                    catch (Exception e) {
                        RLog.e((String)TAG, (String)"getContentSummary", (Throwable)e);
                    }
                } else if (operation.equals("Kicked")) {
                    if (memberIdList != null) {
                        for (String userId : memberIdList) {
                            String removeMsg;
                            String kickedName;
                            if (currentUserId.equals(userId)) {
                                operator = operatorNickname;
                                spannableStringSummary = new SpannableString((CharSequence)context.getString(R.string.rc_item_you_remove_self, new Object[]{operator}));
                                continue;
                            }
                            if (!operatorUserId.equals(currentUserId)) {
                                operator = operatorNickname;
                                kickedName = memberName;
                                removeMsg = context.getString(R.string.rc_item_remove_group_member, new Object[]{operator, kickedName});
                            } else {
                                kickedName = memberName;
                                removeMsg = context.getString(R.string.rc_item_you_remove_group_member, new Object[]{kickedName});
                            }
                            spannableStringSummary = new SpannableString((CharSequence)removeMsg);
                        }
                    }
                } else if (operation.equals("Create")) {
                    String createMsg;
                    if (!operatorUserId.equals(currentUserId)) {
                        String name = operatorNickname;
                        createMsg = context.getString(R.string.rc_item_created_group, new Object[]{name});
                    } else {
                        createMsg = context.getString(R.string.rc_item_you_created_group);
                    }
                    spannableStringSummary = new SpannableString((CharSequence)createMsg);
                } else if (operation.equals("Dismiss")) {
                    spannableStringSummary = new SpannableString((CharSequence)(operatorNickname + context.getString(R.string.rc_item_dismiss_groups)));
                } else if (operation.equals("Quit")) {
                    spannableStringSummary = new SpannableString((CharSequence)(operatorNickname + context.getString(R.string.rc_item_quit_groups)));
                } else if (operation.equals("Rename")) {
                    String changeMsg;
                    String groupName;
                    if (!operatorUserId.equals(currentUserId)) {
                        operator = operatorNickname;
                        groupName = data.getTargetGroupName();
                        changeMsg = context.getString(R.string.rc_item_change_group_name, new Object[]{operator, groupName});
                    } else {
                        groupName = data.getTargetGroupName();
                        changeMsg = context.getString(R.string.rc_item_you_change_group_name, new Object[]{groupName});
                    }
                    spannableStringSummary = new SpannableString((CharSequence)changeMsg);
                }
            }
            return spannableStringSummary;
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"getContentSummary", (Throwable)e);
            return new SpannableString((CharSequence)context.getString(R.string.rc_item_group_notification_summary));
        }
    }

    @Override
    public void onItemClick(View view, int i, GroupNotificationMessage groupNotificationMessage, UIMessage uiMessage) {
    }

    @Override
    public void onItemLongClick(View view, int i, GroupNotificationMessage groupNotificationMessage, UIMessage uiMessage) {
    }

    @Override
    public View newView(Context context, ViewGroup viewGroup) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_group_information_notification_message, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.contentTextView = (TextView)view.findViewById(R.id.rc_msg);
        viewHolder.contentTextView.setMovementMethod(LinkMovementMethod.getInstance());
        view.setTag((Object)viewHolder);
        return view;
    }

    private GroupNotificationMessageData jsonToBean(String data) {
        GroupNotificationMessageData dataEntity = new GroupNotificationMessageData();
        try {
            int i;
            JSONArray jsonArray;
            JSONObject jsonObject = new JSONObject(data);
            if (jsonObject.has("operatorNickname")) {
                dataEntity.setOperatorNickname(jsonObject.getString("operatorNickname"));
            }
            if (jsonObject.has("targetGroupName")) {
                dataEntity.setTargetGroupName(jsonObject.getString("targetGroupName"));
            }
            if (jsonObject.has("timestamp")) {
                dataEntity.setTimestamp(jsonObject.getLong("timestamp"));
            }
            if (jsonObject.has("targetUserIds")) {
                jsonArray = jsonObject.getJSONArray("targetUserIds");
                for (i = 0; i < jsonArray.length(); ++i) {
                    dataEntity.getTargetUserIds().add(jsonArray.getString(i));
                }
            }
            if (jsonObject.has("targetUserDisplayNames")) {
                jsonArray = jsonObject.getJSONArray("targetUserDisplayNames");
                for (i = 0; i < jsonArray.length(); ++i) {
                    dataEntity.getTargetUserDisplayNames().add(jsonArray.getString(i));
                }
            }
            if (jsonObject.has("oldCreatorId")) {
                dataEntity.setOldCreatorId(jsonObject.getString("oldCreatorId"));
            }
            if (jsonObject.has("oldCreatorName")) {
                dataEntity.setOldCreatorName(jsonObject.getString("oldCreatorName"));
            }
            if (jsonObject.has("newCreatorId")) {
                dataEntity.setNewCreatorId(jsonObject.getString("newCreatorId"));
            }
            if (jsonObject.has("newCreatorName")) {
                dataEntity.setNewCreatorName(jsonObject.getString("newCreatorName"));
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"jsonToBean", (Throwable)e);
        }
        return dataEntity;
    }

    private static class ViewHolder {
        TextView contentTextView;

        private ViewHolder() {
        }
    }
}

