/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imkit.R;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import io.rong.message.utils.BitmapUtil;

@ProviderTag(messageContent=ImageMessage.class, showProgress=false, showReadState=true)
public class ImageMessageItemProvider
extends IContainerItemProvider.MessageProvider<ImageMessage> {
    private static final String TAG = "ImageMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_image_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (TextView)view.findViewById(R.id.rc_msg);
        holder.img = (AsyncImageView)view.findViewById(R.id.rc_img);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void onItemClick(View view, int position, ImageMessage content, UIMessage message) {
        if (content != null) {
            Intent intent = new Intent("io.rong.imkit.intent.action.picturepagerview");
            intent.setPackage(view.getContext().getPackageName());
            intent.putExtra("message", (Parcelable)message.getMessage());
            view.getContext().startActivity(intent);
        }
    }

    @Override
    public void bindView(View v, int position, ImageMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_no_right);
        } else {
            v.setBackgroundResource(R.drawable.rc_ic_bubble_no_left);
        }
        if (content.isDestruct()) {
            Bitmap bitmap = ImageLoader.getInstance().loadImageSync(content.getThumUri().toString());
            if (bitmap != null) {
                Bitmap blurryBitmap = BitmapUtil.getBlurryBitmap((Context)v.getContext(), (Bitmap)bitmap, (float)5.0f, (float)0.25f);
                holder.img.setBitmap(blurryBitmap);
            }
        } else {
            holder.img.setResource(content.getThumUri());
        }
        int progress = message.getProgress();
        Message.SentStatus status = message.getSentStatus();
        if (status.equals((Object)Message.SentStatus.SENDING) && progress < 100) {
            holder.message.setText((CharSequence)(progress + "%"));
            holder.message.setVisibility(0);
        } else {
            holder.message.setVisibility(8);
        }
    }

    @Override
    public Spannable getContentSummary(ImageMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, ImageMessage data) {
        return new SpannableString((CharSequence)context.getString(R.string.rc_message_content_image));
    }

    private static class ViewHolder {
        AsyncImageView img;
        TextView message;

        private ViewHolder() {
        }
    }
}

