/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.message.PublicServiceRichContentMessage;
import java.text.SimpleDateFormat;
import java.util.Date;

@ProviderTag(messageContent=PublicServiceRichContentMessage.class, showPortrait=false, centerInHorizontal=true, showSummaryWithName=false)
public class PublicServiceRichContentMessageProvider
extends IContainerItemProvider.MessageProvider<PublicServiceRichContentMessage> {
    private final String TAG = this.getClass().getSimpleName();

    @Override
    public View newView(Context context, ViewGroup group) {
        ViewHolder holder = new ViewHolder();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_public_service_rich_content_message, null);
        holder.title = (TextView)view.findViewById(R.id.rc_title);
        holder.time = (TextView)view.findViewById(R.id.rc_time);
        holder.description = (TextView)view.findViewById(R.id.rc_content);
        holder.imageView = (AsyncImageView)view.findViewById(R.id.rc_img);
        int w = RongUtils.getScreenWidth() - RongUtils.dip2px(32.0f);
        view.setLayoutParams(new ViewGroup.LayoutParams(w, -2));
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public void bindView(View v, int position, PublicServiceRichContentMessage content, UIMessage message) {
        ViewHolder holder = (ViewHolder)v.getTag();
        PublicServiceRichContentMessage msg = (PublicServiceRichContentMessage)message.getContent();
        if (msg.getMessage() != null) {
            holder.title.setText((CharSequence)msg.getMessage().getTitle());
            holder.description.setText((CharSequence)msg.getMessage().getDigest());
            holder.imageView.setResource(msg.getMessage().getImageUrl(), 0);
        }
        String time = this.formatDate(message.getReceivedTime(), "MM\u6708dd\u65e5 HH:mm");
        holder.time.setText((CharSequence)time);
    }

    private String formatDate(long timeMillis, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(timeMillis));
    }

    @Override
    public Spannable getContentSummary(PublicServiceRichContentMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, PublicServiceRichContentMessage data) {
        if (data != null && data.getMessage() != null) {
            return new SpannableString((CharSequence)data.getMessage().getTitle());
        }
        RLog.e((String)this.TAG, (String)"The content of the message is null! Check your message content!");
        return new SpannableString((CharSequence)"");
    }

    @Override
    public void onItemClick(View view, int position, PublicServiceRichContentMessage content, UIMessage message) {
        String url = content.getMessage().getUrl();
        String action = "io.rong.imkit.intent.action.webview";
        Intent intent = new Intent(action);
        intent.setPackage(view.getContext().getPackageName());
        intent.putExtra("url", url);
        view.getContext().startActivity(intent);
    }

    public static class ViewHolder {
        public TextView title;
        public AsyncImageView imageView;
        public TextView time;
        public TextView description;
    }
}

