/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.widget.AutoLinkTextView;
import io.rong.imkit.widget.ILinkClickListener;
import io.rong.imkit.widget.LinkTextViewMovementMethod;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Message;
import io.rong.message.TextMessage;

@ProviderTag(messageContent=TextMessage.class, showReadState=true)
public class TextMessageItemProvider
extends IContainerItemProvider.MessageProvider<TextMessage> {
    private static final String TAG = "TextMessageItemProvider";

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_text_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (AutoLinkTextView)view.findViewById(16908308);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public Spannable getContentSummary(TextMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, TextMessage data) {
        if (data == null) {
            return null;
        }
        String content = data.getContent();
        if (content != null) {
            if (content.length() > 100) {
                content = content.substring(0, 100);
            }
            return new SpannableString(AndroidEmoji.ensure(content));
        }
        return null;
    }

    @Override
    public void onItemClick(View view, int position, TextMessage content, UIMessage message) {
    }

    @Override
    public void bindView(final View v, int position, TextMessage content, final UIMessage data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (data.getMessageDirection() == Message.MessageDirection.SEND) {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_right);
        } else {
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_left);
        }
        final AutoLinkTextView textView = holder.message;
        if (data.getTextMessageContent() != null) {
            int len = data.getTextMessageContent().length();
            if (v.getHandler() != null && len > 500) {
                v.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        textView.setText((CharSequence)data.getTextMessageContent());
                    }
                }, 50L);
            } else {
                textView.setText((CharSequence)data.getTextMessageContent());
            }
        }
        holder.message.setMovementMethod((MovementMethod)new LinkTextViewMovementMethod(new ILinkClickListener(){

            @Override
            public boolean onLinkClick(String link) {
                String str;
                RongIM.ConversationBehaviorListener listener = RongContext.getInstance().getConversationBehaviorListener();
                RongIM.ConversationClickListener clickListener = RongContext.getInstance().getConversationClickListener();
                boolean result = false;
                if (listener != null) {
                    result = listener.onMessageLinkClick(v.getContext(), link);
                } else if (clickListener != null) {
                    result = clickListener.onMessageLinkClick(v.getContext(), link, data.getMessage());
                }
                if ((listener == null && clickListener == null || !result) && ((str = link.toLowerCase()).startsWith("http") || str.startsWith("https"))) {
                    Intent intent = new Intent("io.rong.imkit.intent.action.webview");
                    intent.setPackage(v.getContext().getPackageName());
                    intent.putExtra("url", link);
                    v.getContext().startActivity(intent);
                    result = true;
                }
                return result;
            }
        }));
        textView.stripUnderlines();
    }

    private static class ViewHolder {
        AutoLinkTextView message;
        boolean longClick;

        private ViewHolder() {
        }
    }
}

