/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.SystemClock;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.HeartbeatReceiver;

public class WakeLockUtils {
    private static final String TAG = WakeLockUtils.class.getSimpleName();
    private static final long DEF_HEARTBEAT_TIMER = 150000L;
    private static final int HEARTBEAT_TIMER_MIN = 10000;
    private static long interval;

    public static void startNextHeartbeat(Context context) {
        RLog.d(TAG, "startNextHeartbeat " + context.getPackageName());
        Intent heartbeatIntent = new Intent(context, HeartbeatReceiver.class);
        heartbeatIntent.setPackage(context.getPackageName());
        PendingIntent intent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)heartbeatIntent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        long time = SystemClock.elapsedRealtime();
        Resources resources = context.getResources();
        try {
            String sTimer = resources.getString(resources.getIdentifier("rc_heartbeat_timer", "string", context.getPackageName()));
            long lTimer = Long.parseLong(sTimer);
            time = lTimer >= 10000L ? (time += lTimer) : (time += 10000L);
        }
        catch (Resources.NotFoundException e) {
            RLog.d(TAG, "def config file not found");
            time += 150000L;
        }
        catch (NumberFormatException e) {
            RLog.d(TAG, "xml value cannot parse to long");
            time += 150000L;
        }
        alarmManager.cancel(intent);
        interval = time;
        FwLog.write(4, 4, "L-ping-S", "interval|enabled", interval, true);
        if (Build.VERSION.SDK_INT < 19) {
            alarmManager.set(2, time, intent);
        } else {
            alarmManager.setExact(2, time, intent);
        }
    }

    public static void cancelHeartbeat(Context context) {
        FwLog.write(4, 4, "L-ping-S", "interval|enabled", interval, false);
        RLog.d(TAG, "cancelHeartbeat " + context.getPackageName());
        Intent heartbeatIntent = new Intent(context, HeartbeatReceiver.class);
        heartbeatIntent.setPackage(context.getPackageName());
        PendingIntent intent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)heartbeatIntent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.cancel(intent);
    }
}

