/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.fwlog.FwLogImp;
import io.rong.common.fwlog.LogEntity;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public class FwLog {
    public static final int NONE = 0;
    public static final int F = 1;
    public static final int E = 2;
    public static final int W = 3;
    public static final int I = 4;
    public static final int D = 5;
    public static final int V = 6;
    public static final int APP = 1;
    public static final int PTC = 2;
    public static final int ENV = 4;
    public static final int DET = 8;
    public static final int CON = 16;
    public static final int RCO = 32;
    public static final int CRM = 64;
    public static final int MSG = 128;
    public static final int MED = 256;
    public static final int LOG = 512;
    public static final int DEB = 1024;
    public static final int CRS = 2048;
    public static final int RTC = 4096;
    public static final int EXCEPTION_THROWN = -1000;
    public static final int CONNECT_TOKEN_INCORRECT = -1001;
    public static final int CONNECT_SERVICE_DISCONNECT = -1002;
    public static final int CONNECT_IS_CONNECTING = -1002;
    static final String TAG = "FwLog";
    private static ILogEventCallback logEventCallback;
    private static FwLogImp instance;
    private static ILogListener logListener;

    protected FwLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, String appKey, String sdkVer) {
        instance = new FwLogImp(context, appKey, sdkVer);
        Class<FwLog> clazz = FwLog.class;
        synchronized (FwLog.class) {
            LogEntity.getInstance().setLogListener(logListener);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void setCallbackInSubProcess(Context context, ILogEventCallback callback) {
        logEventCallback = callback;
    }

    public static void setLogMonitor(int value) {
        if (instance != null) {
            Log.d((String)TAG, (String)("setLogMonitor = " + value));
            if (value == 1) {
                value = 0x5FFFFBFF;
            } else if (value == 2) {
                value = 0x6FFFFFFF;
            }
            LogEntity.getInstance().setMonitorLevel(value >> 28);
            LogEntity.getInstance().setMonitorType(value & 0xFFFFFFF);
        } else if (logEventCallback != null) {
            logEventCallback.onSetLogMonitorEventFromSubProcess(value);
        }
    }

    public static void setToken(String token) {
        if (token == null) {
            return;
        }
        if (instance != null) {
            LogEntity.getInstance().setToken(token);
        } else if (logEventCallback != null) {
            logEventCallback.onSetTokenEventFromSubProcess(token);
        }
    }

    public static void setUserId(String userId) {
        if (userId == null) {
            return;
        }
        if (instance != null) {
            LogEntity.getInstance().setUserId(userId);
        } else if (logEventCallback != null) {
            logEventCallback.onSetUserIdEventFromSubProcess(userId);
        }
    }

    public static void setConsoleLogLevel(int level) {
        if (instance == null) {
            throw new RuntimeException("Cannot be set in sub process.");
        }
        LogEntity.getInstance().setConsoleLogLevel(level);
    }

    public static synchronized void setLogListener(ILogListener listener) {
        if (instance != null) {
            LogEntity.getInstance().setLogListener(listener);
        } else {
            logListener = listener;
        }
    }

    public static void onProtocolLog(String log, boolean isHighLevel) {
        String[] values = log.split(";;;");
        if (values.length > 0) {
            String tag = values[0];
            if (tag.equals("P-code-C") && values.length == 3) {
                FwLog.write(isHighLevel ? 4 : 5, 2, tag, "action|code", values[1], values[2]);
            } else if (tag.equals("P-reason-C") && values.length == 3) {
                FwLog.write(isHighLevel ? 4 : 5, 2, tag, "action|reason", values[1], values[2]);
            } else if (tag.equals("P-more-C") && values.length == 4) {
                FwLog.write(isHighLevel ? 4 : 5, 2, tag, "action|code|reason", values[1], values[2], values[3]);
            } else {
                FwLog.write(1, 2, "P-parse_error-S", "content", log);
            }
        } else {
            FwLog.write(1, 2, "P-parse_error-S", "content", log);
        }
    }

    public static int getProtocolLogStatus() {
        int logStatus = 0;
        if (instance != null) {
            if (LogEntity.getInstance().getLogMode() != 0 || LogEntity.getInstance().getMonitorLevel() == 6) {
                logStatus = 2;
            } else if (LogEntity.getInstance().getMonitorLevel() >= 1 && LogEntity.getInstance().getMonitorLevel() <= 5) {
                logStatus = 1;
            }
        } else if (logEventCallback != null) {
            logStatus = logEventCallback.onGetProtocolLogStatus();
        }
        return logStatus;
    }

    public static void write(int level, int type, String tag, String keys, Object ... values) {
        String metaJson = FwLog.formatMetaJson(false, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), keys, values);
        FwLog.write(System.currentTimeMillis(), level, type, tag, metaJson);
    }

    public static void write(long timestamp, int level, int type, String tag, String metaJson) {
        if (instance != null) {
            instance.writeLog(timestamp, level, type, tag, metaJson);
        } else if (logEventCallback != null) {
            logEventCallback.onLogEventFromSubProcess(timestamp, level, type, tag, metaJson);
        }
    }

    public static String stackToString(Throwable error) {
        return Log.getStackTraceString((Throwable)error).replaceAll("\n", "\\\\n");
    }

    protected static String formatMetaJson(boolean isRtLog, int pid, long tid, long mainTid, String keys, Object ... values) {
        String[] keyArray = keys != null ? keys.split("\\|") : new String[]{};
        String jsonStr = "";
        if (keyArray.length != values.length) {
            StringBuilder valueStr = new StringBuilder();
            for (Object obj : values) {
                valueStr.append(obj != null ? obj.toString() : "null");
                valueStr.append("|");
            }
            if (values.length > 0) {
                valueStr.deleteCharAt(valueStr.length() - 1);
                jsonStr = "{\"ptid\":\"" + pid + "-" + tid + (tid == mainTid ? "*" : "") + "\",\"" + keys + "\":\"" + valueStr + "\"}";
            }
        } else {
            try {
                JSONObject json = new JSONObject();
                for (int i = 0; i < keyArray.length; ++i) {
                    json.put(keyArray[i], values[i] != null ? values[i] : "null");
                }
                String metaStr = json.toString().replace("\\/", "/");
                jsonStr = isRtLog ? "{" + metaStr.substring(1, metaStr.length()) : "{\"ptid\":\"" + pid + "-" + tid + (tid == mainTid ? "*" : "") + "\"" + (keyArray.length > 0 ? "," : "") + metaStr.substring(1, metaStr.length());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonStr;
    }

    public static void setLogServer(String onlineLogServer, String offlineLogServer) {
        if (instance != null) {
            if (offlineLogServer != null) {
                LogEntity.getInstance().setOfflineLogServer(offlineLogServer);
            }
            if (onlineLogServer != null) {
                LogEntity.getInstance().setOnlineLogServer(onlineLogServer);
            }
        } else if (logEventCallback != null) {
            logEventCallback.onSetLogServer(onlineLogServer, offlineLogServer);
        }
    }

    public static void rtWrite(int level, int type, String tag, String keys, Object ... values) {
        String metaJson = FwLog.formatMetaJson(true, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), keys, values);
        FwLog.rtWrite(System.currentTimeMillis(), level, type, tag, metaJson);
    }

    public static void rtWrite(long timestamp, int level, int type, String tag, String metaJson) {
        if (instance != null) {
            if (TextUtils.isEmpty((CharSequence)LogEntity.getInstance().getOnlineLogServer())) {
                return;
            }
            instance.writeRtLog(timestamp, level, type, tag, metaJson);
        } else if (logEventCallback != null) {
            logEventCallback.onRtLogEventFromSubProcess(timestamp, level, type, tag, metaJson);
        }
    }

    public static interface ILogListener {
        public void onLogEvent(String var1);
    }

    public static interface ILogEventCallback {
        public void onLogEventFromSubProcess(long var1, int var3, int var4, String var5, String var6);

        public void onRtLogEventFromSubProcess(long var1, int var3, int var4, String var5, String var6);

        public void onSetLogMonitorEventFromSubProcess(int var1);

        public void onSetTokenEventFromSubProcess(String var1);

        public void onSetUserIdEventFromSubProcess(String var1);

        public void onSetLogServer(String var1, String var2);

        public int onGetProtocolLogStatus();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Level {
    }
}

