/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.util.SparseArray;
import io.rong.common.fwlog.CrashLogWriter;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.LogEntity;
import io.rong.common.fwlog.LogReporter;
import io.rong.common.fwlog.LogThreadPool;
import io.rong.common.fwlog.LogThresholdCallback;
import io.rong.common.fwlog.LogWriter;
import io.rong.common.fwlog.RealTimeLogWriter;
import io.rong.common.fwlog.SimpleLogWriter;
import io.rong.imlib.statistics.CrashDetails;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

class FwLogImp
extends FwLog {
    private static ArrayList<String> levelArray = new ArrayList();
    private static SparseArray<String> typeArray = new SparseArray();
    private LogThreadPool threadPool = new LogThreadPool(3);
    private LogWriter fileLogWriter;
    private LogWriter crashLogWriter;
    private LogWriter realTimeLogWriter;
    private LogReporter logReporter;
    private Context context;

    public FwLogImp(final Context context, String appKey, String sdkVer) {
        this.context = context;
        LogEntity.init(context);
        this.fileLogWriter = new SimpleLogWriter(LogEntity.getInstance().getLogDir() + File.separator + "rong_sdk.log", new LogThresholdCallback(){

            @Override
            public void onSize(long size) {
                if (size > LogEntity.getInstance().getFileMaxSize()) {
                    FwLogImp.this.fileLogWriter.flush();
                }
            }
        });
        this.crashLogWriter = new CrashLogWriter(LogEntity.getInstance().getLogDir());
        this.realTimeLogWriter = new RealTimeLogWriter(this.threadPool.getExecutorService(), new LogThresholdCallback(){

            @Override
            void onTimeout(Vector<String> lruLog, String startTime, String endTime) {
                FwLogImp.this.logReporter.reportLruLog(lruLog, startTime, endTime);
            }
        });
        this.logReporter = new LogReporter(this.threadPool);
        Timer timer = new Timer();
        if (LogEntity.getInstance().getLogMode() != 1) {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    FwLogImp.this.fileLogWriter.flushAndReport(FwLogImp.this.logReporter);
                }
            }, LogEntity.getInstance().getUploadTimeInterval(), LogEntity.getInstance().getUploadTimeInterval());
        }
        Log.i((String)"FwLog", (String)("init FwLog: LogMode = " + LogEntity.getInstance().getLogMode() + ", monitorLevel = " + LogEntity.getInstance().getMonitorLevel() + ", monitorType = " + LogEntity.getInstance().getMonitorType()));
        if (LogEntity.getInstance().getLogMode() != 1 && LogEntity.getInstance().getMonitorLevel() > 0 && LogEntity.getInstance().getMonitorType() > 0) {
            Log.d((String)"FwLog", (String)"upload the last log");
            this.fileLogWriter.flushAndReport(this.logReporter);
        }
        this.writeLogHeader();
        LogEntity.getInstance().setAppKey(appKey);
        LogEntity.getInstance().setSdkVer(sdkVer);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                final Thread.UncaughtExceptionHandler defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        String reason = e.toString();
                        reason = reason.substring(0, reason.indexOf(":"));
                        FwLog.write(1, 2048, "L-crash_main_trb-F", "stack|reason|env", FwLog.stackToString(e), reason, CrashDetails.getIMCrashData(context, e.toString()));
                        if (defaultExceptionHandler != null) {
                            defaultExceptionHandler.uncaughtException(t, e);
                        }
                    }
                });
            }
        }, 2000L);
    }

    private void writeLogHeader() {
        String metaJson = FwLog.formatMetaJson(false, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), null, new Object[0]);
        this.writeLog(System.currentTimeMillis(), 4, 512, "Log-Opened", metaJson);
    }

    public String formatLog(long timestamp, int level, int type, String tag, String metaJson) {
        if (LogEntity.getInstance().getLogMode() != 0 || level <= LogEntity.getInstance().getConsoleLogLevel()) {
            FwLogImp.showConsoleLog(level, tag, metaJson);
            if (LogEntity.getInstance().getLogListener() != null) {
                LogEntity.getInstance().getLogListener().onLogEvent("[RC:" + tag + "]" + metaJson);
            }
        }
        if (LogEntity.getInstance().getLogMode() != 0 || level <= LogEntity.getInstance().getMonitorLevel() && (type & LogEntity.getInstance().getMonitorType()) != 0) {
            String jsonStr;
            if (LogEntity.getInstance().getLogMode() == 1) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss.SSS", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("gmt"));
                String gmtTime = sdf.format(new Date(timestamp));
                jsonStr = "{\"time\":\"" + gmtTime + "\",\"level\":\"" + levelArray.get(level) + "\",\"type\":\"" + (String)typeArray.get(type) + "\",\"tag\":\"" + tag + "\",\"meta\":" + metaJson + "}";
            } else {
                jsonStr = "{\"time\":" + timestamp + ",\"level\":\"" + levelArray.get(level) + "\",\"type\":\"" + (String)typeArray.get(type) + "\",\"tag\":\"" + tag + "\",\"meta\":" + metaJson + "}";
            }
            return jsonStr;
        }
        return null;
    }

    public void writeLog(long timestamp, int level, int type, String tag, String metaJson) {
        String jsonStr = this.formatLog(timestamp, level, type, tag, metaJson);
        if (jsonStr != null) {
            if (type == 2048) {
                this.crashLogWriter.write(jsonStr);
            } else {
                this.fileLogWriter.write(jsonStr);
            }
        }
    }

    private static void showConsoleLog(int level, String tag, String log) {
        tag = "[RC:" + tag + "]";
        switch (level) {
            case 6: {
                Log.v((String)tag, (String)log);
                break;
            }
            case 5: {
                Log.d((String)tag, (String)log);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)log);
                break;
            }
            case 3: {
                Log.w((String)tag, (String)log);
                break;
            }
            case 2: {
                Log.e((String)tag, (String)log);
                break;
            }
            case 1: {
                Log.wtf((String)tag, (String)log);
                break;
            }
        }
    }

    public void writeRtLog(long timestamp, int level, int type, String tag, String metaJson) {
        if (LogEntity.getInstance().getLogMode() != 0) {
            return;
        }
        if (!this.isNetworkOnline()) {
            return;
        }
        String jsonStr = this.formatRtLog(timestamp, level, type, tag, metaJson);
        if (jsonStr != null) {
            this.realTimeLogWriter.write(jsonStr);
        }
    }

    private boolean isNetworkOnline() {
        if (this.context == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        return networkInfo != null ? networkInfo.isConnected() : false;
    }

    public String formatRtLog(long timestamp, int level, int type, String tag, String metaJson) {
        String jsonStr = "{\"time\":" + timestamp + ",\"level\":\"" + levelArray.get(level) + "\",\"type\":\"" + (String)typeArray.get(type) + "\",\"tag\":\"" + tag + "\",\"meta\":" + metaJson + "}";
        return jsonStr;
    }

    static {
        levelArray.add("N");
        levelArray.add("F");
        levelArray.add("E");
        levelArray.add("W");
        levelArray.add("I");
        levelArray.add("D");
        levelArray.add("V");
        typeArray.put(1, (Object)"APP");
        typeArray.put(2, (Object)"PTC");
        typeArray.put(4, (Object)"ENV");
        typeArray.put(8, (Object)"DET");
        typeArray.put(16, (Object)"CON");
        typeArray.put(32, (Object)"RCO");
        typeArray.put(64, (Object)"CRM");
        typeArray.put(128, (Object)"MSG");
        typeArray.put(256, (Object)"MED");
        typeArray.put(512, (Object)"LOG");
        typeArray.put(1024, (Object)"DEB");
        typeArray.put(2048, (Object)"CRS");
        typeArray.put(4096, (Object)"RTC");
    }
}

