/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import io.rong.common.fwlog.FwLog;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogEntity {
    public static final String LogFileName = "rong_sdk.log";
    public static final String CrashLogFileName = "rong_sdk_crash.log";
    public static final int MODE_RELEASE = 0;
    public static final int MODE_DEBUG = 1;
    public static final int MODE_TEST = 2;
    private static final String LOG_DIR = "rong_log";
    private static final String SP_NAME = "FwLog";
    private static final String SP_SDK_VER = "SDK_VER";
    private static final String SP_APP_KEY = "APP_KEY";
    private static final String SP_USER_ID = "USER_ID";
    private static final String SP_TOKEN = "TOKEN";
    private static final String SP_OFFLINE_LOG_SERVER = "OFFLINE_LOG_SERVER";
    private static final String SP_ONLINE_LOG_SERVER = "ONLINE_LOG_SERVER";
    private static final String SP_START_LOG_TIME = "START_LOG_TIME";
    private static final String SP_MONITOR_LEVEL = "MONITOR_LEVEL";
    private static final String SP_MONITOR_TYPE = "MONITOR_TYPE";
    private static final String SP_UPLOAD_CACHE_LIST = "UPLOAD_CACHE_LIST";
    private static final String Log_Default_Url = "https://feedback.cn.ronghub.com";
    private SharedPreferences sharedPreferences;
    private static LogEntity instance;
    private String logDir;
    private String sdkVer;
    private String appKey;
    private String userId;
    private String token;
    private String offlineLogServer = null;
    private String onlineLogServer = null;
    private long startLogTime;
    private int monitorLevel;
    private int monitorType;
    private int consoleLogLevel;
    private boolean isDebugMode;
    private FwLog.ILogListener logListener;

    static void init(Context context) {
        if (instance == null) {
            instance = new LogEntity(context);
        }
    }

    private LogEntity(Context context) {
        ApplicationInfo info = context.getApplicationInfo();
        this.isDebugMode = info != null && (info.flags & 2) != 0;
        this.sharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        File extLogDir = null;
        try {
            extLogDir = context.getExternalFilesDir(LOG_DIR);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        if (extLogDir != null) {
            this.logDir = extLogDir.getAbsolutePath();
        } else {
            try {
                String intLogDir;
                this.logDir = intLogDir = context.getFilesDir().getAbsoluteFile() + File.separator + LOG_DIR;
            }
            catch (Exception e) {
                FwLog.write(1, 512, "L-crash_main_ept-E", "stacks", FwLog.stackToString(e));
            }
        }
    }

    static LogEntity getInstance() {
        if (instance == null) {
            throw new RuntimeException("LogEntity.init() has not been called.");
        }
        return instance;
    }

    String getLogDir() {
        return this.logDir;
    }

    String getSdkVer() {
        if (this.sdkVer == null) {
            this.sdkVer = this.sharedPreferences.getString(SP_SDK_VER, null);
        }
        return this.sdkVer;
    }

    void setSdkVer(String sdkVer) {
        this.sharedPreferences.edit().putString(SP_SDK_VER, sdkVer).apply();
        this.sdkVer = sdkVer;
    }

    String getAppKey() {
        if (this.appKey == null) {
            this.appKey = this.sharedPreferences.getString(SP_APP_KEY, null);
        }
        return this.appKey;
    }

    void setAppKey(String appKey) {
        this.sharedPreferences.edit().putString(SP_APP_KEY, appKey).apply();
        this.appKey = appKey;
    }

    String getUserId() {
        if (this.userId == null) {
            this.userId = this.sharedPreferences.getString(SP_USER_ID, null);
        }
        return this.userId;
    }

    void setUserId(String userId) {
        this.sharedPreferences.edit().putString(SP_USER_ID, userId).apply();
        this.userId = userId;
    }

    String getToken() {
        if (this.token == null) {
            this.token = this.sharedPreferences.getString(SP_TOKEN, null);
        }
        return this.token;
    }

    void setToken(String token) {
        this.sharedPreferences.edit().putString(SP_TOKEN, token).apply();
        this.token = token;
    }

    void setOfflineLogServer(String offlineLogServer) {
        this.sharedPreferences.edit().putString(SP_OFFLINE_LOG_SERVER, offlineLogServer).apply();
        this.offlineLogServer = offlineLogServer;
    }

    String getOfflineLogServer() {
        if (this.offlineLogServer == null) {
            this.offlineLogServer = this.sharedPreferences.getString(SP_OFFLINE_LOG_SERVER, Log_Default_Url);
        }
        return this.offlineLogServer;
    }

    void setOnlineLogServer(String onlineLogServer) {
        this.sharedPreferences.edit().putString(SP_ONLINE_LOG_SERVER, onlineLogServer).apply();
        this.onlineLogServer = onlineLogServer;
    }

    String getOnlineLogServer() {
        if (this.onlineLogServer == null) {
            this.onlineLogServer = this.sharedPreferences.getString(SP_ONLINE_LOG_SERVER, "");
        }
        return this.onlineLogServer;
    }

    long getStartLogTime() {
        if (this.startLogTime == 0L) {
            this.startLogTime = this.sharedPreferences.getLong(SP_START_LOG_TIME, 0L);
        }
        return this.startLogTime;
    }

    void setStartLogTime(long startLogTime) {
        this.sharedPreferences.edit().putLong(SP_START_LOG_TIME, startLogTime).apply();
        this.startLogTime = startLogTime;
    }

    int getMonitorLevel() {
        if (this.monitorLevel == 0) {
            this.monitorLevel = this.sharedPreferences.getInt(SP_MONITOR_LEVEL, 0);
        }
        return this.monitorLevel;
    }

    void setMonitorLevel(int monitorLevel) {
        if (this.getLogMode() == 2) {
            monitorLevel = 6;
        }
        this.sharedPreferences.edit().putInt(SP_MONITOR_LEVEL, monitorLevel).apply();
        this.monitorLevel = monitorLevel;
    }

    int getMonitorType() {
        if (this.monitorType == 0) {
            this.monitorType = this.sharedPreferences.getInt(SP_MONITOR_TYPE, 0);
        }
        return this.monitorType;
    }

    void setMonitorType(int monitorType) {
        if (this.getLogMode() == 2) {
            monitorType = 0xFFFFFFF;
        }
        this.sharedPreferences.edit().putInt(SP_MONITOR_TYPE, monitorType).apply();
        this.monitorType = monitorType;
    }

    public JSONArray getUploadCacheList() {
        JSONArray jsonArray;
        String uploadCacheList = this.sharedPreferences.getString(SP_UPLOAD_CACHE_LIST, null);
        try {
            jsonArray = uploadCacheList == null ? new JSONArray() : new JSONArray(uploadCacheList);
        }
        catch (JSONException e) {
            FwLog.write(1, 512, "G-get_upload_cache-E", "cache", uploadCacheList);
            e.printStackTrace();
            jsonArray = new JSONArray();
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUploadCacheList(JSONArray jsonArray) {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        synchronized (sharedPreferences) {
            if (jsonArray != null) {
                this.sharedPreferences.edit().putString(SP_UPLOAD_CACHE_LIST, jsonArray.toString()).apply();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUploadCacheList(int item) {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        synchronized (sharedPreferences) {
            JSONArray jsonArray = this.getUploadCacheList();
            if (jsonArray != null) {
                if (Build.VERSION.SDK_INT >= 19) {
                    jsonArray.remove(item);
                }
                this.sharedPreferences.edit().putString(SP_UPLOAD_CACHE_LIST, jsonArray.toString()).apply();
            }
        }
    }

    void addLogStamp(String newLogFile) {
        JSONArray jsonArray = this.getUploadCacheList();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("filename", (Object)newLogFile);
            jsonObject.put("sdkVer", (Object)LogEntity.getInstance().getSdkVer());
            jsonObject.put("appKey", (Object)LogEntity.getInstance().getAppKey());
            jsonObject.put("userId", (Object)LogEntity.getInstance().getUserId());
            jsonObject.put("token", (Object)LogEntity.getInstance().getToken());
            jsonArray.put((Object)jsonObject);
        }
        catch (JSONException e) {
            FwLog.write(1, 512, "G-crash-E", "stacks", FwLog.stackToString(e));
            e.printStackTrace();
        }
        this.setUploadCacheList(jsonArray);
    }

    int getLogMode() {
        return this.isDebugMode ? 1 : 0;
    }

    void setConsoleLogLevel(int level) {
        this.consoleLogLevel = level;
    }

    int getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    void setLogListener(FwLog.ILogListener listener) {
        this.logListener = listener;
    }

    FwLog.ILogListener getLogListener() {
        return this.logListener;
    }

    String getUploadUrl() {
        return this.getOfflineLogServer();
    }

    long getUploadTimeInterval() {
        return this.getLogMode() == 2 ? 120000L : 0x6DDD00L;
    }

    long getOutDateTime() {
        return this.getLogMode() == 2 ? 300000L : 259200000L;
    }

    long getFileMaxSize() {
        return this.getLogMode() == 2 ? 51200L : 0x100000L;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

