/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.util.Log;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.LogEntity;
import io.rong.common.fwlog.LogThreadPool;
import io.rong.common.fwlog.LogZipper;
import io.rong.imlib.common.NetUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReporter {
    private static final String BOUNDARY = "03297e90-eed0-4cec-b18b-92d2574b9331";
    LogThreadPool logThreadPool;

    public LogReporter(LogThreadPool threadPool) {
        this.logThreadPool = threadPool;
        this.checkAndReportCrashLog();
        this.clearExpiredLogFile();
    }

    public void reportFileLog() {
        try {
            JSONArray jsonArray = LogEntity.getInstance().getUploadCacheList();
            int i = 0;
            while (i < jsonArray.length()) {
                JSONObject record = jsonArray.getJSONObject(i);
                final String filename = record.getString("filename");
                final String sdkVer = record.getString("sdkVer");
                final String appKey = record.getString("appKey");
                final String userId = record.getString("userId");
                final String token = record.getString("token");
                final int finalI = i++;
                this.logThreadPool.getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        File file = new File(LogEntity.getInstance().getLogDir(), filename);
                        if (file.exists()) {
                            String startTimeStr = filename.substring(0, filename.indexOf("_"));
                            String endTimeStr = filename.substring(filename.indexOf("_") + 1, filename.indexOf("."));
                            long endTime = Long.parseLong(endTimeStr);
                            if (System.currentTimeMillis() - endTime <= LogEntity.getInstance().getOutDateTime()) {
                                boolean result = LogReporter.this.uploadFile(file.getAbsolutePath(), startTimeStr, endTimeStr, sdkVer, appKey, userId, token, false);
                                if (result) {
                                    LogEntity.getInstance().deleteUploadCacheList(finalI);
                                }
                            } else {
                                FwLog.write(2, 512, "G-drop_log-E", "start|end|size", startTimeStr, endTimeStr, file.length());
                                file.delete();
                            }
                        }
                    }
                });
            }
        }
        catch (JSONException ignored) {
            Log.e((String)"FwLog", (String)("ignored = " + (Object)((Object)ignored)));
        }
    }

    private void checkAndReportCrashLog() {
        if (LogEntity.getInstance().getLogMode() == 1) {
            return;
        }
        this.logThreadPool.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                File[] zipFiles;
                File logDir = new File(LogEntity.getInstance().getLogDir());
                if (logDir.exists() && logDir.length() == 0L) {
                    return;
                }
                for (File file : zipFiles = logDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return name.endsWith("rong_sdk_crash.log");
                    }
                })) {
                    long startTime = file.lastModified();
                    long endTime = System.currentTimeMillis();
                    String zipFilename = startTime + "_" + endTime + ".gz";
                    String zipFilePath = LogEntity.getInstance().getLogDir() + File.separator + zipFilename;
                    if (!LogZipper.gzipFile(file.getAbsolutePath(), zipFilePath)) continue;
                    boolean result = LogReporter.this.uploadFile(file.getAbsolutePath(), startTime + "", endTime + "", LogEntity.getInstance().getSdkVer(), LogEntity.getInstance().getAppKey(), LogEntity.getInstance().getUserId(), LogEntity.getInstance().getToken(), true);
                    if (result) {
                        LogReporter.this.clearInfoForFile(LogEntity.getInstance().getLogDir() + File.separator + "rong_sdk_crash.log");
                        continue;
                    }
                    File zipFile = new File(LogEntity.getInstance().getLogDir(), zipFilename);
                    if (!zipFile.exists()) continue;
                    zipFile.delete();
                }
            }
        });
    }

    private void clearInfoForFile(String fileName) {
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reportLruLog(Vector<String> lruLog, final String startTime, final String endTime) {
        final Vector<String> tmpLog = new Vector<String>(lruLog);
        this.logThreadPool.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                JSONArray jsonArray = new JSONArray();
                int count = tmpLog.size();
                for (int i = 0; i < count; ++i) {
                    try {
                        JSONObject jsonObject = new JSONObject((String)tmpLog.get(i));
                        jsonArray.put((Object)jsonObject);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (count > 0) {
                    LogReporter.this.uploadString(jsonArray.toString(), startTime, endTime, LogEntity.getInstance().getSdkVer(), LogEntity.getInstance().getAppKey(), LogEntity.getInstance().getUserId(), LogEntity.getInstance().getToken());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(String filePath, String startTime, String endTime, String sdkVer, String appKey, String userId, String token, boolean crashLog) {
        Log.i((String)"FwLog", (String)"uploadFile begin.");
        HttpURLConnection conn = null;
        File file = new File(filePath);
        DataOutputStream outStream = null;
        InputStream inStream = null;
        boolean result = false;
        try {
            String line;
            int len;
            conn = NetUtils.createURLConnection(LogEntity.getInstance().getUploadUrl());
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(5000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            if (crashLog) {
                conn.setRequestProperty("RC-Crash", "RC-Crash");
            }
            conn.setRequestProperty("RC-App-Key", appKey);
            conn.setRequestProperty("RC-User-ID", userId);
            conn.setRequestProperty("RC-SDK-Version", sdkVer);
            conn.setRequestProperty("RC-Platform", "Android");
            conn.setRequestProperty("RC-Start-Time", startTime);
            conn.setRequestProperty("RC-End-Time", endTime);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=03297e90-eed0-4cec-b18b-92d2574b9331");
            outStream = new DataOutputStream(conn.getOutputStream());
            outStream.writeBytes("--03297e90-eed0-4cec-b18b-92d2574b9331\r\n");
            outStream.writeBytes("Content-Disposition: form-data; name=\"fileLog\"; filename=\"fileLog.gz\"\r\n");
            outStream.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.writeBytes("\r\n--03297e90-eed0-4cec-b18b-92d2574b9331--\r\n");
            outStream.flush();
            outStream.close();
            is.close();
            inStream = conn.getInputStream();
            BufferedReader buff = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder responseSb = new StringBuilder();
            while ((line = buff.readLine()) != null) {
                responseSb.append(line);
            }
            String responseBody = responseSb.toString();
            if (responseBody.contains("\"code\":0")) {
                Log.d((String)"FwLog", (String)("response = " + responseBody));
                result = true;
                FwLog.write(4, 512, "G-upload_log-S", "start|end|size", startTime, endTime, file.length());
            } else {
                int responseCode = conn.getResponseCode();
                result = false;
                FwLog.write(2, 512, "G-upload_log-E", "code|body|start|end|size", responseCode, responseBody, startTime, endTime, file.length());
            }
        }
        catch (Exception e) {
            result = false;
            FwLog.write(1, 512, "G-upload_log-F", "start|end|size|stacks", startTime, endTime, file.length(), FwLog.stackToString(e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
            if (result) {
                file.delete();
            }
        }
        Log.i((String)"FwLog", (String)"uploadFile end.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadString(String content, String startTime, String endTime, String sdkVer, String appKey, String userId, String token) {
        HttpURLConnection conn = null;
        try {
            conn = NetUtils.createURLConnection(LogEntity.getInstance().getOnlineLogServer());
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("RC-App-Key", appKey);
            conn.setRequestProperty("RC-User-ID", userId);
            conn.setRequestProperty("RC-SDK-Version", sdkVer);
            conn.setRequestProperty("RC-Platform", "Android");
            conn.setRequestProperty("RC-Start-Time", String.valueOf(startTime));
            conn.setRequestProperty("RC-End-Time", String.valueOf(endTime));
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json");
            DataOutputStream os = new DataOutputStream(conn.getOutputStream());
            os.writeBytes(content);
            int code = conn.getResponseCode();
            os.flush();
            os.close();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    private void clearExpiredLogFile() {
        try {
            File[] zipFiles;
            File logDir = new File(LogEntity.getInstance().getLogDir());
            for (File file : zipFiles = logDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.endsWith(".gz");
                }
            })) {
                String filename = file.getName();
                String startTimeStr = filename.substring(0, filename.indexOf("_"));
                String endTimeStr = filename.substring(filename.indexOf("_") + 1, filename.indexOf("."));
                long endTime = Long.parseLong(endTimeStr);
                if (System.currentTimeMillis() - endTime <= LogEntity.getInstance().getOutDateTime()) continue;
                file.delete();
                FwLog.write(2, 512, "G-drop_log-E", "start|end|size", startTimeStr, endTimeStr, file.length());
            }
        }
        catch (Exception e) {
            FwLog.write(1, 512, "G-crash-E", "stacks", FwLog.stackToString(e));
            e.printStackTrace();
        }
    }
}

