/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IRTCConfigCallback;
import io.rong.imlib.IRTCJoinRoomCallback;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.IRtcIODataListener;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.RTCDataListener;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.ipc.IpcCallbackProxy;
import io.rong.imlib.model.RTCUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IMLibRTCClient {
    private static final String TAG = "IMLibRTCClient";
    private Handler mWorkHandler;
    private IHandler mLibHandler;
    private static Handler mHandler;
    private static RTCRoomActionListener rtcRoomActionListener;
    private Map<String, RTCRoomCacheRunnable> mRetryRTCCache = new HashMap<String, RTCRoomCacheRunnable>();
    private Map<String, RTCRoomCacheRunnable> mRTCRoomCache = new HashMap<String, RTCRoomCacheRunnable>();

    private IMLibRTCClient() {
        mHandler = new Handler(Looper.getMainLooper());
    }

    public static IMLibRTCClient getInstance() {
        return SingletonHolder.sInstance;
    }

    public void init(Handler mWorkHandler) {
        this.mWorkHandler = mWorkHandler;
    }

    public void OnServiceConnected(IHandler mLibHandler) {
        this.mLibHandler = mLibHandler;
    }

    public void OnServiceDisconnected() {
        this.mLibHandler = null;
    }

    public static void setRtcRoomActionListener(RTCRoomActionListener roomActionListener) {
        rtcRoomActionListener = roomActionListener;
    }

    public String getVoIPInfo() {
        try {
            if (this.mLibHandler == null) {
                RLog.e(TAG, "IPC disconnected.");
            }
            return this.mLibHandler == null ? "" : this.mLibHandler.getVoIPCallInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reJoinRTCRoomWithCache() {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                int size = IMLibRTCClient.this.mRetryRTCCache.size();
                if (size > 0) {
                    RLog.d(IMLibRTCClient.TAG, "clear retry rtc-room cache after connectivity available, cached size = " + size);
                    for (RTCRoomCacheRunnable runnable : IMLibRTCClient.this.mRetryRTCCache.values()) {
                        IMLibRTCClient.this.mWorkHandler.removeCallbacks((Runnable)runnable);
                    }
                    IMLibRTCClient.this.mRetryRTCCache.clear();
                }
                if ((size = IMLibRTCClient.this.mRTCRoomCache.size()) > 0) {
                    RLog.d(IMLibRTCClient.TAG, "rejoin rtc-room after connectivity available, cached size = " + size);
                    for (RTCRoomCacheRunnable runnable : IMLibRTCClient.this.mRTCRoomCache.values()) {
                        IMLibRTCClient.this.mWorkHandler.post((Runnable)runnable);
                    }
                }
            }
        });
    }

    public void exitRTCRoom(final String roomId, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.exitRTCRoom(roomId, new RTCOperationCallback(ipcCallbackProxy));
                    IMLibRTCClient.this.mRTCRoomCache.remove(roomId);
                    Runnable runnable = (Runnable)IMLibRTCClient.this.mRetryRTCCache.remove(roomId);
                    if (runnable != null) {
                        IMLibRTCClient.this.mWorkHandler.removeCallbacks(runnable);
                    }
                    if (rtcRoomActionListener != null) {
                        rtcRoomActionListener.onExited(roomId);
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void getRTCUsers(final String roomId, final int order, IRongCallback.IRTCDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCDataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCDataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.getRTCUsers(roomId, order, new RTCDataListener.Stub(){

                            @Override
                            public void OnSuccess(final List data) {
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void OnError(final int status) {
                                RLog.d(IMLibRTCClient.TAG, "getRTCUsers errorCode =  " + status);
                                FwLog.write(2, 512, "A-rtc_getRTCUsers-R", "code", status);
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void getRTCUserData(final String roomId, final int order, IRongCallback.IRTCDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCDataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCDataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.getRTCUserData(roomId, order, new RTCDataListener.Stub(){

                            @Override
                            public void OnSuccess(final List data) {
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void OnError(final int status) {
                                RLog.d(IMLibRTCClient.TAG, "getRTCUserData errorCode =  " + status);
                                FwLog.write(2, 512, "A-rtc_getRtcUserData-R", "code", status);
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void sendRTCPing(final String roomId, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.sendRTCPing(roomId, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setUseRTCOnly(final RongIMClient.ResultCallback<Boolean> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onCallback(false);
                    }
                    return;
                }
                try {
                    boolean isUseRTCOnly = IMLibRTCClient.this.mLibHandler.useRTCOnly();
                    if (callback != null) {
                        callback.onCallback(isUseRTCOnly);
                    }
                }
                catch (RemoteException e) {
                    if (callback != null) {
                        callback.onCallback(false);
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcPutInnerDatum(final String roomId, final int type, final String key, final String value, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcPutInnerDatum(roomId, type, key, value, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcPutOuterDatum(final String roomId, final int type, final String key, final String value, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcPutOuterDatum(roomId, type, key, value, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcDeleteInnerData(final String roomId, final int type, final String[] keys, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcDeleteInnerData(roomId, type, keys, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcDeleteOuterData(final String roomId, final int type, final String[] keys, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcDeleteOuterData(roomId, type, keys, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcGetInnerData(final String roomId, final int type, final String[] keys, IRongCallback.IRtcIODataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRtcIODataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRtcIODataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcGetInnerData(roomId, type, keys, new IRtcIODataListener.Stub(){

                        @Override
                        public void OnSuccess(final Map data) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void OnError(final int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "rtcGetInnerData errorCode =  " + status);
                            FwLog.write(2, 512, "A-rtc_getInner-R", "code", status);
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcGetOuterData(final String roomId, final int type, final String[] keys, IRongCallback.IRtcIODataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRtcIODataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRtcIODataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcGetOuterData(roomId, type, keys, new IRtcIODataListener.Stub(){

                        @Override
                        public void OnSuccess(final Map data) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void OnError(final int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "rtcGetOuterData errorCode =  " + status);
                            FwLog.write(2, 512, "A-rtc_getOuter-R", "code", status);
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void joinRTCRoomAndGetData(String roomId, IRongCallback.IRTCJoinRoomCallback callback) {
        this.joinRTCRoomAndGetData(roomId, 0, callback);
    }

    public void joinRTCRoomAndGetData(final String roomId, final int roomType, IRongCallback.IRTCJoinRoomCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCJoinRoomCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.joinRTCRoomAndGetData(roomId, roomType, new JoinRTCRoomCallback(ipcCallbackProxy, roomId, roomType));
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCJoinRoomCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void getRTCConfig(final String model, final String osVersion, final long timestamp, final IRongCallback.IRTCConfigCallback callback) {
        if (TextUtils.isEmpty((CharSequence)model) || TextUtils.isEmpty((CharSequence)osVersion)) {
            RLog.e(TAG, "getRTCConfig parameter error, roomid=|model=" + model + "|osVersion=" + osVersion);
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCConfigCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCConfigCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((IRongCallback.IRTCConfigCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.getRTCConfig(model, osVersion, timestamp, new IRTCConfigCallback.Stub(){

                        @Override
                        public void onSuccess(String config, long version) throws RemoteException {
                            callback.onSuccess(config, version);
                        }

                        @Override
                        public void onError(int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "getRTCConfig errorCode =  " + status);
                            FwLog.write(2, 512, "A-rtc_getRTCConfig-R", "code", status);
                            callback.onError(RongIMClient.ErrorCode.valueOf(status));
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void clearRTCCache() {
        this.mRTCRoomCache.clear();
        for (RTCRoomCacheRunnable runnable : this.mRetryRTCCache.values()) {
            this.mWorkHandler.removeCallbacks((Runnable)runnable);
        }
        this.mRetryRTCCache.clear();
    }

    private void runOnUiThread(Runnable runnable) {
        mHandler.post(runnable);
    }

    public void getRTCToken(final String roomId, RongIMClient.ResultCallback<String> resultCallback) {
        final IpcCallbackProxy<RongIMClient.ResultCallback<String>> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.ResultCallback<String>>(resultCallback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.PARAMETER_ERROR);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.getRTCToken(roomId, new IStringCallback.Stub(){

                        @Override
                        public void onComplete(String string) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onCallback(string);
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    RLog.e(IMLibRTCClient.TAG, "getRTCToken", e);
                }
            }
        });
    }

    private class DefaultOperationCallback
    extends IOperationCallback.Stub {
        private IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy;

        public DefaultOperationCallback(IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy) {
            this.ipcCallbackProxy = ipcCallbackProxy;
        }

        @Override
        public void onComplete() {
            if (this.ipcCallbackProxy.callback != null) {
                ((RongIMClient.OperationCallback)this.ipcCallbackProxy.callback).onCallback();
                this.ipcCallbackProxy.callback = null;
            }
        }

        @Override
        public void onFailure(int errorCode) {
            if (this.ipcCallbackProxy.callback != null) {
                ((RongIMClient.OperationCallback)this.ipcCallbackProxy.callback).onFail(errorCode);
                this.ipcCallbackProxy.callback = null;
            }
        }
    }

    private class RTCOperationCallback
    extends DefaultOperationCallback {
        public RTCOperationCallback(IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy) {
            super(ipcCallbackProxy);
        }

        @Override
        public void onFailure(int errorCode) {
            RLog.d(IMLibRTCClient.TAG, "RTCOperationCallback errorCode =  " + errorCode);
            FwLog.write(2, 512, "A-rtc_callback-R", "code", errorCode);
            super.onFailure(errorCode);
        }
    }

    private class JoinRTCRoomCallback
    extends IRTCJoinRoomCallback.Stub {
        private IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallback> ipcCallbackProxy;
        private String rtcRoomId;
        private int roomType;

        public JoinRTCRoomCallback(IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallback> ipcCallbackProxy, String rtcRoomId, int roomType) {
            this.rtcRoomId = rtcRoomId;
            this.roomType = roomType;
            this.ipcCallbackProxy = ipcCallbackProxy;
            IMLibRTCClient.this.mRTCRoomCache.put(rtcRoomId, new RTCRoomCacheRunnable(rtcRoomId, roomType));
            RLog.d(IMLibRTCClient.TAG, this + "");
        }

        public String toString() {
            return "JoinRTCRoomCallback{rtcRoomId='" + this.rtcRoomId + '\'' + '}';
        }

        @Override
        public void OnSuccess(final List data, final String token) throws RemoteException {
            if (this.ipcCallbackProxy.callback != null) {
                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((IRongCallback.IRTCJoinRoomCallback)((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback).onSuccess(data, token);
                        ((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback = null;
                    }
                });
            }
            if (rtcRoomActionListener != null) {
                rtcRoomActionListener.onJoined(this.rtcRoomId, data);
            }
        }

        @Override
        public void OnError(final int errorCode) throws RemoteException {
            RLog.e(IMLibRTCClient.TAG, "join rtcRroom " + this.rtcRoomId + ", error: " + errorCode + "re-join after 2s");
            FwLog.write(2, 512, "A-join_rtcRoom-R", "code", errorCode);
            if (this.ipcCallbackProxy.callback != null) {
                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((IRongCallback.IRTCJoinRoomCallback)((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(errorCode));
                        ((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback = null;
                    }
                });
            }
            RTCRoomCacheRunnable runnable = new RTCRoomCacheRunnable(this.rtcRoomId, this.roomType);
            IMLibRTCClient.this.mRetryRTCCache.put(this.rtcRoomId, runnable);
            long interval = 2000L;
            IMLibRTCClient.this.mWorkHandler.postDelayed((Runnable)runnable, interval);
            if (rtcRoomActionListener != null) {
                rtcRoomActionListener.onError(this.rtcRoomId, RongIMClient.ErrorCode.valueOf(errorCode));
            }
        }
    }

    private class RTCRoomCacheRunnable
    implements Runnable {
        String rtcRoomID;
        int roomType;

        public RTCRoomCacheRunnable(String rtcRoomID, int roomType) {
            this.rtcRoomID = rtcRoomID;
            this.roomType = roomType;
        }

        @Override
        public void run() {
            RongIMClient.ConnectionStatusListener.ConnectionStatus mConnectionStatus = RongIMClient.getInstance().getCurrentConnectionStatus();
            RLog.d(IMLibRTCClient.TAG, "rejoin rtc_room " + this);
            IMLibRTCClient.this.mRetryRTCCache.remove(this.rtcRoomID);
            if (IMLibRTCClient.this.mLibHandler != null && RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED.equals((Object)mConnectionStatus)) {
                IpcCallbackProxy<Object> ipcCallbackProxy = new IpcCallbackProxy<Object>(null);
                if (rtcRoomActionListener != null) {
                    rtcRoomActionListener.onJoining(this.rtcRoomID);
                }
                try {
                    IMLibRTCClient.this.mLibHandler.joinRTCRoomAndGetData(this.rtcRoomID, this.roomType, new JoinRTCRoomCallback(ipcCallbackProxy, this.rtcRoomID, this.roomType));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    RLog.e(IMLibRTCClient.TAG, "rejoin rtc-room exception.");
                }
            } else {
                RLog.e(IMLibRTCClient.TAG, "rejoin rtc-room error : " + (Object)((Object)mConnectionStatus));
            }
        }

        public String toString() {
            return "RTCRoomCacheRunnable{rtcRoomID='" + this.rtcRoomID + '\'' + "roomType= " + '}';
        }
    }

    public static interface RTCRoomActionListener {
        public void onJoining(String var1);

        public void onJoined(String var1, List<RTCUser> var2);

        public void onExited(String var1);

        public void onError(String var1, RongIMClient.ErrorCode var2);
    }

    private static class SingletonHolder {
        static IMLibRTCClient sInstance = new IMLibRTCClient();

        private SingletonHolder() {
        }
    }
}

