/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.net.Uri;
import io.rong.common.RLog;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.UserOnlineStatusInfo;
import io.rong.message.MediaMessageContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface IRongCallback {

    public static interface IRTCConfigCallback {
        public void onSuccess(String var1, long var2);

        public void onError(RongIMClient.ErrorCode var1);
    }

    public static interface IRtcIODataCallback {
        public void onSuccess(Map<String, String> var1);

        public void onError(RongIMClient.ErrorCode var1);
    }

    public static interface IRTCJoinRoomCallback {
        public void onSuccess(List<RTCUser> var1, String var2);

        public void onError(RongIMClient.ErrorCode var1);
    }

    public static interface IRTCDataCallback {
        public void onSuccess(List<RTCUser> var1);

        public void onError(RongIMClient.ErrorCode var1);
    }

    public static interface ISetSubscribeStatusCallback {
        public void onStatusReceived(String var1, ArrayList<UserOnlineStatusInfo> var2);
    }

    public static interface ISetUserOnlineStatusCallback {
        public void onSuccess();

        public void onError(int var1);
    }

    public static interface IGetUserOnlineStatusCallback {
        public void onSuccess(ArrayList<UserOnlineStatusInfo> var1);

        public void onError(int var1);
    }

    public static interface IChatRoomHistoryMessageCallback {
        public void onSuccess(List<Message> var1, long var2);

        public void onError(RongIMClient.ErrorCode var1);
    }

    public static interface IDownloadMediaFileCallback {
        public void onFileNameChanged(String var1);

        public void onSuccess();

        public void onProgress(int var1);

        public void onError(RongIMClient.ErrorCode var1);

        public void onCanceled();
    }

    public static interface IDownloadMediaMessageCallback {
        public void onSuccess(Message var1);

        public void onProgress(Message var1, int var2);

        public void onError(Message var1, RongIMClient.ErrorCode var2);

        public void onCanceled(Message var1);
    }

    public static class MediaMessageUploader {
        private ISendMediaMessageCallbackWithUploader callbackWithUploader;
        private Message message;
        private String pushContent;
        private String pushData;

        public MediaMessageUploader(Message message, String pushContent, String pushData, ISendMediaMessageCallbackWithUploader callbackWithUploader) {
            this.callbackWithUploader = callbackWithUploader;
            this.message = message;
            this.pushContent = pushContent;
            this.pushData = pushData;
        }

        public void update(int progress) {
            if (this.callbackWithUploader != null) {
                this.callbackWithUploader.onProgress(this.message, progress);
            }
        }

        public void error() {
            this.message.setSentStatus(Message.SentStatus.FAILED);
            RongIMClient.getInstance().setMessageSentStatus(this.message.getMessageId(), Message.SentStatus.FAILED, null);
            if (this.callbackWithUploader != null) {
                this.callbackWithUploader.onError(this.message, RongIMClient.ErrorCode.RC_MSG_SEND_FAIL);
            }
        }

        public void cancel() {
            if (this.callbackWithUploader != null) {
                this.callbackWithUploader.onCanceled(this.message);
            }
        }

        public void success(Uri uploadedUri) {
            if (uploadedUri == null) {
                RLog.e("MediaMessageUploader", "uploadedUri is null.");
                if (this.callbackWithUploader != null) {
                    this.callbackWithUploader.onError(this.message, RongIMClient.ErrorCode.RC_MSG_SEND_FAIL);
                }
                return;
            }
            MediaMessageContent content = (MediaMessageContent)this.message.getContent();
            content.setMediaUrl(uploadedUri);
            RongIMClient.getInstance().sendMediaMessage(this.message, this.pushContent, this.pushData, new ISendMediaMessageCallback(){

                @Override
                public void onProgress(Message message, int progress) {
                }

                @Override
                public void onAttached(Message message) {
                }

                @Override
                public void onSuccess(Message message) {
                    if (MediaMessageUploader.this.callbackWithUploader != null) {
                        MediaMessageUploader.this.callbackWithUploader.onSuccess(message);
                    }
                }

                @Override
                public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                    if (MediaMessageUploader.this.callbackWithUploader != null) {
                        MediaMessageUploader.this.callbackWithUploader.onError(message, errorCode);
                    }
                }

                @Override
                public void onCanceled(Message message) {
                }
            });
        }
    }

    public static interface ISendMediaMessageCallbackWithUploader {
        public void onAttached(Message var1, MediaMessageUploader var2);

        public void onProgress(Message var1, int var2);

        public void onSuccess(Message var1);

        public void onError(Message var1, RongIMClient.ErrorCode var2);

        public void onCanceled(Message var1);
    }

    public static interface ISendMediaMessageCallback
    extends ISendMessageCallback {
        public void onProgress(Message var1, int var2);

        public void onCanceled(Message var1);
    }

    public static interface ISendMessageCallback {
        public void onAttached(Message var1);

        public void onSuccess(Message var1);

        public void onError(Message var1, RongIMClient.ErrorCode var2);
    }
}

