/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.os.RemoteException;
import io.rong.common.RLog;
import io.rong.common.WakeLockUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IConnectionStatusListener;
import io.rong.imlib.IDownloadMediaCallback;
import io.rong.imlib.IDownloadMediaFileCallback;
import io.rong.imlib.IDownloadMediaMessageCallback;
import io.rong.imlib.IFwLogCallback;
import io.rong.imlib.IGetNotificationQuietHoursCallback;
import io.rong.imlib.IGetUserStatusCallback;
import io.rong.imlib.IHandler;
import io.rong.imlib.IIntegerCallback;
import io.rong.imlib.ILongCallback;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IRTCConfigCallback;
import io.rong.imlib.IRTCJoinRoomCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRtcIODataListener;
import io.rong.imlib.ISendMediaMessageCallback;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.ISetPushSettingCallback;
import io.rong.imlib.ISetUserStatusCallback;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.ISubscribeUserStatusCallback;
import io.rong.imlib.IUploadCallback;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.OnGetHistoryMessagesCallback;
import io.rong.imlib.OnReceiveMessageListener;
import io.rong.imlib.PushNotificationListener;
import io.rong.imlib.RTCDataListener;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.filetransfer.CancelCallback;
import io.rong.imlib.filetransfer.FileTransferClient;
import io.rong.imlib.filetransfer.PauseCallback;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.model.RongListWrap;
import io.rong.imlib.model.SearchConversationResult;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.model.UserData;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.statistics.CrashDetails;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class LibHandlerStub
extends IHandler.Stub {
    private static final String TAG = "LibHandlerStub";
    private Context mContext;
    private String mCurrentUserId;
    private NativeClient mClient;

    public LibHandlerStub(Context context, String appKey, String deviceId) {
        this.mContext = context;
        this.mClient = NativeClient.getInstance();
        this.mClient.init(this.mContext, appKey, deviceId);
    }

    @Override
    public String getCurrentUserId() {
        try {
            return this.mClient.getCurrentUserId();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void replenishPing(boolean inForeground) {
        try {
            if (inForeground) {
                this.mClient.startReplenishHeartbeat();
            } else {
                this.mClient.stopReplenishHeartbeat();
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendPing() {
        try {
            this.mClient.ping(this.mContext);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setUserPolicy(boolean enable) {
        try {
            NavigationCacheHelper.setUserPolicy(enable);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void connect(String token, boolean isReconnect, boolean inForeground, final IStringCallback callback) {
        try {
            this.mClient.connect(token, isReconnect, inForeground, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String userId) {
                    if (callback != null) {
                        LibHandlerStub.this.mCurrentUserId = userId;
                        WakeLockUtils.startNextHeartbeat(LibHandlerStub.this.mContext);
                        try {
                            callback.onComplete(userId);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    WakeLockUtils.cancelHeartbeat(LibHandlerStub.this.mContext);
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            try {
                callback.onFailure(-1);
            }
            catch (RemoteException ex) {
                this.handleRemoteException(ex);
            }
        }
    }

    @Override
    public void disconnect(boolean isReceivePush) {
        try {
            WakeLockUtils.cancelHeartbeat(this.mContext);
            this.mClient.disconnect(isReceivePush);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void registerMessageType(String className) {
        try {
            Class<?> loader = Class.forName(className);
            this.mClient.registerMessageType(loader);
        }
        catch (Exception e) {
            FwLog.write(2, 128, "L-register_type-S", "class_name", className);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            RLog.e(TAG, "registerMessageType Exception :\n" + stringWriter.toString());
        }
    }

    @Override
    public void setConnectionStatusListener(final IConnectionStatusListener callback) {
        try {
            this.mClient.setConnectionStatusListener(new NativeClient.ICodeListener(){

                @Override
                public void onChanged(int status) {
                    RLog.d(LibHandlerStub.TAG, "[connect] onChanged status:" + status);
                    if (status != 33005 && status != 0) {
                        WakeLockUtils.cancelHeartbeat(LibHandlerStub.this.mContext);
                        LibHandlerStub.this.mClient.stopReplenishHeartbeat();
                    }
                    if (callback != null) {
                        try {
                            callback.onChanged(status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public int getTotalUnreadCount() {
        try {
            return this.mClient.getTotalUnreadCount();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCount(int[] types) {
        try {
            if (types == null || types.length == 0) {
                return 0;
            }
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.getUnreadCount(conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountWithDND(int[] types, boolean withDND) {
        try {
            if (types == null || types.length == 0) {
                return 0;
            }
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.getUnreadCount(withDND, conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountById(int type, String id) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(type);
            if (conversationType == null || id == null) {
                return 0;
            }
            return this.mClient.getUnreadCount(conversationType, id);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountByConversation(Conversation[] conversations) {
        try {
            return this.mClient.getTotalUnreadCount(conversations);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public void setOnReceiveMessageListener(final OnReceiveMessageListener listener) {
        try {
            if (listener != null) {
                NativeClient.OnReceiveMessageListener receiveMessageListener = new NativeClient.OnReceiveMessageListener(){

                    @Override
                    public void onReceived(Message message, int left, boolean offline, boolean hasMsg, int cmdLeft) {
                        try {
                            listener.onReceived(message, left, offline, hasMsg, cmdLeft);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.mClient.setOnReceiveMessageListener(receiveMessageListener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public Message insertMessage(Message message) {
        try {
            return this.mClient.insertMessage(message.getConversationType(), message.getTargetId(), message.getSenderUserId(), message.getContent(), message.getSentTime());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message insertSettingMessage(Message message) {
        try {
            return this.mClient.insertSettingMessage(message);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message getMessage(int messageId) {
        try {
            return this.mClient.getMessage(messageId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message getMessageByUid(String uid) {
        try {
            return this.mClient.getMessageByUid(uid);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void sendMessage(Message message, String pushContent, String pushData, final ISendMessageCallback callback) {
        try {
            this.mClient.sendMessage(message, pushContent, pushData, null, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendMessageOption(Message message, String pushContent, String pushData, SendMessageOption option, final ISendMessageCallback callback) throws RemoteException {
        try {
            this.mClient.sendMessageOption(message, pushContent, pushData, option, null, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendDirectionalMessage(Message message, String pushContent, String pushData, String[] userIds, final ISendMessageCallback callback) {
        try {
            this.mClient.sendMessage(message, pushContent, pushData, userIds, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendLocationMessage(Message message, String pushContent, String pushData, final ISendMessageCallback callback) {
        try {
            this.mClient.sendLocationMessage(message, pushContent, pushData, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> getNewestMessages(Conversation conversation, int count) {
        try {
            return this.mClient.getLatestMessages(conversation.getConversationType(), conversation.getTargetId(), count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> getOlderMessages(Conversation conversation, long flagId, int count) {
        try {
            return this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), (int)flagId, count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void getOlderMessagesOneWay(Conversation conversation, long flagId, int count, OnGetHistoryMessagesCallback callback) {
        try {
            List<Message> messages = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), (int)flagId, count);
            try {
                callback.onComplete(new RemoteModelWrap(RongListWrap.obtain(messages, Message.class)));
            }
            catch (RemoteException e) {
                RLog.e(TAG, "getOlderMessages", e);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getChatroomHistoryMessages(String targetId, long recordTime, int count, int order, final IChatRoomHistoryMessageCallback callback) {
        try {
            this.mClient.getChatroomHistoryMessages(targetId, recordTime, count, order, new NativeClient.IResultCallbackEx<List<Message>, Long>(){

                @Override
                public void onSuccess(List<Message> messages, Long aLong) {
                    if (callback != null) {
                        try {
                            if (messages == null || messages.size() == 0) {
                                callback.onComplete(null, aLong);
                            } else {
                                callback.onComplete(new RemoteModelWrap(RongListWrap.obtain(messages, Message.class)), aLong);
                            }
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getUserStatus(String userId, final IGetUserStatusCallback callback) {
        try {
            this.mClient.getUserStatus(userId, new NativeClient.IResultCallbackEx<String, Integer>(){

                @Override
                public void onSuccess(String platformInfo, Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(platformInfo, status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void subscribeStatus(List<String> users, final IIntegerCallback callback) {
        try {
            this.mClient.subscribeStatus(users, new NativeClient.IResultCallbackEx<Integer, Integer>(){

                @Override
                public void onSuccess(Integer opStatus, Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setSubscribeStatusListener(final ISubscribeUserStatusCallback callback) {
        try {
            this.mClient.setSubscribeStatusListener(new NativeClient.IResultCallbackEx<String, String>(){

                @Override
                public void onSuccess(String objName, String content) {
                    if (callback != null) {
                        try {
                            callback.onStatusReceived(objName, content);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setPushSetting(int key, String value, final ISetPushSettingCallback callback) {
        try {
            this.mClient.setPushSetting(key, value, new NativeClient.IResultCallback<Long>(){

                @Override
                public void onSuccess(Long aLong) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.onFailure(code);
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getPushSetting(int key) {
        try {
            return this.mClient.getPushSetting(key);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setUserStatus(int status, final ISetUserStatusCallback callback) {
        try {
            this.mClient.setUserStatus(status, new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer code) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getRemoteHistoryMessages(Conversation conversation, long dataTime, int count, final IResultCallback callback) {
        try {
            this.mClient.getRemoteHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), dataTime, count, new NativeClient.IResultCallback<List<Message>>(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(List<Message> messages) {
                    if (callback != null) {
                        RemoteModelWrap result = null;
                        try {
                            if (messages == null || messages.size() == 0) {
                                callback.onComplete(result);
                            } else {
                                result = new RemoteModelWrap(RongListWrap.obtain(messages, Message.class));
                                callback.onComplete(result);
                            }
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> getOlderMessagesByObjectName(Conversation conversation, String objectName, long flagId, int count, boolean flag) {
        List<Message> list = null;
        try {
            list = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), objectName, (int)flagId, count, flag);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public List<Message> getOlderMessagesByObjectNames(Conversation conversation, List<String> objectNames, long flagId, int count, boolean flag) {
        List<Message> list = null;
        try {
            list = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), objectNames, flagId, count, flag);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public boolean deleteMessage(int[] ids) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        try {
            return this.mClient.deleteMessages(ids);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void deleteMessages(int conversationType, String targetId, Message[] messages, IOperationCallback callback) {
        try {
            Conversation.ConversationType type = Conversation.ConversationType.setValue(conversationType);
            if (type.equals((Object)Conversation.ConversationType.CHATROOM)) {
                RLog.e(TAG, "this conversationType isn't supported!");
                return;
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
            }
            this.mClient.deleteMessages(type, targetId, messages, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean deleteConversationMessage(int conversationType, String targetId) {
        try {
            return this.mClient.deleteMessage(Conversation.ConversationType.setValue(conversationType), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearMessages(Conversation conversation) {
        try {
            return this.mClient.clearMessages(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void cleanRemoteHistoryMessages(Conversation conversation, long recordTime, IOperationCallback callback) {
        try {
            this.mClient.cleanRemoteHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), recordTime, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cleanHistoryMessages(Conversation conversation, long recordTime, IOperationCallback callback) {
        try {
            this.mClient.cleanHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), recordTime, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean clearMessagesUnreadStatus(Conversation conversation) {
        try {
            return this.mClient.clearMessagesUnreadStatus(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageExtra(int messageId, String values) {
        try {
            return this.mClient.setMessageExtra(messageId, values);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageReceivedStatus(int messageId, int status) {
        try {
            return this.mClient.setMessageReceivedStatus(messageId, new Message.ReceivedStatus(status));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageSentStatus(int messageId, int status) {
        try {
            return this.mClient.setMessageSentStatus(messageId, Message.SentStatus.setValue(status));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Conversation> getConversationList() {
        List<Conversation> list = null;
        try {
            list = this.mClient.getConversationList();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public boolean updateConversationInfo(int type, String targetId, String title, String portrait) {
        try {
            return this.mClient.updateConversationInfo(Conversation.ConversationType.setValue(type), targetId, title, portrait);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Conversation> getConversationListByType(int[] types) {
        List<Conversation> list = null;
        try {
            list = this.mClient.getConversationList(types);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public List<Conversation> getConversationListByPage(int[] types, long timeStamp, int count) {
        try {
            return this.mClient.getConversationListByPage(types, timeStamp, count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Conversation> getBlockedConversationList(int[] types) {
        try {
            return this.mClient.getBlockedConversationList(types);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Conversation getConversation(int type, String targetId) {
        try {
            return this.mClient.getConversation(Conversation.ConversationType.setValue(type), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean removeConversation(int typeValue, String targetId) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(typeValue);
            if (conversationType == null) {
                RLog.i(TAG, "removeConversation the conversation type is null");
                return false;
            }
            return this.mClient.removeConversation(conversationType, targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearConversations(int[] types) {
        if (types == null || types.length == 0) {
            return false;
        }
        try {
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.clearConversations(conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean saveConversationDraft(Conversation conversation, String content) {
        try {
            RLog.i(TAG, "saveConversationDraft " + content);
            return this.mClient.saveTextMessageDraft(conversation.getConversationType(), conversation.getTargetId(), content);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public String getConversationDraft(Conversation conversation) {
        try {
            return this.mClient.getTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean cleanConversationDraft(Conversation conversation) {
        try {
            return this.mClient.clearTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void getConversationNotificationStatus(int type, String targetId, final ILongCallback callback) {
        try {
            this.mClient.getConversationNotificationStatus(Conversation.ConversationType.setValue(type), targetId, new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status.intValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setConversationNotificationStatus(int type, String targetId, int status, final ILongCallback callback) {
        try {
            this.mClient.setConversationNotificationStatus(Conversation.ConversationType.setValue(type), targetId, Conversation.ConversationNotificationStatus.setValue(status), new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status.intValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean syncConversationNotificationStatus(int type, String targetId, int status) {
        try {
            return this.mClient.syncConversationNotificationStatus(Conversation.ConversationType.setValue(type), targetId, Conversation.ConversationNotificationStatus.setValue(status));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setConversationTopStatus(int typeValue, String targetId, boolean isTop, boolean needCreate) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(typeValue);
            if (conversationType == null) {
                RLog.e(TAG, "setConversationTopStatus ConversationType is null");
                return false;
            }
            return this.mClient.setConversationToTop(conversationType, targetId, isTop, needCreate);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public int getConversationUnreadCount(Conversation conversation) {
        try {
            return this.mClient.getUnreadCount(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public void getDiscussion(String id, final IResultCallback callback) {
        try {
            this.mClient.getDiscussion(id, new NativeClient.IResultCallback<Discussion>(){

                @Override
                public void onSuccess(Discussion discussion) {
                    if (callback != null) {
                        RemoteModelWrap result = new RemoteModelWrap(discussion);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setDiscussionName(String id, String name, IOperationCallback callback) {
        try {
            this.mClient.setDiscussionName(id, name, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void createDiscussion(final String name, final List<String> userIds, final IResultCallback callback) {
        try {
            this.mClient.createDiscussion(name, userIds, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String discussionId) {
                    if (callback != null) {
                        Discussion model = new Discussion(discussionId, name, LibHandlerStub.this.mCurrentUserId, true, userIds);
                        RemoteModelWrap result = new RemoteModelWrap(model);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void searchPublicService(String keyWords, int businessType, int searchType, final IResultCallback callback) {
        try {
            this.mClient.searchPublicService(keyWords, businessType, searchType, new NativeClient.IResultCallback<PublicServiceProfileList>(){

                @Override
                public void onSuccess(PublicServiceProfileList publicServiceInfoList) {
                    if (callback != null) {
                        RemoteModelWrap result = new RemoteModelWrap(publicServiceInfoList);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void subscribePublicService(String targetId, int categoryId, boolean subscribe, final IOperationCallback callback) {
        try {
            this.mClient.subscribePublicService(targetId, categoryId, subscribe, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getPublicServiceProfile(String targetId, int conversationType, final IResultCallback callback) {
        try {
            this.mClient.getPublicServiceProfile(targetId, conversationType, new NativeClient.IResultCallback<PublicServiceProfile>(){

                @Override
                public void onSuccess(PublicServiceProfile info) {
                    if (callback != null) {
                        RemoteModelWrap mModelWrap = null;
                        if (info != null) {
                            mModelWrap = new RemoteModelWrap(info);
                        }
                        try {
                            callback.onComplete(mModelWrap);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getPublicServiceList(final IResultCallback callback) {
        try {
            this.mClient.getPublicServiceList(new NativeClient.IResultCallback<PublicServiceProfileList>(){

                @Override
                public void onSuccess(PublicServiceProfileList list) {
                    if (callback != null) {
                        RemoteModelWrap mModelWrap = new RemoteModelWrap(list);
                        try {
                            callback.onComplete(mModelWrap);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void addMemberToDiscussion(String id, List<String> userIds, IOperationCallback callback) {
        try {
            this.mClient.addMemberToDiscussion(id, userIds, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeDiscussionMember(String id, String userId, IOperationCallback callback) {
        try {
            this.mClient.removeMemberFromDiscussion(id, userId, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitDiscussion(String id, IOperationCallback callback) {
        try {
            this.mClient.quitDiscussion(id, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void syncGroup(List<Group> groups, IOperationCallback callback) {
        try {
            this.mClient.syncGroup(groups, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinGroup(String id, String name, IOperationCallback callback) {
        try {
            this.mClient.joinGroup(id, name, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitGroup(String id, IOperationCallback callback) {
        try {
            this.mClient.quitGroup(id, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getChatRoomInfo(String id, int count, int order, final IResultCallback callback) {
        try {
            this.mClient.queryChatRoomInfo(id, count, order, new NativeClient.IResultCallback<ChatRoomInfo>(){

                @Override
                public void onSuccess(ChatRoomInfo chatRoomInfo) {
                    if (callback != null) {
                        try {
                            RemoteModelWrap result = new RemoteModelWrap(chatRoomInfo);
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinChatRoom(final String id, int defMessageCount, final IOperationCallback callback) {
        try {
            FwLog.write(4, 64, "L-join_chatroom-T", "room_id|existed", id, false);
            this.mClient.joinChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(4, 64, "L-join_chatroom-R", "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(2, 64, "L-join_chatroom-R", "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void reJoinChatRoom(final String id, int defMessageCount, final IOperationCallback callback) {
        FwLog.write(4, 64, "L-rejoin_chatroom-T", "room_id", id);
        try {
            this.mClient.reJoinChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(4, 64, "L-rejoin_chatroom-R", "code|room_id", 0, id);
                    RLog.d(LibHandlerStub.TAG, "reJoinChatRoom " + id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(2, 64, "L-rejoin_chatroom-R", "code|room_id", errorCode, id);
                    RLog.e(LibHandlerStub.TAG, "reJoinChatRoom " + errorCode);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinExistChatRoom(final String id, int defMessageCount, final IOperationCallback callback, boolean keepMsg) {
        FwLog.write(4, 64, "L-join_chatroom-T", "room_id|existed", id, true);
        try {
            this.mClient.joinExistChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(4, 64, "L-join_chatroom-R", "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(2, 64, "L-join_chatroom-R", "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            }, keepMsg);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitChatRoom(final String id, final IOperationCallback callback) {
        FwLog.write(4, 64, "L-quit_chatroom-T", "room_id", id);
        try {
            this.mClient.quitChatRoom(id, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(4, 64, "L-quit_chatroom-R", "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(2, 64, "L-quit_chatroom-R", "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setNotificationQuietHours(String startTime, int spanMinutes, final IOperationCallback callback) {
        try {
            this.mClient.setNotificationQuietHours(startTime, spanMinutes, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeNotificationQuietHours(final IOperationCallback callback) {
        try {
            this.mClient.removeNotificationQuietHours(new NativeClient.OperationCallback(){

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getNotificationQuietHours(final IGetNotificationQuietHoursCallback callback) {
        try {
            this.mClient.getNotificationQuietHours(new NativeClient.GetNotificationQuietHoursCallback(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onError(code);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccess(String start, int min) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(start, min);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void uploadMedia(Message message, final IUploadCallback callback) {
        try {
            this.mClient.uploadMedia(message, new NativeClient.IResultProgressCallback<String>(){

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(String uri) {
                    if (callback != null) {
                        try {
                            callback.onComplete(uri);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(int messageId) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMedia(Conversation conversation, int type, String imageUrl, final IDownloadMediaCallback callback) {
        try {
            this.mClient.downloadMedia(conversation.getConversationType(), conversation.getTargetId(), type, imageUrl, new NativeClient.IResultProgressCallback<String>(){

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(String localMediaPath) {
                    if (callback != null) {
                        try {
                            callback.onComplete(localMediaPath);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(int messageId) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMediaMessage(Message message, final IDownloadMediaMessageCallback callback) {
        try {
            this.mClient.downloadMediaMessage(message, new NativeClient.IDownloadMediaMessageCallback<Message>(){

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onComplete(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled() {
                    if (callback != null) {
                        try {
                            callback.onCanceled();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMediaFile(String uid, String fileUrl, String fileName, String path, final IDownloadMediaFileCallback callback) {
        try {
            this.mClient.downloadMediaFile(uid, fileUrl, fileName, path, new NativeClient.IDownloadMediaFileCallback<Boolean>(){

                @Override
                public void onFileNameChanged(String newFileName) {
                    if (callback == null) {
                        return;
                    }
                    try {
                        callback.onFileNameChanged(newFileName);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onSuccess(Boolean result) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled() {
                    if (callback != null) {
                        try {
                            callback.onCanceled();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cancelTransferMediaMessage(Message message, final IOperationCallback callback) {
        try {
            FileTransferClient.getInstance().cancel(message.getMessageId(), new CancelCallback(){

                @Override
                public void onCanceled(Object tag) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cancelAllTransferMediaMessage(IOperationCallback callback) {
        block5: {
            try {
                FileTransferClient.getInstance().cancelAll();
                if (callback != null) {
                    callback.onComplete();
                }
            }
            catch (Exception e) {
                RLog.e(TAG, "cancelAllTransferMediaMessage", e);
                if (callback == null) break block5;
                try {
                    callback.onFailure(-1);
                }
                catch (RemoteException remoteException) {
                    this.handleRemoteException(remoteException);
                }
            }
        }
    }

    @Override
    public void pauseTransferMediaMessage(Message message, final IOperationCallback callback) throws RemoteException {
        FileTransferClient.getInstance().pause(message.getMessageId(), new PauseCallback(){

            @Override
            public void onPaused(Object tag) {
                try {
                    callback.onComplete();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int code) {
                try {
                    callback.onFailure(code);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void pauseTransferMediaFile(String tag, final IOperationCallback callback) throws RemoteException {
        FileTransferClient.getInstance().pause(tag, new PauseCallback(){

            @Override
            public void onPaused(Object tag) {
                try {
                    callback.onComplete();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int code) {
                try {
                    callback.onFailure(code);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean getFileDownloadingStatus(String uid) {
        return FileTransferClient.getInstance().getDownloadingFromMap(this.mContext, uid);
    }

    @Override
    public boolean supportResumeBrokenTransfer(String url) {
        return FileTransferClient.checkSupportResumeTransfer(url);
    }

    @Override
    public long getDeltaTime() {
        try {
            return this.mClient.getDeltaTime();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public void setDiscussionInviteStatus(String targetId, int status, final IOperationCallback callback) {
        try {
            this.mClient.setDiscussionInviteStatus(targetId, status, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void recallMessage(String objectName, byte[] content, String pushContent, int messageId, String targetId, int conversationType, final IOperationCallback callback) {
        try {
            this.mClient.recallMessage(objectName, content, pushContent, messageId, targetId, conversationType, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void addToBlacklist(String userId, final IOperationCallback callback) {
        try {
            this.mClient.addToBlacklist(userId, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeFromBlacklist(String userId, final IOperationCallback callback) {
        try {
            this.mClient.removeFromBlacklist(userId, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getBlacklistStatus(String userId, final IIntegerCallback callback) {
        try {
            this.mClient.getBlacklistStatus(userId, new NativeClient.IResultCallback<NativeClient.BlacklistStatus>(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(NativeClient.BlacklistStatus blacklistStatus) {
                    if (callback != null) {
                        try {
                            callback.onComplete(blacklistStatus.getValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getBlacklist(final IStringCallback callback) {
        try {
            this.mClient.getBlacklist(new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String userIds) {
                    if (callback != null) {
                        try {
                            callback.onComplete(userIds);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getTextMessageDraft(Conversation conversation) {
        try {
            return this.mClient.getTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean saveTextMessageDraft(Conversation conversation, String content) {
        try {
            return this.mClient.saveTextMessageDraft(conversation.getConversationType(), conversation.getTargetId(), content);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearTextMessageDraft(Conversation conversation) {
        try {
            return this.mClient.clearTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void setUserData(UserData userData, final IOperationCallback callback) {
        try {
            this.mClient.setUserData(userData, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean updateMessageReceiptStatus(String targetId, int categoryId, long timestamp) {
        try {
            return this.mClient.updateMessageReceiptStatus(targetId, categoryId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearUnreadByReceipt(int conversationType, String targetId, long timestamp) {
        try {
            return this.mClient.clearUnreadByReceipt(conversationType, targetId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public long getSendTimeByMessageId(int messageId) {
        try {
            return this.mClient.getSendTimeByMessageId(messageId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public void getVoIPKey(int engineType, String channelName, String extra, final IStringCallback callback) {
        try {
            this.mClient.getVoIPKey(engineType, channelName, extra, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getVoIPCallInfo() {
        try {
            return this.mClient.getVoIPCallInfo();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setServerInfo(String naviServer, String fileServer) {
        try {
            this.mClient.setServerInfo(naviServer, fileServer);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public long getNaviCachedTime() {
        try {
            return NavigationCacheHelper.getCachedTime();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public boolean setMessageContent(int messageId, byte[] messageContent, String objectName) {
        try {
            return this.mClient.setMessageContent(messageId, messageContent, objectName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Message> getUnreadMentionedMessages(int conversationType, String targetId) {
        List<Message> list = null;
        try {
            list = this.mClient.getUnreadMentionedMessages(Conversation.ConversationType.setValue(conversationType), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void sendMediaMessage(Message message, String pushContent, String pushData, final ISendMediaMessageCallback sendMediaMessageCallback) {
        try {
            this.mClient.sendMediaMessage(message, pushContent, pushData, new NativeClient.ISendMediaMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(Message message, int progress) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onProgress(message, progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onCanceled(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendDirectionalMediaMessage(Message message, String[] userIds, String pushContent, String pushData, final ISendMediaMessageCallback sendMediaMessageCallback) {
        try {
            this.mClient.sendMediaMessage(message, userIds, pushContent, pushData, new NativeClient.ISendMediaMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onAttached(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onSuccess(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onProgress(Message message, int progress) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onProgress(message, progress);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onError(message, code);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onCanceled(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onCanceled(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean updateReadReceiptRequestInfo(String msgUId, String info) {
        if (msgUId == null || info == null) {
            RLog.d(TAG, "updateReadReceiptRequestInfo parameter error");
            return false;
        }
        try {
            return this.mClient.updateReadReceiptRequestInfo(msgUId, info);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void registerCmdMsgType(String objName) {
        try {
            this.mClient.registerCmdMsgType(objName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void registerDeleteMessageType(List<String> objNames) {
        try {
            this.mClient.registerDeleteMessageType(objNames);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> searchMessages(String targetId, int conversationType, String keyword, int count, long timestamp) {
        try {
            return this.mClient.searchMessages(targetId, Conversation.ConversationType.setValue(conversationType), keyword, count, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> searchMessagesByUser(String targetId, int conversationType, String userId, int count, long timestamp) {
        try {
            return this.mClient.searchMessagesByUser(targetId, Conversation.ConversationType.setValue(conversationType), userId, count, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<SearchConversationResult> searchConversations(String keyword, int[] conversationTypes, String[] objName) {
        try {
            return this.mClient.searchConversations(keyword, conversationTypes, objName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> getMatchedMessages(String targetId, int conversationType, long timestamp, int before, int after) {
        try {
            return this.mClient.getMatchedMessages(targetId, Conversation.ConversationType.setValue(conversationType), timestamp, before, after);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void getVendorToken(final IStringCallback callback) {
        try {
            this.mClient.getVendorToken(new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setFwLogListenerForSubProcess(final IFwLogCallback callback) {
        try {
            FwLog.setCallbackInSubProcess(this.mContext, new FwLog.ILogEventCallback(){

                @Override
                public void onLogEventFromSubProcess(long timestamp, int level, int type, String tag, String metaJson) {
                    if (callback != null) {
                        try {
                            callback.onLogEventFromSubProcess(timestamp, level, type, tag, metaJson);
                        }
                        catch (RemoteException e) {
                            RLog.e(LibHandlerStub.TAG, "RemoteException when receive log event from ipc process." + e.getMessage());
                        }
                    }
                }

                @Override
                public void onRtLogEventFromSubProcess(long timestamp, int level, int type, String tag, String metaJson) {
                    if (callback != null) {
                        try {
                            callback.onRtLogEventFromSubProcess(timestamp, level, type, tag, metaJson);
                        }
                        catch (RemoteException e) {
                            RLog.e(LibHandlerStub.TAG, "RemoteException when receive realTime log event from ipc process." + e.getMessage());
                        }
                    }
                }

                @Override
                public void onSetLogMonitorEventFromSubProcess(int value) {
                    if (callback != null) {
                        try {
                            callback.onSetLogMonitorEventFromSubProcess(value);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSetTokenEventFromSubProcess(String token) {
                    if (callback != null) {
                        try {
                            callback.onSetTokenEventFromSubProcess(token);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSetUserIdEventFromSubProcess(String userId) {
                    if (callback != null) {
                        try {
                            callback.onSetUserIdEventFromSubProcess(userId);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSetLogServer(String onlineServer, String offlineServer) {
                    if (callback != null) {
                        try {
                            callback.onSetLogServer(onlineServer, offlineServer);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public int onGetProtocolLogStatus() {
                    int status = 0;
                    if (callback != null) {
                        try {
                            status = callback.onGetProtocolLogStatus();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                    return status;
                }
            });
            this.mClient.setLogStatus(FwLog.getProtocolLogStatus(), new NativeObject.NativeLogInfoListener(){

                @Override
                public void OnLogInfo(String log, boolean upload) {
                    FwLog.onProtocolLog(log, upload);
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean getJoinMultiChatRoomEnable() {
        try {
            return NavigationCacheHelper.isJoinMChatroomEnabled(this.mContext);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public String getOfflineMessageDuration() {
        try {
            return this.mClient.getOfflineMessageDuration();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setOfflineMessageDuration(String duration, final ILongCallback callback) {
        try {
            this.mClient.setOfflineMessageDuration(duration, new NativeClient.IResultCallback<Long>(){

                @Override
                public void onSuccess(Long version) {
                    if (callback != null) {
                        try {
                            callback.onComplete(version);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void switchAppKey(String appKey, String deviceId) {
        try {
            this.mClient.switchAppKey(appKey, deviceId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    private void handleRuntimeException(RuntimeException e) {
        FwLog.write(1, 2048, "L-crash_ipc_rtm-F", "stacks|env", FwLog.stackToString(e), CrashDetails.getIMCrashData(this.mContext, e.toString()));
        throw e;
    }

    private void handleRemoteException(RemoteException e) {
        FwLog.write(2, 2048, "L-crash_ipc_rmt-E", "stacks|env", FwLog.stackToString(e), CrashDetails.getIMCrashData(this.mContext, e.toString()));
        e.printStackTrace();
    }

    @Override
    public Message getTheFirstUnreadMessage(int conversationType, String targetId) {
        return this.mClient.getTheFirstUnreadMessage(conversationType, targetId);
    }

    @Override
    public boolean setMessageReadTime(long messageId, long timestamp) {
        try {
            return this.mClient.setMessageReadTime(messageId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean createEncryptedConversation(String targetId, RCEncryptedSession encryptedSession) {
        return this.mClient.createEncryptedConversation(targetId, encryptedSession);
    }

    @Override
    public RCEncryptedSession getEncryptedConversation(String targetId) {
        return this.mClient.getEncryptedConversation(targetId);
    }

    @Override
    public boolean setEncryptedConversation(String targetId, RCEncryptedSession chaInfo) {
        return this.mClient.setEncryptedConversation(targetId, chaInfo);
    }

    @Override
    public boolean removeEncryptedConversation(String targetId) {
        return this.mClient.removeEncryptedConversation(targetId);
    }

    @Override
    public boolean clearEncryptedConversations() {
        return this.mClient.clearEncryptedConversations();
    }

    @Override
    public List<RCEncryptedSession> getAllEncryptedConversations() {
        return this.mClient.getAllEncryptedConversations();
    }

    @Override
    public void setReconnectKickEnable(boolean enable) {
        this.mClient.setReconnectKickEnable(enable);
    }

    @Override
    public int getVideoLimitTime() {
        return this.mClient.getVideoLimitTime();
    }

    @Override
    public void enableHttpsSelfCertificate(boolean isEnable) {
        NetUtils.enableHttpsSelfCertificate(isEnable);
    }

    @Override
    public void setPushNotificationListener(final PushNotificationListener listener) {
        try {
            if (listener != null) {
                NativeClient.PushNotificationListener pushNotificationListener = new NativeClient.PushNotificationListener(){

                    @Override
                    public void OnPushNotificationChanged(long version) {
                        try {
                            listener.OnPushNotificationChanged(version);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.mClient.SetPushNotificationListener(pushNotificationListener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void exitRTCRoom(String roomId, IOperationCallback callback) {
        try {
            this.mClient.exitRTCRoom(roomId, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCUsers(String roomId, int order, final RTCDataListener listener) {
        try {
            this.mClient.getRTCUsers(roomId, order, new NativeClient.IResultCallback<List<RTCUser>>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers) {
                    try {
                        listener.OnSuccess(rtcUsers);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCUserData(String roomId, int order, final RTCDataListener listener) {
        try {
            this.mClient.getRTCUserData(roomId, order, new NativeClient.IResultCallback<List<RTCUser>>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers) {
                    try {
                        listener.OnSuccess(rtcUsers);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void sendRTCPing(String roomId, IOperationCallback callback) {
        try {
            this.mClient.sendRTCPing(roomId, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, "SendRTCPing - " + e.toString());
        }
    }

    @Override
    public boolean useRTCOnly() {
        try {
            return this.mClient.useRTCOnly();
        }
        catch (Exception e) {
            RLog.e(TAG, "UseRTCOnly - " + e.toString());
            return false;
        }
    }

    @Override
    public void rtcPutInnerDatum(String roomId, int type, String key, String value, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcPutInnerDatum(roomId, type, key, value, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcPutInnerDatum - " + e.toString());
        }
    }

    @Override
    public void rtcPutOuterDatum(String roomId, int type, String key, String value, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcPutOuterDatum(roomId, type, key, value, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcPutOuterDatum - " + e.toString());
        }
    }

    @Override
    public void rtcDeleteInnerData(String roomId, int type, String[] keys, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcDeleteInnerData(roomId, type, keys, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcDeleteInnerData - " + e.toString());
        }
    }

    @Override
    public void rtcDeleteOuterData(String roomId, int type, String[] keys, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcDeleteOuterData(roomId, type, keys, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcDeleteOuterData - " + e.toString());
        }
    }

    @Override
    public void rtcGetInnerData(String roomId, int type, String[] keys, final IRtcIODataListener callback) {
        try {
            this.mClient.rtcGetInnerData(roomId, type, keys, new NativeClient.IResultCallback<Map<String, String>>(){

                @Override
                public void onSuccess(Map<String, String> data) {
                    try {
                        callback.OnSuccess(data);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcGetInnerData - " + e.toString());
        }
    }

    @Override
    public void rtcGetOuterData(String roomId, int type, String[] keys, final IRtcIODataListener callback) {
        try {
            this.mClient.rtcGetOuterData(roomId, type, keys, new NativeClient.IResultCallback<Map<String, String>>(){

                @Override
                public void onSuccess(Map<String, String> data) {
                    try {
                        callback.OnSuccess(data);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            RLog.e(TAG, "rtcGetOuterData - " + e.toString());
        }
    }

    @Override
    public void joinRTCRoomAndGetData(String roomId, int roomType, final IRTCJoinRoomCallback listener) {
        try {
            this.mClient.joinRTCRoomAndGetData(roomId, roomType, new NativeClient.IResultCallbackEx<List<RTCUser>, String>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers, String token) {
                    try {
                        listener.OnSuccess(rtcUsers, token);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCConfig(String model, String osVersion, long timestamp, final IRTCConfigCallback callback) throws RemoteException {
        this.mClient.getRTCConfig(model, osVersion, timestamp, new NativeObject.RTCConfigListener(){

            @Override
            public void onSuccess(String config, long version) {
                try {
                    callback.onSuccess(config, version);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    RLog.e(LibHandlerStub.TAG, e.toString());
                }
            }

            @Override
            public void onError(int status) {
                try {
                    callback.onError(status);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    RLog.e(LibHandlerStub.TAG, e.toString());
                }
            }
        });
    }

    @Override
    public void getRTCToken(String roomId, final IStringCallback callback) {
        try {
            this.mClient.getRTCToken(roomId, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    private class OperationCallback
    implements NativeClient.OperationCallback {
        IOperationCallback callback;

        public OperationCallback(IOperationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess() {
            if (this.callback != null) {
                try {
                    this.callback.onComplete();
                }
                catch (RemoteException e) {
                    LibHandlerStub.this.handleRemoteException(e);
                }
            }
        }

        @Override
        public void onError(int code) {
            if (this.callback != null) {
                try {
                    this.callback.onFailure(code);
                }
                catch (RemoteException e) {
                    LibHandlerStub.this.handleRemoteException(e);
                }
            }
        }
    }
}

