/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.destruct;

import android.os.Handler;
import android.os.HandlerThread;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DestructionTaskManager {
    private static final String SPLIT = "'''";
    private static final int TIME_COUNT_DOWN = 1000;
    private static final int TIME_DELETE_DELAYED = 500;
    private Handler mHandler;
    private ExecutorService mSingleThreadPoolExecutor = Executors.newSingleThreadExecutor();
    private final HashMap<Integer, CountDownTask> mCountDownTasks = new HashMap();
    private final Map<String, List<Message>> mDeleteMessages = new HashMap<String, List<Message>>();
    private boolean isCounting = false;
    private boolean isWaitingForDelete = false;
    private OnMessageDestructListener mDestructListener;
    private static final DestructionTaskManager sInstance = new DestructionTaskManager("message-destruct");
    private Runnable mCountDownTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
            synchronized (hashMap) {
                for (CountDownTask task : DestructionTaskManager.this.mCountDownTasks.values()) {
                    task.countDown();
                }
                if (DestructionTaskManager.this.mCountDownTasks.size() == 0) {
                    DestructionTaskManager.this.isCounting = false;
                } else {
                    DestructionTaskManager.this.mHandler.postDelayed((Runnable)this, 1000L);
                }
            }
        }
    };
    private Runnable mDestructingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = DestructionTaskManager.this.mDeleteMessages;
            synchronized (map) {
                for (Map.Entry entry : DestructionTaskManager.this.mDeleteMessages.entrySet()) {
                    String[] key = ((String)entry.getKey()).split(DestructionTaskManager.SPLIT);
                    String targetId = key[0];
                    Conversation.ConversationType type = Conversation.ConversationType.setValue(Integer.valueOf(key[1]));
                    final Message[] deleteMessages = new Message[((List)entry.getValue()).size()];
                    ((List)entry.getValue()).toArray(deleteMessages);
                    RongIMClient.getInstance().deleteRemoteMessages(type, targetId, deleteMessages, new RongIMClient.OperationCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSuccess() {
                            HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                            synchronized (hashMap) {
                                for (Message message : deleteMessages) {
                                    CountDownTask countDownTask = (CountDownTask)DestructionTaskManager.this.mCountDownTasks.get(message.getMessageId());
                                    if (countDownTask != null) {
                                        countDownTask.onMessageDestruct();
                                    }
                                    if (DestructionTaskManager.this.mDestructListener != null) {
                                        DestructionTaskManager.this.mDestructListener.onMessageDestruct(message);
                                    }
                                    DestructionTaskManager.this.mCountDownTasks.remove(message.getMessageId());
                                }
                            }
                        }

                        @Override
                        public void onError(RongIMClient.ErrorCode errorCode) {
                            int[] messageIds = new int[deleteMessages.length];
                            for (int i = 0; i < deleteMessages.length; ++i) {
                                messageIds[i] = deleteMessages[i].getMessageId();
                            }
                            RongIMClient.getInstance().deleteMessages(messageIds, new RongIMClient.ResultCallback<Boolean>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onSuccess(Boolean aBoolean) {
                                    HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                                    synchronized (hashMap) {
                                        for (Message message : deleteMessages) {
                                            CountDownTask countDownTask = (CountDownTask)DestructionTaskManager.this.mCountDownTasks.get(message.getMessageId());
                                            if (countDownTask != null) {
                                                countDownTask.onMessageDestruct();
                                            }
                                            if (DestructionTaskManager.this.mDestructListener != null) {
                                                DestructionTaskManager.this.mDestructListener.onMessageDestruct(message);
                                            }
                                            DestructionTaskManager.this.mCountDownTasks.remove(message.getMessageId());
                                        }
                                    }
                                }

                                @Override
                                public void onError(RongIMClient.ErrorCode e) {
                                }
                            });
                        }
                    });
                }
                DestructionTaskManager.this.mDeleteMessages.clear();
                DestructionTaskManager.this.isWaitingForDelete = false;
            }
        }
    };

    private DestructionTaskManager(String name) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    public static DestructionTaskManager getInstance() {
        return sInstance;
    }

    public void createTask(final Message message, final OnOverTimeChangeListener listener, final long delay, final String tag) {
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                synchronized (hashMap) {
                    CountDownTask countDownTask = new CountDownTask(message, delay, listener, tag);
                    CountDownTask originalCountDownTask = (CountDownTask)DestructionTaskManager.this.mCountDownTasks.get(message.getMessageId());
                    if (originalCountDownTask != null) {
                        originalCountDownTask.addOnOverTimeChangeListener(tag, listener);
                    } else {
                        DestructionTaskManager.this.mCountDownTasks.put(message.getMessageId(), countDownTask);
                    }
                    if (!DestructionTaskManager.this.isCounting) {
                        DestructionTaskManager.this.isCounting = true;
                        DestructionTaskManager.this.mHandler.post(DestructionTaskManager.this.mCountDownTask);
                    }
                }
            }
        });
    }

    public void addOnOverTimeChangeListener(String tag, int messageId, OnOverTimeChangeListener listener) {
        this.mCountDownTasks.get(messageId).addOnOverTimeChangeListener(tag, listener);
    }

    public void setOnMessageDestructListener(OnMessageDestructListener listener) {
        this.mDestructListener = listener;
    }

    public void cancelTask(final int messageId) {
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                synchronized (hashMap) {
                    DestructionTaskManager.this.mCountDownTasks.remove(messageId);
                }
            }
        });
    }

    public void removeListeners(final String tag) {
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                synchronized (hashMap) {
                    for (CountDownTask task : DestructionTaskManager.this.mCountDownTasks.values()) {
                        task.removeListeners(tag);
                    }
                }
            }
        });
    }

    public void cancelAll() {
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = DestructionTaskManager.this.mCountDownTasks;
                synchronized (hashMap) {
                    DestructionTaskManager.this.mCountDownTasks.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRemoteMessage(Conversation.ConversationType conversationType, String targetId, Message message) {
        Map<String, List<Message>> map = this.mDeleteMessages;
        synchronized (map) {
            String key = targetId + SPLIT + conversationType.getValue();
            if (this.mDeleteMessages.containsKey(key)) {
                this.mDeleteMessages.get(key).add(message);
            } else {
                ArrayList<Message> messageList = new ArrayList<Message>();
                messageList.add(message);
                this.mDeleteMessages.put(key, messageList);
            }
            if (!this.isWaitingForDelete) {
                this.isWaitingForDelete = true;
                this.mHandler.postDelayed(this.mDestructingTask, 500L);
            }
        }
    }

    public static interface OnMessageDestructListener {
        public void onMessageDestruct(Message var1);
    }

    public static interface OnOverTimeChangeListener {
        public void onOverTimeChanged(int var1, long var2);

        public void onMessageDestruct(int var1);
    }

    private class CountDownTask {
        private final Map<String, List<OnOverTimeChangeListener>> mListeners = new HashMap<String, List<OnOverTimeChangeListener>>();
        private Message message;
        private long leftTime;

        CountDownTask(Message message, long leftTime, OnOverTimeChangeListener listener, String tag) {
            this.message = message;
            this.leftTime = leftTime;
            this.mListeners.put(tag, new ArrayList<OnOverTimeChangeListener>(Arrays.asList(listener)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void countDown() {
            --this.leftTime;
            if (this.leftTime >= 0L) {
                Map<String, List<OnOverTimeChangeListener>> map = this.mListeners;
                synchronized (map) {
                    for (Map.Entry<String, List<OnOverTimeChangeListener>> entry : this.mListeners.entrySet()) {
                        List<OnOverTimeChangeListener> listeners = entry.getValue();
                        for (OnOverTimeChangeListener listener : listeners) {
                            listener.onOverTimeChanged(this.message.getMessageId(), this.leftTime);
                        }
                    }
                }
            }
            if (this.leftTime == 0L) {
                DestructionTaskManager.this.deleteRemoteMessage(this.message.getConversationType(), this.message.getTargetId(), this.message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onMessageDestruct() {
            Map<String, List<OnOverTimeChangeListener>> map = this.mListeners;
            synchronized (map) {
                for (Map.Entry<String, List<OnOverTimeChangeListener>> entry : this.mListeners.entrySet()) {
                    List<OnOverTimeChangeListener> listeners = entry.getValue();
                    for (OnOverTimeChangeListener listener : listeners) {
                        listener.onMessageDestruct(this.message.getMessageId());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addOnOverTimeChangeListener(String tag, OnOverTimeChangeListener listener) {
            Map<String, List<OnOverTimeChangeListener>> map = this.mListeners;
            synchronized (map) {
                List<OnOverTimeChangeListener> listeners = this.mListeners.get(tag);
                if (listeners == null) {
                    this.mListeners.put(tag, new ArrayList<OnOverTimeChangeListener>(Arrays.asList(listener)));
                } else {
                    listeners.add(listener);
                }
            }
        }

        void removeListeners(String tag) {
            this.mListeners.remove(tag);
        }
    }
}

