/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.destruct;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.MD5;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.message.DestructionCmdMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MessageBufferPool {
    private static final String RETRY_MESSAGES = "retry_messages_%s";
    private static final String SPLIT = "'''";
    private static MessageBufferPool sInstance = new MessageBufferPool();
    private Handler mHandler;
    private final Map<String, Message> mMessageList = new HashMap<String, Message>();
    private ExecutorService mSingleThreadPoolExecutor = Executors.newSingleThreadExecutor();
    private static Context mContext;
    private volatile boolean isActive = false;
    private Runnable mSendMessageTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = MessageBufferPool.this.mMessageList;
            synchronized (map) {
                for (Map.Entry entry : MessageBufferPool.this.mMessageList.entrySet()) {
                    Message message = (Message)entry.getValue();
                    MessageBufferPool.this.sendMessage(message);
                }
                MessageBufferPool.this.mMessageList.clear();
                MessageBufferPool.this.isActive = false;
            }
        }
    };

    private MessageBufferPool() {
        HandlerThread handlerThread = new HandlerThread("message-buffer-pool");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    public static MessageBufferPool getInstance() {
        return sInstance;
    }

    public static void init(Context context) {
        mContext = context;
    }

    public void putMessageInBuffer(final Message message) {
        boolean isDestructionMessage = message.getContent() instanceof DestructionCmdMessage;
        if (!isDestructionMessage) {
            return;
        }
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = MessageBufferPool.this.mMessageList;
                synchronized (map) {
                    String targetId = message.getTargetId();
                    Message msg = (Message)MessageBufferPool.this.mMessageList.get(targetId);
                    if (msg != null) {
                        DestructionCmdMessage destructionCmdMessage = (DestructionCmdMessage)msg.getContent();
                        DestructionCmdMessage newMsg = (DestructionCmdMessage)message.getContent();
                        destructionCmdMessage.getBurnMessageUIds().addAll(newMsg.getBurnMessageUIds());
                    } else {
                        MessageBufferPool.this.mMessageList.put(message.getTargetId(), message);
                    }
                }
                if (!MessageBufferPool.this.isActive) {
                    MessageBufferPool.this.isActive = true;
                    MessageBufferPool.this.mHandler.postDelayed(MessageBufferPool.this.mSendMessageTask, 500L);
                }
            }
        });
    }

    private void cacheFailedMessage(final Message message) {
        this.mSingleThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String key;
                String spName = String.format(MessageBufferPool.RETRY_MESSAGES, MD5.encrypt(RongIMClient.getInstance().getCurrentUserId()));
                SharedPreferences sp = mContext.getSharedPreferences(spName, 0);
                String value = sp.getString(key = message.getTargetId() + MessageBufferPool.SPLIT + message.getConversationType().getValue(), null);
                if (value == null) {
                    value = "";
                }
                StringBuilder sb = new StringBuilder(value);
                DestructionCmdMessage destructionCmdMessage = (DestructionCmdMessage)message.getContent();
                List<String> msgUIds = destructionCmdMessage.getBurnMessageUIds();
                for (int i = 0; i < msgUIds.size(); ++i) {
                    sb.append(MessageBufferPool.SPLIT).append(msgUIds.get(i));
                }
                sp.edit().putString(key, sb.toString()).commit();
            }
        });
    }

    private List<Message> getAndClearFailedMessages() {
        String spName = String.format(RETRY_MESSAGES, MD5.encrypt(RongIMClient.getInstance().getCurrentUserId()));
        SharedPreferences sp = mContext.getSharedPreferences(spName, 0);
        Map messages = sp.getAll();
        ArrayList<Message> messageList = new ArrayList<Message>();
        for (Map.Entry entry : messages.entrySet()) {
            String[] key = ((String)entry.getKey()).split(SPLIT);
            String targetId = key[0];
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(Integer.valueOf(key[1]));
            DestructionCmdMessage message = new DestructionCmdMessage();
            String value = (String)entry.getValue();
            String[] UIds = value.replaceFirst(SPLIT, "").split(SPLIT);
            List<String> msgUIds = Arrays.asList(UIds);
            message.setBurnMessageUIds(msgUIds);
            messageList.add(Message.obtain(targetId, conversationType, message));
        }
        sp.edit().clear().commit();
        return messageList;
    }

    public void retrySendMessages() {
        List<Message> messages = this.getAndClearFailedMessages();
        for (Message message : messages) {
            this.putMessageInBuffer(message);
        }
    }

    private void sendMessage(Message message) {
        RongIMClient.getInstance().sendMessage(message, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                if (errorCode == RongIMClient.ErrorCode.MSG_SEND_OVERFREQUENCY) {
                    MessageBufferPool.this.putMessageInBuffer(message);
                } else {
                    MessageBufferPool.this.cacheFailedMessage(message);
                }
            }
        });
    }
}

