/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FileTransferClient;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.OnProgressListener;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.model.FileInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Request {
    private static final String TAG = Request.class.getSimpleName();
    protected FtConst.MimeType mimeType;
    protected String url;
    protected String method;
    protected Object tag;
    protected String token;
    protected int connTimeout;
    protected int readTimeout;
    protected String serverIp;
    protected String fileName;
    protected long fileLength;
    protected RequestCallBack requestCallBack;
    protected boolean terminated;
    protected FileInfo info;
    protected OnProgressListener listener;
    protected int finished = 0;
    protected String pausedPath;
    protected int messageId;
    protected boolean isMessage;
    private HttpURLConnection conn;

    public Request(Configuration config, RequestCallBack requestCallBack) {
        this.connTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        this.requestCallBack = requestCallBack;
    }

    public Request(FileInfo fileInfo, Configuration config, RequestCallBack requestCallBack, String pausedPath) {
        this.pausedPath = pausedPath;
        this.setFileInfo(fileInfo);
        this.connTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        this.requestCallBack = requestCallBack;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public abstract String getContentType();

    public abstract long getContentLength();

    public abstract String getFormData();

    public abstract String getBoundary();

    public abstract String getUploadedUrl(String var1);

    public abstract FtConst.MimeType getMimeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() {
        BufferedInputStream responseStream = null;
        ByteArrayOutputStream responseData = null;
        FilterOutputStream os = null;
        FileInputStream is = null;
        RandomAccessFile rwd = null;
        boolean supportResumeTransfer = false;
        try {
            if (this.method.equals("POST")) {
                int c;
                int read;
                this.conn = NetUtils.createURLConnection(this.serverIp);
                is = new FileInputStream(new File(this.url));
                this.conn.setUseCaches(false);
                this.conn.setDoOutput(true);
                this.conn.setDoInput(true);
                this.conn.setRequestMethod(this.method);
                this.conn.setRequestProperty("Connection", "close");
                this.conn.setRequestProperty("Charset", "UTF-8");
                this.conn.setRequestProperty("Content-Type", this.getContentType());
                String endBoundary = "\r\n--" + this.getBoundary() + "--";
                String formData = this.getFormData();
                int fileSize = is.available();
                if (fileSize < 0) {
                    this.requestCallBack.onError(31002);
                }
                int total = formData.length() + fileSize + endBoundary.length();
                this.conn.setRequestProperty("Content-Length", total + "");
                this.conn.setFixedLengthStreamingMode(total);
                this.conn.connect();
                os = new DataOutputStream(this.conn.getOutputStream());
                ((DataOutputStream)os).writeBytes(formData);
                int current = formData.length();
                int cachedLength = formData.length();
                int progress = 1;
                this.requestCallBack.onProgress(progress);
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) != -1) {
                    ((DataOutputStream)os).write(buffer, 0, read);
                    cachedLength += read;
                    int size = (int)(100L * (long)(current += read) / (long)total);
                    if (size > progress) {
                        progress = size;
                        this.requestCallBack.onProgress(progress);
                    }
                    if (cachedLength > 0x200000) {
                        ((DataOutputStream)os).flush();
                        cachedLength = 0;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                    this.terminated = true;
                    this.requestCallBack.onCanceled(this.tag);
                    throw new InterruptedIOException();
                }
                ((DataOutputStream)os).writeBytes(endBoundary);
                this.requestCallBack.onProgress(100);
                is.close();
                ((DataOutputStream)os).flush();
                responseStream = new BufferedInputStream(this.conn.getInputStream());
                responseData = new ByteArrayOutputStream(1024);
                while ((c = responseStream.read()) != -1) {
                    responseData.write(c);
                }
                int responseCode = this.conn.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    this.requestCallBack.onError(30002);
                } else {
                    String url = this.getUploadedUrl(responseData.toString());
                    this.requestCallBack.onComplete(url);
                }
            } else if (this.method.equals("GET")) {
                supportResumeTransfer = FileTransferClient.checkSupportResumeTransfer(this.url);
                if (!supportResumeTransfer) {
                    this.sendRequestNotSupportResumeTransfer(responseStream, responseData, (DataOutputStream)os, is);
                } else {
                    this.sendRequestSupportResumeTransfer(rwd);
                }
            }
        }
        catch (Exception e) {
            if (!this.terminated) {
                this.requestCallBack.onError(30002);
                if (supportResumeTransfer) {
                    FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                }
            }
            RLog.e(TAG, "sendRequest", e);
        }
        finally {
            try {
                if (responseData != null) {
                    responseData.close();
                }
                if (responseStream != null) {
                    responseStream.close();
                }
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest", e);
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
            try {
                if (rwd != null) {
                    rwd.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestForNoneMessage() {
        BufferedInputStream responseStream = null;
        ByteArrayOutputStream responseData = null;
        FilterOutputStream os = null;
        FileInputStream is = null;
        RandomAccessFile rwd = null;
        boolean supportResumeTransfer = false;
        try {
            if (this.method.equals("GET")) {
                supportResumeTransfer = FileTransferClient.checkSupportResumeTransfer(this.url);
                if (!supportResumeTransfer) {
                    this.sendRequestNotSupportResumeTransfer(responseStream, responseData, (DataOutputStream)os, is);
                } else {
                    this.sendRequestSupportResumeTransfer(rwd);
                }
            }
        }
        catch (Exception e) {
            if (!this.terminated) {
                this.requestCallBack.onError(30002);
                if (supportResumeTransfer) {
                    FileTransferClient.getInstance().addToFileDownloadMap(this.url, false);
                }
            }
            RLog.e(TAG, "sendRequestForNoneMessage", e);
        }
        finally {
            try {
                if (responseData != null) {
                    responseData.close();
                }
                if (responseStream != null) {
                    responseStream.close();
                }
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequestForNoneMessage", e);
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
            try {
                if (rwd != null) {
                    rwd.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequestForNoneMessage", e);
            }
        }
    }

    private void sendRequestSupportResumeTransfer(RandomAccessFile rwd) throws Exception {
        this.getLength();
        int sliceLength = FileTransferClient.getInstance().getDownloadEachSliceLength();
        long start = this.info.getFinished();
        if (start == this.info.getLength()) {
            this.downloadComplete();
        } else if (start + (long)sliceLength - 1L > this.info.getLength()) {
            this.downloadInOnceSlice(start, rwd);
        } else {
            this.downloadInMultiSlice(start, sliceLength, rwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInMultiSlice(long start, int sliceLength, RandomAccessFile rwd) {
        long finished = start;
        long end = 0L;
        while (finished < this.info.getLength()) {
            HttpURLConnection conn = null;
            try {
                conn = NetUtils.createURLConnection(this.url);
                conn.setRequestMethod(this.method);
                conn.setConnectTimeout(3000);
                end = finished + (long)sliceLength >= this.info.getLength() ? this.info.getLength() - 1L : finished + (long)sliceLength - 1L;
                conn.setRequestProperty("Range", "bytes=" + finished + "-" + end);
                File file = new File(this.info.getFileName());
                rwd = new RandomAccessFile(file, "rwd");
                rwd.seek(finished);
                RLog.d(TAG, "downloadInMultiSlice conn code :" + conn.getResponseCode());
                if (conn.getResponseCode() < 200 || conn.getResponseCode() >= 300) {
                    this.requestCallBack.onError(30002);
                    if (this.isMessage) {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                    } else {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                    }
                } else if (conn.getResponseCode() == 206) {
                    int len;
                    InputStream inputStream = conn.getInputStream();
                    byte[] buffer = new byte[4096];
                    long total = this.info.getLength();
                    long current = this.info.getFinished();
                    int progress = 0;
                    while ((len = inputStream.read(buffer)) != -1) {
                        String saveString;
                        rwd.write(buffer, 0, len);
                        this.info.setFinished(finished += (long)len);
                        FileInfo savedFileInfo = null;
                        String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
                        if (!TextUtils.isEmpty((CharSequence)savedFileInfoString) && (savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString)).getFinished() > finished) {
                            return;
                        }
                        int temp = (int)(100L * (current += (long)len) / total);
                        if (progress < temp) {
                            progress = temp;
                            this.requestCallBack.onProgress(progress);
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                            this.terminated = true;
                            this.requestCallBack.onCanceled(this.tag);
                            throw new InterruptedIOException();
                        }
                        if (this.info.isStop()) {
                            this.info.setDownLoading(false);
                            saveString = this.getSaveJsonString();
                            FileUtils.saveFile(saveString, this.pausedPath);
                            if (this.isMessage) {
                                FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                            } else {
                                FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                            }
                            return;
                        }
                        this.info.setDownLoading(true);
                        this.info.setStop(false);
                        saveString = this.getSaveJsonString();
                        FileUtils.saveFile(saveString, this.pausedPath);
                        if (this.isMessage) {
                            FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), true);
                            continue;
                        }
                        FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), true);
                    }
                }
            }
            catch (Exception e) {
                if (!this.terminated) {
                    this.requestCallBack.onError(30002);
                    if (this.isMessage) {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                    } else {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                    }
                }
                RLog.e(TAG, "downloadInMultiSlice", e);
                break;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                    conn = null;
                }
                try {
                    if (rwd != null) {
                        rwd.close();
                    }
                }
                catch (IOException exception) {
                    RLog.e(TAG, "downloadInMultiSlice", exception);
                }
            }
            if (end != this.info.getLength() - 1L) continue;
            this.downloadComplete();
        }
    }

    private void downloadInOnceSlice(long start, RandomAccessFile rwd) throws Exception {
        this.conn = NetUtils.createURLConnection(this.url);
        this.conn.setRequestMethod(this.method);
        this.conn.setConnectTimeout(3000);
        this.conn.setRequestProperty("Range", "bytes=" + start + "-" + (this.info.getLength() - 1L));
        File file = new File(this.info.getFileName());
        rwd = new RandomAccessFile(file, "rwd");
        rwd.seek(start);
        this.finished = (int)((long)this.finished + this.info.getFinished());
        RLog.d(TAG, "downloadInOnceSlice conn code :" + this.conn.getResponseCode());
        if (this.conn.getResponseCode() < 200 || this.conn.getResponseCode() >= 300) {
            this.requestCallBack.onError(30002);
            if (this.isMessage) {
                FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
            } else {
                FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), false);
            }
        } else if (this.conn.getResponseCode() == 206) {
            int len;
            InputStream inputStream = this.conn.getInputStream();
            byte[] buffer = new byte[4096];
            long total = this.info.getLength();
            long current = this.info.getFinished();
            int progress = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                String saveString;
                rwd.write(buffer, 0, len);
                this.finished += len;
                this.info.setFinished(this.finished);
                FileInfo savedFileInfo = null;
                String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
                if (!TextUtils.isEmpty((CharSequence)savedFileInfoString) && (savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString)).getFinished() > (long)this.finished) {
                    return;
                }
                int temp = (int)(100L * (current += (long)len) / total);
                if (progress < temp) {
                    progress = temp;
                    this.requestCallBack.onProgress(temp);
                }
                if (Thread.currentThread().isInterrupted()) {
                    RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                    this.terminated = true;
                    this.requestCallBack.onCanceled(this.tag);
                    throw new InterruptedIOException();
                }
                if (this.info.isStop()) {
                    this.info.setDownLoading(false);
                    saveString = this.getSaveJsonString();
                    FileUtils.saveFile(saveString, this.pausedPath);
                    if (this.isMessage) {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                    } else {
                        FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                    }
                    return;
                }
                this.info.setDownLoading(true);
                this.info.setStop(false);
                saveString = this.getSaveJsonString();
                FileUtils.saveFile(saveString, this.pausedPath);
                if (this.isMessage) {
                    FileTransferClient.getInstance().addToFileDownloadMap(this.info.getMessageId(), true);
                    continue;
                }
                FileTransferClient.getInstance().addToFileDownloadMap(this.tag.toString(), true);
            }
            this.downloadComplete();
        }
    }

    private void downloadComplete() {
        this.info.setDownLoading(false);
        this.requestCallBack.onComplete(this.info.getFileName());
        FileUtils.removeFile(this.pausedPath);
        if (this.isMessage) {
            FileTransferClient.getInstance().removeFromFileDownloadMap(this.info.getMessageId());
        } else {
            FileTransferClient.getInstance().removeFromFileDownloadMap(this.tag.toString());
        }
    }

    private void sendRequestNotSupportResumeTransfer(BufferedInputStream responseStream, ByteArrayOutputStream responseData, DataOutputStream os, FileInputStream is) throws Exception {
        this.conn = NetUtils.createURLConnection(this.url);
        this.conn.setUseCaches(false);
        this.conn.setRequestMethod(this.method);
        this.conn.setDoInput(true);
        this.conn.connect();
        int responseCode = this.conn.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            this.requestCallBack.onError(30002);
            RLog.d("fileTransfer", "download request response code is " + responseCode);
        } else {
            int length;
            responseStream = new BufferedInputStream(this.conn.getInputStream());
            int total = this.conn.getContentLength();
            int current = 0;
            int cachedLength = 0;
            responseData = new ByteArrayOutputStream(1024);
            int progress = 0;
            byte[] buffer = new byte[1024];
            File f = new File(this.fileName);
            FileOutputStream fos = new FileOutputStream(f);
            while ((length = responseStream.read(buffer)) != -1) {
                responseData.write(buffer, 0, length);
                cachedLength += length;
                int temp = (int)(100L * (long)(current += length) / (long)total);
                if (progress < temp) {
                    progress = temp;
                    this.requestCallBack.onProgress(temp);
                }
                if (Thread.currentThread().isInterrupted()) {
                    RLog.w(TAG, "sendRequest terminated.");
                    this.terminated = true;
                    this.requestCallBack.onCanceled(this.tag);
                    throw new InterruptedIOException();
                }
                if (cachedLength <= 0x100000) continue;
                fos.write(responseData.toByteArray(), 0, responseData.size());
                responseData.reset();
                cachedLength = 0;
            }
            fos.write(responseData.toByteArray(), 0, responseData.size());
            fos.close();
            this.requestCallBack.onComplete(this.fileName);
        }
    }

    private String getSaveJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("filename", (Object)this.info.getFileName());
            jsonObject.put("url", (Object)this.info.getUrl());
            jsonObject.put("length", this.info.getLength());
            jsonObject.put("finish", this.info.getFinished());
            jsonObject.put("isStop", this.info.isStop());
            jsonObject.put("isDownLoading", this.info.isDownLoading());
        }
        catch (JSONException e) {
            RLog.e(TAG, "getSaveJsonString", e);
        }
        if (jsonObject != null) {
            return jsonObject.toString();
        }
        return null;
    }

    private FileInfo getFileInfoFromJsonString(String jsonString) {
        FileInfo fileInfo = new FileInfo();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            fileInfo.setFileName(jsonObject.optString("filename"));
            fileInfo.setUrl(jsonObject.optString("url"));
            fileInfo.setLength(jsonObject.optLong("length"));
            fileInfo.setFinished(jsonObject.optLong("finish"));
            fileInfo.setStop(jsonObject.optBoolean("isStop", false));
            fileInfo.setDownLoading(jsonObject.optBoolean("isDownLoading", false));
        }
        catch (JSONException e) {
            RLog.e(TAG, "getFileInfoFromJsonString", e);
        }
        return fileInfo;
    }

    private void setFileInfo(FileInfo fileInfo) {
        try {
            this.info = fileInfo;
            FileInfo savedFileInfo = null;
            String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
            if (!TextUtils.isEmpty((CharSequence)savedFileInfoString)) {
                savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString);
            }
            if (savedFileInfo != null) {
                this.info.setFinished(savedFileInfo.getFinished());
                this.info.setDownLoading(savedFileInfo.isDownLoading());
                this.info.setLength(savedFileInfo.getLength());
                this.info.setFileName(savedFileInfo.getFileName());
                this.info.setUrl(savedFileInfo.getUrl());
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "setFileInfo", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLength() {
        HttpURLConnection connection = null;
        if (this.fileLength > 0L) {
            this.info.setLength(this.fileLength);
        } else {
            try {
                connection = NetUtils.createURLConnection(this.info.getUrl());
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3000);
                long length = -1L;
                if (connection.getResponseCode() == 200) {
                    length = Long.parseLong(connection.getHeaderField("Content-Length"));
                }
                if (length <= 0L) {
                    RLog.e(TAG, "file length from server is 0. Return directly!");
                }
                this.info.setLength(length);
            }
            catch (Exception e) {
                RLog.e(TAG, "getLength", e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                catch (Exception e) {
                    RLog.e(TAG, "getLength", e);
                }
            }
        }
    }
}

