/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.PublicServiceMenuItem;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PublicServiceMenu
implements Parcelable {
    private static final String TAG = PublicServiceMenu.class.getSimpleName();
    private List<PublicServiceMenuItem> menuItems;
    public static final Parcelable.Creator<PublicServiceMenu> CREATOR = new Parcelable.Creator<PublicServiceMenu>(){

        public PublicServiceMenu createFromParcel(Parcel source) {
            return new PublicServiceMenu(source);
        }

        public PublicServiceMenu[] newArray(int size) {
            return new PublicServiceMenu[size];
        }
    };

    public List<PublicServiceMenuItem> getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(List<PublicServiceMenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public PublicServiceMenu(JSONArray jsonArray) {
        this.menuItems = new ArrayList<PublicServiceMenuItem>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject jsonItem = jsonArray.optJSONObject(i);
                PublicServiceMenuItem item = new PublicServiceMenuItem(jsonItem);
                this.menuItems.add(item);
                continue;
            }
            catch (Exception e) {
                RLog.e(TAG, "PublicServiceMenu ", e);
            }
        }
    }

    private PublicServiceMenu() {
    }

    public int describeContents() {
        return 0;
    }

    public PublicServiceMenu(Parcel in) {
        this.menuItems = ParcelUtils.readListFromParcel(in, PublicServiceMenuItem.class);
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeListToParcel(dest, this.menuItems);
    }

    public static enum PublicServiceMenuItemType {
        Group(0, "GROUP"),
        View(1, "VIEW"),
        Click(2, "CLICK"),
        Entry(3, "ENTRY");

        private int value = 1;
        private String command;

        private PublicServiceMenuItemType(int value, String command) {
            this.value = value;
            this.command = command;
        }

        public int getValue() {
            return this.value;
        }

        public String getMessage() {
            return this.command;
        }

        public static PublicServiceMenuItemType setValue(int code) {
            for (PublicServiceMenuItemType c : PublicServiceMenuItemType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return null;
        }
    }
}

