/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.PublicServiceMenu;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicServiceMenuItem
implements Parcelable {
    private static final String TAG = PublicServiceMenuItem.class.getSimpleName();
    private String id;
    private String name;
    private String url;
    private PublicServiceMenu.PublicServiceMenuItemType type;
    private List<PublicServiceMenuItem> subMenuItems = new ArrayList<PublicServiceMenuItem>();
    public static final Parcelable.Creator<PublicServiceMenuItem> CREATOR = new Parcelable.Creator<PublicServiceMenuItem>(){

        public PublicServiceMenuItem createFromParcel(Parcel source) {
            return new PublicServiceMenuItem(source);
        }

        public PublicServiceMenuItem[] newArray(int size) {
            return new PublicServiceMenuItem[size];
        }
    };

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public PublicServiceMenu.PublicServiceMenuItemType getType() {
        return this.type;
    }

    public List<PublicServiceMenuItem> getSubMenuItems() {
        return this.subMenuItems;
    }

    public String getId() {
        return this.id;
    }

    public PublicServiceMenuItem(JSONObject jsonItem) throws Exception {
        try {
            if (jsonItem.has("id")) {
                this.id = jsonItem.optString("id");
            }
            if (jsonItem.has("name")) {
                this.name = jsonItem.optString("name");
            }
            if (jsonItem.has("url")) {
                this.url = jsonItem.optString("url");
            }
            if (jsonItem.has("type")) {
                JSONArray jsonArray;
                this.type = PublicServiceMenu.PublicServiceMenuItemType.setValue(jsonItem.optInt("type"));
                if (this.type != null && this.type == PublicServiceMenu.PublicServiceMenuItemType.Group && jsonItem.has("children") && (jsonArray = jsonItem.getJSONArray("children")) != null) {
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonSubItem = jsonArray.optJSONObject(i);
                        if (jsonSubItem == null) continue;
                        try {
                            PublicServiceMenuItem item = new PublicServiceMenuItem(jsonSubItem);
                            this.subMenuItems.add(item);
                            continue;
                        }
                        catch (Exception e) {
                            RLog.e(TAG, "PublicServiceMenuItem ", e);
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "PublicServiceMenuItem", e);
            throw new Exception("PublicServiceMenuItem parse error!");
        }
    }

    private PublicServiceMenuItem() {
    }

    public int describeContents() {
        return 0;
    }

    public PublicServiceMenuItem(Parcel in) {
        this.id = ParcelUtils.readFromParcel(in);
        this.name = ParcelUtils.readFromParcel(in);
        this.url = ParcelUtils.readFromParcel(in);
        this.type = PublicServiceMenu.PublicServiceMenuItemType.setValue(ParcelUtils.readIntFromParcel(in));
        this.subMenuItems = ParcelUtils.readListFromParcel(in, PublicServiceMenuItem.class);
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.id);
        ParcelUtils.writeToParcel(dest, this.name);
        ParcelUtils.writeToParcel(dest, this.url);
        ParcelUtils.writeToParcel(dest, this.type != null ? Integer.valueOf(this.type.getValue()) : null);
        ParcelUtils.writeToParcel(dest, this.subMenuItems);
    }
}

