/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.navigation;

import android.content.Context;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.navigation.LocationConfig;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationObserver;
import io.rong.imlib.statistics.CrashDetails;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NavigationClient {
    private static final String TAG = "NavigationClient";
    private static final String NAVIGATION_HTTP_IP_URL = "http://%s/navi.xml";
    private static final String NAVIGATION_HTTPS_URL = "https://nav.cn.ronghub.com/navi.xml";
    private static final String NAVIGATION_HTTP_URL = "http://nav.cn.ronghub.com/navi.xml";
    private static final String NAVIGATION_2_HTTPS_URL = "https://nav2-cn.ronghub.com/navi.xml";
    private static final String NAVIGATION_2_HTTP_URL = "http://nav2-cn.ronghub.com/navi.xml";
    private List<String> naviUrlList = new ArrayList<String>();
    private final String NAVI_SPLIT_SYMBOL = ";";
    private String naviString = "";
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Context context;
    private NavigationObserver navigationObserver;
    private boolean isRetrying = false;

    private NavigationClient() {
        if (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted()) {
            this.naviUrlList.add(NAVIGATION_HTTPS_URL);
            this.naviUrlList.add(NAVIGATION_2_HTTPS_URL);
        } else {
            this.naviUrlList.add(NAVIGATION_HTTP_URL);
            this.naviUrlList.add(NAVIGATION_2_HTTP_URL);
        }
    }

    public static NavigationClient getInstance() {
        return SingletonHolder.sIns;
    }

    public void setNaviDomainList(String navi) {
        this.naviString = navi;
        if (this.naviUrlList != null) {
            this.naviUrlList.clear();
        }
        if (navi == null) {
            return;
        }
        String[] naviArray = navi.split(";");
        for (int i = 0; i < naviArray.length; ++i) {
            int index;
            String naviUrl = TextUtils.isEmpty((CharSequence)naviArray[i]) ? "" : this.formatServerAddress(naviArray[i], "navi.xml");
            int n = index = TextUtils.isEmpty((CharSequence)naviUrl) ? 0 : this.naviUrlList.indexOf(naviUrl.toLowerCase());
            if (index == -1) {
                this.naviUrlList.add(naviUrl.toLowerCase());
            }
            naviArray[i] = null;
        }
    }

    public String formatServerAddress(String domain, String path) {
        String strFormat = domain.toLowerCase().startsWith("http") ? "%s/%s" : (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? "https://%s/%s" : "http://%s/%s");
        return String.format(strFormat, domain, path);
    }

    public List<String> getNaviDomainList() {
        return this.naviUrlList;
    }

    public void addObserver(NavigationObserver observer) {
        this.navigationObserver = observer;
    }

    public void clearObserver() {
        this.navigationObserver = null;
    }

    public String getCMPServer() {
        return NavigationCacheHelper.getCMPServer(this.context);
    }

    public long getLastCachedTime() {
        return NavigationCacheHelper.getCachedTime();
    }

    public void getCMPServerString(Context context, final String appKey, final String token) {
        this.context = context;
        if (NavigationCacheHelper.isCacheValid(context, appKey, token, this.naviString)) {
            if (this.navigationObserver != null) {
                NativeObject.ConnectionEntry[] connectionEntries = NavigationCacheHelper.getSortedComplexConnectionEntries(context);
                String userId = NavigationCacheHelper.getUserId(context);
                RLog.d(TAG, "[connect] cmp from cache: " + NativeClient.connectionEntryArrayToString(connectionEntries));
                this.navigationObserver.onSuccess(userId, connectionEntries);
            }
        } else {
            RLog.d(TAG, "[connect] isCacheValid:false");
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    NavigationClient.this.requestNavi(appKey, token, false);
                }
            });
        }
    }

    private void requestNavi(String appKey, String token, boolean forceUpdate) {
        try {
            if (this.naviUrlList != null && this.naviUrlList.size() > 0) {
                Iterator<String> iterator = this.naviUrlList.iterator();
                while (iterator.hasNext()) {
                    String naviUrl;
                    boolean isLastNavi = this.naviUrlList.indexOf(naviUrl = iterator.next()) == this.naviUrlList.size() - 1;
                    boolean result = this.requestAndRetry(naviUrl, appKey, token, forceUpdate, isLastNavi);
                    if (result) {
                        return;
                    }
                    String lastSuccessIp = NavigationCacheHelper.getLastSuccessIp(this.context);
                    if (TextUtils.isEmpty((CharSequence)lastSuccessIp)) continue;
                    this.isRetrying = true;
                    String url = String.format(NAVIGATION_HTTP_IP_URL, lastSuccessIp);
                    result = this.request(url, appKey, token, forceUpdate, true);
                    if (result) continue;
                    NavigationCacheHelper.updateLastSuccessIp(this.context, "");
                }
            }
        }
        catch (Exception e) {
            String reason = e.toString();
            reason = reason.substring(0, reason.indexOf(":"));
            FwLog.write(1, 2048, "L-crash_ipc_ept-F", "stacks|reason|env", FwLog.stackToString(e), reason, CrashDetails.getIMCrashData(this.context, e.toString()));
        }
    }

    public boolean isMPOpened(Context context) {
        return NavigationCacheHelper.isMPOpened(context);
    }

    public boolean isGROpened(Context context) {
        return NavigationCacheHelper.isGetRemoteEnabled(context);
    }

    public int getGroupMessageLimit(Context context) {
        return NavigationCacheHelper.getGroupMessageLimit(context);
    }

    public boolean isUSOpened(Context context) {
        return NavigationCacheHelper.isUSOpened(context);
    }

    public boolean isJoinMChatroomEnabled(Context context) {
        return NavigationCacheHelper.isJoinMChatroomEnabled(context);
    }

    public String getUserId(Context context) {
        return NavigationCacheHelper.getUserId(context);
    }

    public void requestCmpIfNeed(Context context, final String appKey, final String token) {
        if (NavigationCacheHelper.isCacheTimeout(context)) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    NavigationClient.this.requestNavi(appKey, token, true);
                }
            });
        }
    }

    public void clearCache(Context context) {
        NavigationCacheHelper.clearCache(context);
    }

    public void clearCacheTime(Context context) {
        NavigationCacheHelper.updateTime(context, 0L);
    }

    public String getVoIPCallInfo(Context context) {
        return NavigationCacheHelper.getVoIPCallInfo(context);
    }

    public String getMediaServer(Context context) {
        return NavigationCacheHelper.getMediaServer(context);
    }

    public boolean isGetRemoteHistoryEnabled(Context context) {
        return NavigationCacheHelper.isGetRemoteEnabled(context);
    }

    public boolean isChatroomHistoryEnabled(Context context) {
        return NavigationCacheHelper.isChatroomHistoryEnabled(context);
    }

    public LocationConfig getLocationConfig(Context context) {
        return NavigationCacheHelper.getLocationConfig(context);
    }

    private boolean requestAndRetry(String naviUrl, String appKey, String token, boolean forceUpdate, boolean isLastNavi) {
        this.isRetrying = false;
        return this.request(naviUrl, appKey, token, forceUpdate, isLastNavi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean request(String urlStr, String appKey, String token, boolean forceUpdate, boolean isLastNavi) {
        FwLog.write(4, 16, "L-get_navi-T", "url|ip", urlStr, NavigationClient.getHostIp(urlStr));
        RLog.d(TAG, "[connect] request " + urlStr + ", appKey:" + appKey + ", token: " + token + ", forceUpdate:" + forceUpdate);
        HttpURLConnection connection = null;
        BufferedInputStream responseStream = null;
        int responseCode = 0;
        boolean requestResult = false;
        long start_time = System.currentTimeMillis();
        String ip = NavigationClient.getHostIp(urlStr);
        try {
            int c;
            connection = this.createConnection(urlStr, appKey, token);
            connection.connect();
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode != 200 ? connection.getErrorStream() : connection.getInputStream();
            responseStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream responseData = new ByteArrayOutputStream(512);
            while ((c = responseStream.read()) != -1) {
                responseData.write(c);
            }
            String data = new String(responseData.toByteArray(), "utf-8").trim();
            long delta = System.currentTimeMillis() - start_time;
            FwLog.write(4, 16, "L-get_navi-R", "code|url|duration|ip", responseCode, urlStr, delta, ip);
            int result = NavigationCacheHelper.decode2File(this.context, data, responseCode);
            String userId = NavigationCacheHelper.getUserId(this.context);
            if (result == 0) {
                FwLog.write(4, 16, "L-decode_navi-S", "code", result);
                NavigationCacheHelper.clearComplexConnectionEntries(this.context);
                if (this.navigationObserver != null) {
                    NativeObject.ConnectionEntry[] connectionEntries = NavigationCacheHelper.getSortedComplexConnectionEntries(this.context);
                    this.navigationObserver.onSuccess(userId, connectionEntries);
                }
                NavigationCacheHelper.cacheRequest(this.context, appKey, token);
                if (!TextUtils.isEmpty((CharSequence)ip)) {
                    NavigationCacheHelper.updateLastSuccessIp(this.context, ip);
                }
                NavigationCacheHelper.cacheLastSuccessNaviDomainList(this.context, this.naviString);
                requestResult = true;
            } else {
                FwLog.write(2, 16, "L-decode_navi-S", "code|data", result, data.replaceAll("\\n", ""));
                if (this.navigationObserver != null && isLastNavi) {
                    NativeObject.ConnectionEntry[] connectionEntries = NavigationCacheHelper.getSortedComplexConnectionEntries(this.context);
                    this.navigationObserver.onError(userId, connectionEntries, result);
                }
                RLog.e(TAG, "request failure : " + result + ", data = " + data);
            }
        }
        catch (Exception e) {
            FwLog.write(2, 2048, "L-crash_ipc_ept-F", "stacks|env", FwLog.stackToString(e), CrashDetails.getIMCrashData(this.context, e.toString()));
            String lastIp = NavigationCacheHelper.getLastSuccessIp(this.context);
            if (this.navigationObserver != null && (this.isRetrying || TextUtils.isEmpty((CharSequence)lastIp)) && isLastNavi) {
                String userId = NavigationCacheHelper.getUserId(this.context);
                NativeObject.ConnectionEntry[] connectionEntries = NavigationCacheHelper.getSortedComplexConnectionEntries(this.context);
                this.navigationObserver.onError(userId, connectionEntries, 30004);
            }
            RLog.e(TAG, "request exception. isRetry:" + this.isRetrying + "; lastIp: " + lastIp);
        }
        finally {
            RLog.i(TAG, "request end: " + responseCode + ", force = " + forceUpdate);
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException ignored) {
                    RLog.e(TAG, "IOException ", ignored);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return requestResult;
    }

    private HttpURLConnection createConnection(String urlStr, String appKey, String token) throws IOException {
        HttpURLConnection conn = NetUtils.createURLConnection(urlStr);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(10000);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("User-Agent", "RongCloud");
        String host = NavigationClient.getNavHost(urlStr);
        if (!TextUtils.isEmpty((CharSequence)host)) {
            conn.setRequestProperty("Host", host);
        }
        String params = "token=";
        params = params + URLEncoder.encode(token, "UTF-8");
        params = params + "&v=2.9.18";
        params = params + "&p=Android";
        conn.setRequestProperty("Content-Length", String.valueOf(params.length()));
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("appId", appKey);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStream os = conn.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        writer.write(params);
        writer.flush();
        writer.close();
        os.close();
        return conn;
    }

    private static String getNavHost(String navi) {
        try {
            URL url = new URL(navi);
            String host = url.getHost();
            int port = url.getPort();
            if (port != -1 && url.getDefaultPort() != url.getPort()) {
                host = host + ":" + port;
            }
            return host;
        }
        catch (MalformedURLException e) {
            RLog.e(TAG, "MalformedURLException ", e);
            return null;
        }
    }

    private static String getHostIp(String urlStr) {
        try {
            URL url = new URL(urlStr);
            String host = url.getHost();
            InetAddress address = InetAddress.getByName(host);
            return address.getHostAddress();
        }
        catch (MalformedURLException e) {
            FwLog.write(2, 2048, "L-dns_parse-F", "catch", "MalformedURLException");
            RLog.e(TAG, "MalformedURLException ", e);
        }
        catch (UnknownHostException e) {
            FwLog.write(2, 2048, "L-dns_parse-F", "catch", "UnknownHostException");
            RLog.e(TAG, "UnknownHostException ", e);
        }
        catch (Exception e) {
            FwLog.write(2, 2048, "L-dns_parse-F", "catch|stacks", "Exception", FwLog.stackToString(e));
        }
        return null;
    }

    private static class SingletonHolder {
        private static NavigationClient sIns = new NavigationClient();

        private SingletonHolder() {
        }
    }
}

