/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import io.rong.imlib.statistics.Event;
import io.rong.imlib.statistics.Statistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class StatisticsStore {
    private static final String PREFERENCES = "COUNTLY_STORE";
    private static final String DELIMITER = ":::";
    private static final String CONNECTIONS_PREFERENCE = "CONNECTIONS";
    private static final String LATEST_UPLOAD = "LATEST";
    private static final String EVENTS_PREFERENCE = "EVENTS";
    private static final String LOCATION_PREFERENCE = "LOCATION";
    private static final int UPLOAD_DURATION = 86400;
    private final SharedPreferences preferences_;

    StatisticsStore(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("must provide valid context");
        }
        this.preferences_ = context.getSharedPreferences(PREFERENCES, 0);
    }

    public String[] connections() {
        String joinedConnStr = this.preferences_.getString(CONNECTIONS_PREFERENCE, "");
        return joinedConnStr.length() == 0 ? new String[]{} : joinedConnStr.split(DELIMITER);
    }

    public String[] events() {
        String joinedEventsStr = this.preferences_.getString(EVENTS_PREFERENCE, "");
        return joinedEventsStr.length() == 0 ? new String[]{} : joinedEventsStr.split(DELIMITER);
    }

    public List<Event> eventsList() {
        String[] array = this.events();
        ArrayList<Event> events = new ArrayList<Event>(array.length);
        for (String s : array) {
            try {
                Event event = Event.fromJSON(new JSONObject(s));
                if (event == null) continue;
                events.add(event);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event e1, Event e2) {
                return e1.timestamp - e2.timestamp;
            }
        });
        return events;
    }

    public boolean isEmptyConnections() {
        return this.preferences_.getString(CONNECTIONS_PREFERENCE, "").length() == 0;
    }

    public synchronized void addConnection(String str) {
        if (str != null && str.length() > 0) {
            ArrayList<String> connections = new ArrayList<String>(Arrays.asList(this.connections()));
            connections.add(str);
            this.preferences_.edit().putString(CONNECTIONS_PREFERENCE, StatisticsStore.join(connections, DELIMITER)).commit();
        }
    }

    public boolean uploadIfNeed() {
        int current = Statistics.currentTimestamp();
        int time = this.preferences_.getInt(LATEST_UPLOAD, 0);
        if (Statistics.sharedInstance().isLoggingEnabled()) {
            Log.w((String)"Statistics", (String)("uploadIfNeed : last = " + time + ", current = " + current));
        }
        if (time == 0) {
            this.updateLatestUploadTime();
            return true;
        }
        if ((time += 86400) <= current) {
            this.updateLatestUploadTime();
            return true;
        }
        return false;
    }

    public void updateLatestUploadTime() {
        this.preferences_.edit().putInt(LATEST_UPLOAD, Statistics.currentTimestamp()).commit();
    }

    public synchronized void removeConnection(String str) {
        ArrayList<String> connections;
        if (str != null && str.length() > 0 && (connections = new ArrayList<String>(Arrays.asList(this.connections()))).remove(str)) {
            this.preferences_.edit().putString(CONNECTIONS_PREFERENCE, StatisticsStore.join(connections, DELIMITER)).commit();
        }
    }

    void addEvent(Event event) {
        List<Event> events = this.eventsList();
        events.add(event);
        this.preferences_.edit().putString(EVENTS_PREFERENCE, StatisticsStore.joinEvents(events, DELIMITER)).commit();
    }

    void setLocation(double lat, double lon) {
        this.preferences_.edit().putString(LOCATION_PREFERENCE, lat + "," + lon).commit();
    }

    String getAndRemoveLocation() {
        String location = this.preferences_.getString(LOCATION_PREFERENCE, "");
        if (!location.equals("")) {
            this.preferences_.edit().remove(LOCATION_PREFERENCE).commit();
        }
        return location;
    }

    public synchronized void addEvent(String key, Map<String, String> segmentation, int timestamp, int count, double sum) {
        Event event = new Event();
        event.key = key;
        event.segmentation = segmentation;
        event.timestamp = timestamp;
        event.count = count;
        event.sum = sum;
        this.addEvent(event);
    }

    public synchronized void removeEvents(Collection<Event> eventsToRemove) {
        List<Event> events;
        if (eventsToRemove != null && eventsToRemove.size() > 0 && (events = this.eventsList()).removeAll(eventsToRemove)) {
            this.preferences_.edit().putString(EVENTS_PREFERENCE, StatisticsStore.joinEvents(events, DELIMITER)).commit();
        }
    }

    static String joinEvents(Collection<Event> collection, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Event e : collection) {
            strings.add(e.toJSON().toString());
        }
        return StatisticsStore.join(strings, delimiter);
    }

    static String join(Collection<String> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String s : collection) {
            builder.append(s);
            if (++i >= collection.size()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public synchronized String getPreference(String key) {
        return this.preferences_.getString(key, null);
    }

    public synchronized void setPreference(String key, String value) {
        if (value == null) {
            this.preferences_.edit().remove(key).commit();
        } else {
            this.preferences_.edit().putString(key, value).commit();
        }
    }

    synchronized void clear() {
        SharedPreferences.Editor prefsEditor = this.preferences_.edit();
        prefsEditor.remove(EVENTS_PREFERENCE);
        prefsEditor.remove(CONNECTIONS_PREFERENCE);
        prefsEditor.commit();
    }
}

