/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.statistics;

import android.util.Log;
import io.rong.imlib.statistics.Statistics;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UserData {
    public static final String NAME_KEY = "name";
    public static final String USERNAME_KEY = "username";
    public static final String EMAIL_KEY = "email";
    public static final String ORG_KEY = "organization";
    public static final String PHONE_KEY = "phone";
    public static final String PICTURE_KEY = "picture";
    public static final String PICTURE_PATH_KEY = "picturePath";
    public static final String GENDER_KEY = "gender";
    public static final String BYEAR_KEY = "byear";
    public static final String CUSTOM_KEY = "custom";
    public static String name;
    public static String username;
    public static String email;
    public static String org;
    public static String phone;
    public static String picture;
    public static String picturePath;
    public static String gender;
    public static Map<String, String> custom;
    public static int byear;
    public static boolean isSynced;

    static void setData(Map<String, String> data) {
        File sourceFile;
        if (data.containsKey(NAME_KEY)) {
            name = data.get(NAME_KEY);
        }
        if (data.containsKey(USERNAME_KEY)) {
            username = data.get(USERNAME_KEY);
        }
        if (data.containsKey(EMAIL_KEY)) {
            email = data.get(EMAIL_KEY);
        }
        if (data.containsKey(ORG_KEY)) {
            org = data.get(ORG_KEY);
        }
        if (data.containsKey(PHONE_KEY)) {
            phone = data.get(PHONE_KEY);
        }
        if (data.containsKey(PICTURE_PATH_KEY)) {
            picturePath = data.get(PICTURE_PATH_KEY);
        }
        if (picturePath != null && !(sourceFile = new File(picturePath)).isFile()) {
            if (Statistics.sharedInstance().isLoggingEnabled()) {
                Log.w((String)"Statistics", (String)("Provided file " + picturePath + " can not be opened"));
            }
            picturePath = null;
        }
        if (data.containsKey(PICTURE_KEY)) {
            picture = data.get(PICTURE_KEY);
        }
        if (data.containsKey(GENDER_KEY)) {
            gender = data.get(GENDER_KEY);
        }
        if (data.containsKey(BYEAR_KEY)) {
            try {
                byear = Integer.parseInt(data.get(BYEAR_KEY));
            }
            catch (NumberFormatException e) {
                if (Statistics.sharedInstance().isLoggingEnabled()) {
                    Log.w((String)"Statistics", (String)"Incorrect byear number format");
                }
                byear = 0;
            }
        }
        isSynced = false;
    }

    static void setCustomData(Map<String, String> data) {
        custom = new HashMap<String, String>();
        custom.putAll(data);
        isSynced = false;
    }

    static String getDataForRequest() {
        if (!isSynced) {
            isSynced = true;
            JSONObject json = UserData.toJSON();
            if (json != null) {
                String result = json.toString();
                try {
                    result = URLEncoder.encode(result, "UTF-8");
                    if (result != null && !result.equals("")) {
                        result = "&user_details=" + result;
                        if (picturePath != null) {
                            result = result + "&picturePath=" + URLEncoder.encode(picturePath, "UTF-8");
                        }
                    } else {
                        result = "";
                        if (picturePath != null) {
                            result = result + "&user_details&picturePath=" + URLEncoder.encode(picturePath, "UTF-8");
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (result != null) {
                    return result;
                }
            }
        }
        return "";
    }

    static JSONObject toJSON() {
        JSONObject json;
        block29: {
            json = new JSONObject();
            try {
                if (name != null) {
                    if (name == "") {
                        json.put(NAME_KEY, JSONObject.NULL);
                    } else {
                        json.put(NAME_KEY, (Object)name);
                    }
                }
                if (username != null) {
                    if (username == "") {
                        json.put(USERNAME_KEY, JSONObject.NULL);
                    } else {
                        json.put(USERNAME_KEY, (Object)username);
                    }
                }
                if (email != null) {
                    if (email == "") {
                        json.put(EMAIL_KEY, JSONObject.NULL);
                    } else {
                        json.put(EMAIL_KEY, (Object)email);
                    }
                }
                if (org != null) {
                    if (org == "") {
                        json.put(ORG_KEY, JSONObject.NULL);
                    } else {
                        json.put(ORG_KEY, (Object)org);
                    }
                }
                if (phone != null) {
                    if (phone == "") {
                        json.put(PHONE_KEY, JSONObject.NULL);
                    } else {
                        json.put(PHONE_KEY, (Object)phone);
                    }
                }
                if (picture != null) {
                    if (picture == "") {
                        json.put(PICTURE_KEY, JSONObject.NULL);
                    } else {
                        json.put(PICTURE_KEY, (Object)picture);
                    }
                }
                if (gender != null) {
                    if (gender == "") {
                        json.put(GENDER_KEY, JSONObject.NULL);
                    } else {
                        json.put(GENDER_KEY, (Object)gender);
                    }
                }
                if (byear != 0) {
                    if (byear > 0) {
                        json.put(BYEAR_KEY, byear);
                    } else {
                        json.put(BYEAR_KEY, JSONObject.NULL);
                    }
                }
                if (custom != null) {
                    if (custom.isEmpty()) {
                        json.put(CUSTOM_KEY, JSONObject.NULL);
                    } else {
                        json.put(CUSTOM_KEY, (Object)new JSONObject(custom));
                    }
                }
            }
            catch (JSONException e) {
                if (!Statistics.sharedInstance().isLoggingEnabled()) break block29;
                Log.w((String)"Statistics", (String)"Got exception converting an UserData to JSON", (Throwable)e);
            }
        }
        return json;
    }

    static void fromJSON(JSONObject json) {
        block5: {
            if (json != null) {
                name = json.optString(NAME_KEY, null);
                username = json.optString(USERNAME_KEY, null);
                email = json.optString(EMAIL_KEY, null);
                org = json.optString(ORG_KEY, null);
                phone = json.optString(PHONE_KEY, null);
                picture = json.optString(PICTURE_KEY, null);
                gender = json.optString(GENDER_KEY, null);
                byear = json.optInt(BYEAR_KEY, 0);
                if (!json.isNull(CUSTOM_KEY)) {
                    try {
                        JSONObject customJson = json.getJSONObject(CUSTOM_KEY);
                        HashMap<String, String> custom = new HashMap<String, String>(customJson.length());
                        Iterator nameItr = customJson.keys();
                        while (nameItr.hasNext()) {
                            String key = (String)nameItr.next();
                            if (customJson.isNull(key)) continue;
                            custom.put(key, customJson.getString(key));
                        }
                    }
                    catch (JSONException e) {
                        if (!Statistics.sharedInstance().isLoggingEnabled()) break block5;
                        Log.w((String)"Statistics", (String)"Got exception converting an Custom Json to Custom User data", (Throwable)e);
                    }
                }
            }
        }
    }

    public static String getPicturePathFromQuery(URL url) {
        String query = url.getQuery();
        if (query == null) {
            return "";
        }
        String[] pairs = query.split("&");
        String ret = "";
        if (url.getQuery().contains(PICTURE_PATH_KEY)) {
            for (String pair : pairs) {
                int idx = pair.indexOf("=");
                if (!pair.substring(0, idx).equals(PICTURE_PATH_KEY)) continue;
                try {
                    ret = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    ret = "";
                }
                break;
            }
        }
        return ret;
    }

    static {
        byear = 0;
        isSynced = true;
    }
}

