/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.typingmessage;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.typingmessage.TypingStatus;
import io.rong.imlib.typingmessage.TypingStatusMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class TypingMessageManager {
    private static final String TAG = "TypingMessageManager";
    private static final String SEPARATOR = ";;;";
    private static int DISAPPEAR_INTERVAL = 6000;
    private HashMap<String, LinkedHashMap<String, TypingStatus>> mTypingMap = new HashMap();
    private HashMap<String, Long> mSendingConversation = new HashMap();
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private RongIMClient.TypingStatusListener sTypingStatusListener;
    private boolean isShowMessageTyping = false;

    private TypingMessageManager() {
    }

    public static TypingMessageManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public void init(Context context) {
        try {
            Resources resources = context.getResources();
            this.isShowMessageTyping = resources.getBoolean(resources.getIdentifier("rc_typing_status", "bool", context.getPackageName()));
        }
        catch (Resources.NotFoundException e) {
            RLog.e(TAG, "getTypingStatus rc_typing_status not configure in rc_configuration.xml");
            e.printStackTrace();
        }
    }

    public boolean isShowMessageTyping() {
        return this.isShowMessageTyping;
    }

    public Collection<TypingStatus> getTypingUserListFromConversation(Conversation.ConversationType conversationType, String targetId) {
        String key = conversationType.getName() + SEPARATOR + targetId;
        return this.mTypingMap.get(key).values();
    }

    public void sendTypingMessage(Conversation.ConversationType conversationType, String targetId, String typingContentType) {
        final String key = conversationType.getName() + SEPARATOR + targetId;
        if (!conversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
            return;
        }
        if (!this.mSendingConversation.containsKey(key)) {
            TypingStatusMessage typingStatusMessage = new TypingStatusMessage(typingContentType, null);
            this.mSendingConversation.put(key, 0L);
            RongIMClient.getInstance().sendMessage(conversationType, targetId, typingStatusMessage, null, null, null, new RongIMClient.ResultCallback<Message>(){

                @Override
                public void onSuccess(Message message) {
                    TypingMessageManager.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            TypingMessageManager.this.mSendingConversation.remove(key);
                        }
                    }, (long)DISAPPEAR_INTERVAL);
                }

                @Override
                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        } else {
            RLog.d(TAG, "sendTypingStatus typing message in this conversation is sending");
        }
    }

    public void setTypingEnd(Conversation.ConversationType conversationType, String targetId) {
        String key = conversationType.getName() + SEPARATOR + targetId;
        if (!conversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
            return;
        }
        if (this.mSendingConversation.containsKey(key)) {
            this.mSendingConversation.remove(key);
        }
    }

    public void setTypingMessageStatusListener(RongIMClient.TypingStatusListener listener) {
        this.sTypingStatusListener = listener;
    }

    public boolean onReceiveMessage(Message message) {
        if (message.getContent() instanceof TypingStatusMessage && this.isShowMessageTyping) {
            TypingMessageManager.getInstance().onReceiveTypingMessage(message);
            return true;
        }
        TypingMessageManager.getInstance().onReceiveOtherMessage(message);
        return false;
    }

    private void onReceiveTypingMessage(Message message) {
        if (message.getSenderUserId().equals(RongIMClient.getInstance().getCurrentUserId())) {
            return;
        }
        final Conversation.ConversationType conversationType = message.getConversationType();
        final String targetId = message.getTargetId();
        TypingStatusMessage typingStatusMessage = (TypingStatusMessage)message.getContent();
        String typingContentType = typingStatusMessage.getTypingContentType();
        if (typingContentType == null) {
            return;
        }
        final String userId = message.getSenderUserId();
        final String key = conversationType.getName() + SEPARATOR + targetId;
        if (this.mTypingMap.containsKey(key)) {
            LinkedHashMap<String, TypingStatus> map = this.mTypingMap.get(key);
            if (map.get(userId) == null) {
                TypingStatus typingStatus = new TypingStatus(userId, typingContentType, message.getSentTime());
                map.put(userId, typingStatus);
                if (this.sTypingStatusListener != null) {
                    this.sTypingStatusListener.onTypingStatusChanged(conversationType, targetId, map.values());
                }
            }
        } else {
            LinkedHashMap<String, TypingStatus> map = new LinkedHashMap<String, TypingStatus>();
            TypingStatus typingStatus = new TypingStatus(userId, typingContentType, message.getSentTime());
            map.put(userId, typingStatus);
            if (this.sTypingStatusListener != null) {
                this.sTypingStatusListener.onTypingStatusChanged(conversationType, targetId, map.values());
            }
            this.mTypingMap.put(key, map);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LinkedHashMap map;
                    if (TypingMessageManager.this.mTypingMap.containsKey(key) && (map = (LinkedHashMap)TypingMessageManager.this.mTypingMap.get(key)).get(userId) != null) {
                        map.remove(userId);
                        if (TypingMessageManager.this.sTypingStatusListener != null) {
                            TypingMessageManager.this.sTypingStatusListener.onTypingStatusChanged(conversationType, targetId, map.values());
                        }
                        if (map.isEmpty()) {
                            TypingMessageManager.this.mTypingMap.remove(key);
                        }
                    }
                }
            }, (long)DISAPPEAR_INTERVAL);
        }
    }

    private void onReceiveOtherMessage(Message message) {
        MessageContent content = message.getContent();
        MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
        if (tag != null && (tag.flag() & 1) == 1) {
            LinkedHashMap<String, TypingStatus> map;
            Conversation.ConversationType conversationType = message.getConversationType();
            String targetId = message.getTargetId();
            String userId = message.getSenderUserId();
            String key = conversationType.getName() + SEPARATOR + targetId;
            if (this.mTypingMap.containsKey(key) && (map = this.mTypingMap.get(key)).get(userId) != null) {
                map.remove(userId);
                if (this.sTypingStatusListener != null) {
                    this.sTypingStatusListener.onTypingStatusChanged(conversationType, targetId, map.values());
                }
                if (map.isEmpty()) {
                    this.mTypingMap.remove(key);
                }
            }
        }
    }

    private static class SingletonHolder {
        static TypingMessageManager sInstance = new TypingMessageManager();

        private SingletonHolder() {
        }
    }
}

