/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:ReadNtf", flag=0)
public class ReadReceiptMessage
extends MessageContent {
    private static final String TAG = "ReadReceiptMessage";
    private long lastMessageSendTime;
    private String messageUId;
    private ReadReceiptType type;
    public static final Parcelable.Creator<ReadReceiptMessage> CREATOR = new Parcelable.Creator<ReadReceiptMessage>(){

        public ReadReceiptMessage createFromParcel(Parcel source) {
            return new ReadReceiptMessage(source);
        }

        public ReadReceiptMessage[] newArray(int size) {
            return new ReadReceiptMessage[size];
        }
    };

    public long getLastMessageSendTime() {
        return this.lastMessageSendTime;
    }

    public void setLastMessageSendTime(long lastMessageSendTime) {
        this.lastMessageSendTime = lastMessageSendTime;
    }

    public String getMessageUId() {
        return this.messageUId;
    }

    public void setMessageUId(String messageUId) {
        this.messageUId = messageUId;
    }

    public ReadReceiptType getType() {
        return this.type;
    }

    public void setType(ReadReceiptType type) {
        this.type = type;
    }

    public ReadReceiptMessage(long sendTime) {
        this.setLastMessageSendTime(sendTime);
        this.setType(ReadReceiptType.SEND_TIME);
    }

    public ReadReceiptMessage(String uId) {
        this.setMessageUId(uId);
        this.setType(ReadReceiptType.UID);
    }

    public ReadReceiptMessage(long sendTime, String uId, ReadReceiptType type) {
        this.setLastMessageSendTime(sendTime);
        this.setMessageUId(uId);
        this.setType(type);
    }

    public ReadReceiptMessage(Parcel in) {
        this.setLastMessageSendTime(ParcelUtils.readLongFromParcel(in));
        this.setMessageUId(ParcelUtils.readFromParcel(in));
        this.setType(ReadReceiptType.setValue(ParcelUtils.readIntFromParcel(in)));
    }

    public ReadReceiptMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, e.getMessage());
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("lastMessageSendTime")) {
                this.setLastMessageSendTime(jsonObj.getLong("lastMessageSendTime"));
            }
            if (jsonObj.has("messageUId")) {
                this.setMessageUId(jsonObj.getString("messageUId"));
            }
            if (jsonObj.has("type")) {
                this.setType(ReadReceiptType.setValue(jsonObj.getInt("type")));
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("lastMessageSendTime", this.getLastMessageSendTime());
            if (!TextUtils.isEmpty((CharSequence)this.getMessageUId())) {
                jsonObj.put("messageUId", (Object)this.getMessageUId());
            }
            jsonObj.put("type", this.getType().getValue());
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException ", e);
            return null;
        }
    }

    private ReadReceiptMessage() {
    }

    public static ReadReceiptMessage obtain(long sendTime) {
        ReadReceiptMessage obj = new ReadReceiptMessage();
        obj.setLastMessageSendTime(sendTime);
        obj.setType(ReadReceiptType.SEND_TIME);
        return obj;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getLastMessageSendTime());
        ParcelUtils.writeToParcel(dest, this.getMessageUId());
        ParcelUtils.writeToParcel(dest, this.getType().getValue());
    }

    public static enum ReadReceiptType {
        SEND_TIME(1),
        UID(2);

        private int value = 0;

        private ReadReceiptType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ReadReceiptType setValue(int code) {
            for (ReadReceiptType c : ReadReceiptType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return SEND_TIME;
        }
    }
}

