/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:RRReqMsg", flag=0)
public class ReadReceiptRequestMessage
extends MessageContent {
    private static final String TAG = "ReadReceiptRequestMessage";
    private String mMessageUId;
    public static final Parcelable.Creator<ReadReceiptRequestMessage> CREATOR = new Parcelable.Creator<ReadReceiptRequestMessage>(){

        public ReadReceiptRequestMessage createFromParcel(Parcel source) {
            return new ReadReceiptRequestMessage(source);
        }

        public ReadReceiptRequestMessage[] newArray(int size) {
            return new ReadReceiptRequestMessage[size];
        }
    };

    public String getMessageUId() {
        return this.mMessageUId;
    }

    public ReadReceiptRequestMessage(String uId) {
        this.mMessageUId = uId;
    }

    public ReadReceiptRequestMessage(Parcel in) {
        this.mMessageUId = ParcelUtils.readFromParcel(in);
    }

    public ReadReceiptRequestMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, e.getMessage());
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("messageUId")) {
                this.mMessageUId = jsonObj.getString("messageUId");
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mMessageUId)) {
                jsonObj.put("messageUId", (Object)this.mMessageUId);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "UnsupportedEncodingException ", e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.mMessageUId);
    }
}

