/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.DestructionTag;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.UserInfo;
import io.rong.message.MediaMessageContent;
import io.rong.message.SightMessageHandler;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:SightMsg", flag=3, messageHandler=SightMessageHandler.class)
@DestructionTag(destructionFlag=0)
public class SightMessage
extends MediaMessageContent {
    private static final String TAG = "SightMessage";
    private Uri mThumbUri;
    private String mBase64;
    private int mDuration;
    private long mSize;
    public static final Parcelable.Creator<SightMessage> CREATOR = new Parcelable.Creator<SightMessage>(){

        public SightMessage createFromParcel(Parcel source) {
            return new SightMessage(source);
        }

        public SightMessage[] newArray(int size) {
            return new SightMessage[size];
        }
    };

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mBase64)) {
                jsonObj.put("content", (Object)this.mBase64);
            } else {
                Log.d((String)TAG, (String)"base64 is null");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getName())) {
                jsonObj.put("name", (Object)this.getName());
            }
            jsonObj.put("size", this.mSize);
            if (this.getLocalPath() != null) {
                jsonObj.put("localPath", (Object)this.getLocalPath().toString());
            }
            if (this.getMediaUrl() != null) {
                jsonObj.put("sightUrl", (Object)this.getMediaUrl().toString());
            }
            jsonObj.put("duration", this.getDuration());
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
            jsonObj.put("isBurnAfterRead", this.isDestruct());
            jsonObj.put("burnDuration", this.getDestructTime());
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "encode", e);
            return null;
        }
    }

    public SightMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("name")) {
                this.setName(jsonObj.optString("name"));
            }
            if (jsonObj.has("size")) {
                this.setSize(jsonObj.getLong("size"));
            }
            if (jsonObj.has("content")) {
                this.setBase64(jsonObj.optString("content"));
            }
            if (jsonObj.has("localPath")) {
                this.setLocalPath(Uri.parse((String)jsonObj.optString("localPath")));
            }
            if (jsonObj.has("sightUrl")) {
                this.setMediaUrl(Uri.parse((String)jsonObj.optString("sightUrl")));
            }
            if (jsonObj.has("duration")) {
                this.setDuration(jsonObj.optInt("duration"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
            if (jsonObj.has("isBurnAfterRead")) {
                this.setDestruct(jsonObj.getBoolean("isBurnAfterRead"));
            }
            if (jsonObj.has("burnDuration")) {
                this.setDestructTime(jsonObj.getLong("burnDuration"));
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    public SightMessage() {
    }

    private SightMessage(Uri thumbUri, Uri localUri, int duration) {
        this.mThumbUri = thumbUri;
        this.setLocalPath(localUri);
        this.setDuration(duration);
    }

    private SightMessage(File file, Uri localUri, int duration) {
        this.setLocalPath(localUri);
        this.setDuration(duration);
        this.setName(file.getName());
        this.setSize(file.length());
    }

    public static SightMessage obtain(Uri thumbUri, Uri localUri, int duration) {
        return new SightMessage(thumbUri, localUri, duration);
    }

    public static SightMessage obtain(Uri localUri, int duration) {
        if (localUri == null || !localUri.toString().startsWith("file")) {
            return null;
        }
        File file = new File(localUri.toString().substring(7));
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return new SightMessage(file, localUri, duration);
    }

    public Uri getThumbUri() {
        return this.mThumbUri;
    }

    public void setThumbUri(Uri thumbUri) {
        this.mThumbUri = thumbUri;
    }

    public void setBase64(String base64) {
        this.mBase64 = base64;
    }

    public String getBase64() {
        return this.mBase64;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long size) {
        this.mSize = size;
    }

    public int describeContents() {
        return 0;
    }

    public SightMessage(Parcel in) {
        this.mThumbUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.setLocalPath(ParcelUtils.readFromParcel(in, Uri.class));
        this.setMediaUrl(ParcelUtils.readFromParcel(in, Uri.class));
        this.setDuration(ParcelUtils.readIntFromParcel(in));
        this.setName(ParcelUtils.readFromParcel(in));
        this.setSize(ParcelUtils.readLongFromParcel(in));
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.setUserInfo(ParcelUtils.readFromParcel(in, UserInfo.class));
        this.setDestruct(ParcelUtils.readIntFromParcel(in) == 1);
        this.setDestructTime(ParcelUtils.readLongFromParcel(in));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.mThumbUri);
        ParcelUtils.writeToParcel(dest, this.getLocalPath());
        ParcelUtils.writeToParcel(dest, this.getMediaUrl());
        ParcelUtils.writeToParcel(dest, this.getDuration());
        ParcelUtils.writeToParcel(dest, this.getName());
        ParcelUtils.writeToParcel(dest, this.getSize());
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.getUserInfo());
        ParcelUtils.writeToParcel(dest, this.isDestruct() ? 1 : 0);
        ParcelUtils.writeToParcel(dest, this.getDestructTime());
    }
}

