/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.model.Message;
import io.rong.message.MessageHandler;
import io.rong.message.SightMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class SightMessageHandler
extends MessageHandler<SightMessage> {
    private static final String TAG = "Sight-SightMessageHandler";
    private static int THUMB_COMPRESSED_QUALITY = 30;
    private static final String VIDEO_THUMBNAIL_PATH = "/video/thumbnail/";

    public SightMessageHandler(Context context) {
        super(context);
    }

    @Override
    public void decodeMessage(Message message, SightMessage model) {
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        String name = message.getMessageId() + ".jpg";
        if (message.getMessageId() == 0) {
            name = message.getSentTime() + ".jpg";
        }
        String thumb = uri.toString() + VIDEO_THUMBNAIL_PATH;
        File thumbFile = new File(thumb + name);
        if (!TextUtils.isEmpty((CharSequence)model.getBase64()) && !thumbFile.exists()) {
            byte[] data = null;
            try {
                data = Base64.decode((String)model.getBase64(), (int)2);
            }
            catch (IllegalArgumentException e) {
                RLog.e(TAG, "decodeMessage afterDecodeMessage Not Base64 Content!", e);
            }
            if (!SightMessageHandler.isImageFile(data)) {
                RLog.e(TAG, "afterDecodeMessage Not Image File!");
                return;
            }
            FileUtils.byte2File(data, thumb, name);
        }
        model.setThumbUri(Uri.parse((String)("file://" + thumb + name)));
        model.setBase64(null);
    }

    @Override
    public void encodeMessage(Message message) {
        byte[] data;
        SightMessage model = (SightMessage)message.getContent();
        Uri uri = NativeClient.getInstance().obtainMediaFileSavedUri();
        String name = message.getMessageId() + ".jpg";
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        if (model.getThumbUri() != null && model.getThumbUri().getScheme() != null && model.getThumbUri().getScheme().equals("file")) {
            File file = new File(uri.toString() + VIDEO_THUMBNAIL_PATH + name);
            if (file.exists()) {
                model.setThumbUri(Uri.parse((String)("file://" + uri.toString() + VIDEO_THUMBNAIL_PATH + name)));
                byte[] data2 = FileUtils.file2byte(file);
                if (data2 != null) {
                    model.setBase64(Base64.encodeToString((byte[])data2, (int)2));
                }
                return;
            }
            String thumbPath = model.getThumbUri().toString().substring(5);
            File src = new File(thumbPath);
            data = FileUtils.file2byte(src);
            if (data != null) {
                model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                String path = uri.toString() + VIDEO_THUMBNAIL_PATH;
                if (FileUtils.copyFile(src, path, name) != null) {
                    model.setThumbUri(Uri.parse((String)("file://" + path + name)));
                    return;
                }
            }
        }
        try {
            String videoPath = model.getLocalPath().toString().substring(5);
            RLog.d(TAG, "beforeEncodeMessage Thumbnail not save yet! " + videoPath);
            Bitmap bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)1);
            if (bitmap != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, THUMB_COMPRESSED_QUALITY, (OutputStream)outputStream);
                data = outputStream.toByteArray();
                model.setBase64(Base64.encodeToString((byte[])data, (int)2));
                outputStream.close();
                FileUtils.byte2File(data, uri.toString() + VIDEO_THUMBNAIL_PATH, name);
                model.setThumbUri(Uri.parse((String)("file://" + uri.toString() + VIDEO_THUMBNAIL_PATH + name)));
                if (!bitmap.isRecycled()) {
                    bitmap.recycle();
                }
            }
        }
        catch (IllegalArgumentException e) {
            RLog.e(TAG, "encodeMessage beforeEncodeMessage Not Base64 Content!", e);
        }
        catch (IOException e) {
            RLog.e(TAG, "encodeMessage beforeEncodeMessage IOException", e);
        }
    }

    private static boolean isImageFile(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        return options.outWidth != -1;
    }
}

