/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message.utils;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import io.rong.common.RLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtil {
    private static final String TAG = "Util";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBase64FromBitmap(Bitmap bitmap) {
        String base64Str = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 40, (OutputStream)baos);
                byte[] bitmapBytes = baos.toByteArray();
                base64Str = Base64.encodeToString((byte[])bitmapBytes, (int)2);
                Log.d((String)"base64Str", (String)("" + base64Str.length()));
                baos.flush();
                baos.close();
            }
        }
        catch (IOException e) {
            RLog.e(TAG, "IOException ", e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "IOException ", e);
            }
        }
        return base64Str;
    }

    public static Bitmap getBitmapFromBase64(String base64Str) {
        if (TextUtils.isEmpty((CharSequence)base64Str)) {
            return null;
        }
        byte[] bytes = Base64.decode((String)base64Str, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap getResizedBitmap(Context context, Uri uri, int widthLimit, int heightLimit) throws IOException {
        Bitmap bitmap;
        String path = null;
        Bitmap result = null;
        if (uri.getScheme().equals("file")) {
            path = uri.toString().substring(5);
        } else if (uri.getScheme().equals("content")) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            cursor.moveToFirst();
            path = cursor.getString(0);
            cursor.close();
        } else {
            return null;
        }
        ExifInterface exifInterface = new ExifInterface(path);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int orientation = exifInterface.getAttributeInt("Orientation", 0);
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = widthLimit;
            widthLimit = heightLimit;
            heightLimit = tmp;
        }
        int width = options.outWidth;
        int height = options.outHeight;
        int sampleW = 1;
        int sampleH = 1;
        while (width / 2 > widthLimit) {
            width /= 2;
            sampleW <<= 1;
        }
        while (height / 2 > heightLimit) {
            height /= 2;
            sampleH <<= 1;
        }
        int sampleSize = 1;
        options = new BitmapFactory.Options();
        sampleSize = widthLimit == Integer.MAX_VALUE || heightLimit == Integer.MAX_VALUE ? Math.max(sampleW, sampleH) : Math.max(sampleW, sampleH);
        options.inSampleSize = sampleSize;
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            RLog.e(TAG, "OutOfMemoryError ", e);
            options.inSampleSize <<= 1;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (orientation) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        float xS = (float)widthLimit / (float)bitmap.getWidth();
        float yS = (float)heightLimit / (float)bitmap.getHeight();
        matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            RLog.e(TAG, "OutOfMemoryError ", e);
            Log.d((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + xS + " " + yS));
            return null;
        }
        return result;
    }

    public static Bitmap interceptBitmap(String filePath, int w, int h) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath);
        int widthOrg = bitmap.getWidth();
        int heightOrg = bitmap.getHeight();
        int xTopLeft = (widthOrg - w) / 2;
        int yTopLeft = (heightOrg - h) / 2;
        if (xTopLeft <= 0 || yTopLeft <= 0) {
            RLog.w(TAG, "ignore intercept [" + widthOrg + ", " + heightOrg + ":" + w + ", " + h + "]");
            return bitmap;
        }
        try {
            Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)xTopLeft, (int)yTopLeft, (int)w, (int)h);
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return result;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    public static Bitmap getThumbBitmap(Context context, Uri uri, int sizeLimit, int minSize) throws IOException {
        Bitmap result;
        Bitmap bitmap;
        String path;
        if (uri.getScheme().equals("file")) {
            path = uri.toString().substring(5);
        } else if (uri.getScheme().equals("content")) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            cursor.moveToFirst();
            path = cursor.getString(0);
            cursor.close();
        } else {
            return null;
        }
        ExifInterface exifInterface = new ExifInterface(path);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int orientation = exifInterface.getAttributeInt("Orientation", 0);
        int width = options.outWidth;
        int height = options.outHeight;
        int longSide = width > height ? width : height;
        int shortSide = width > height ? height : width;
        float scale = (float)longSide / (float)shortSide;
        int sampleW = 1;
        int sampleH = 1;
        int sampleSize = 1;
        if (scale > (float)sizeLimit / (float)minSize) {
            while (shortSide / 2 > minSize) {
                shortSide /= 2;
                sampleSize <<= 1;
            }
            options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
        } else {
            while (width / 2 > sizeLimit) {
                width /= 2;
                sampleW <<= 1;
            }
            while (height / 2 > sizeLimit) {
                height /= 2;
                sampleH <<= 1;
            }
            options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize = Math.max(sampleW, sampleH);
        }
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            RLog.e(TAG, "OutOfMemoryError ", e);
            options.inSampleSize <<= 1;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (orientation) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        float sS = 0.0f;
        float xS = 0.0f;
        float yS = 0.0f;
        if (scale > (float)sizeLimit / (float)minSize) {
            shortSide = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getHeight() : bitmap.getWidth();
            sS = (float)minSize / (float)shortSide;
            matrix.postScale(sS, sS);
        } else {
            xS = (float)sizeLimit / (float)bitmap.getWidth();
            yS = (float)sizeLimit / (float)bitmap.getHeight();
            matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        }
        int x = 0;
        int y = 0;
        try {
            if (scale > (float)sizeLimit / (float)minSize) {
                if (bitmap.getWidth() > bitmap.getHeight()) {
                    h = bitmap.getHeight();
                    w = h * sizeLimit / minSize;
                    x = (bitmap.getWidth() - w) / 2;
                    y = 0;
                } else {
                    w = bitmap.getWidth();
                    h = w * sizeLimit / minSize;
                    x = 0;
                    y = (bitmap.getHeight() - h) / 2;
                }
            } else {
                w = bitmap.getWidth();
                h = bitmap.getHeight();
            }
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            RLog.e(TAG, "OutOfMemoryError ", e);
            Log.d((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + sS + " " + xS + " " + yS));
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return null;
        }
        if (!bitmap.isRecycled() && !bitmap.equals(result)) {
            bitmap.recycle();
        }
        return result;
    }

    public static Bitmap getBlurryBitmap(Context context, Bitmap bitmap, float radius, float scale) {
        RenderScript renderScript = RenderScript.create((Context)context);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)(scale * (float)bitmap.getWidth())), (int)((int)(scale * (float)bitmap.getHeight())), (boolean)false);
        Allocation input = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap);
        Allocation output = Allocation.createTyped((RenderScript)renderScript, (Type)input.getType());
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
        scriptIntrinsicBlur.setInput(input);
        scriptIntrinsicBlur.setRadius(radius);
        scriptIntrinsicBlur.forEach(output);
        output.copyTo(bitmap);
        renderScript.destroy();
        return bitmap;
    }
}

