/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.PushType;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.common.RLog;
import io.rong.push.core.PushUtils;
import io.rong.push.notification.PushNotificationMessage;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.IPushConfigObserver;
import io.rong.push.pushconfig.PushConfig;
import io.rong.push.pushconfig.PushConfigManager;
import io.rong.push.pushconfig.PushFactory;
import io.rong.push.rongpush.PushReceiver;
import java.util.concurrent.ConcurrentHashMap;

public class PushManager {
    private static final String TAG = PushManager.class.getSimpleName();
    private final int MAX_RETRY_COUNT = 5;
    private PushConfigManager pushConfigManager;
    private PushConfig pushConfig;
    private ConcurrentHashMap<String, IPush> registeredPushMap;
    private String token;
    private int retryTimes = 0;

    private PushManager() {
    }

    public static PushManager getInstance() {
        return SingletonHolder.sIns;
    }

    public void init(Context context, PushConfig pushConfig) {
        this.pushConfig = pushConfig;
        this.registeredPushMap = new ConcurrentHashMap();
        this.retryTimes = 0;
        PushType preferPushType = PushUtils.getPreferPushType(context, pushConfig);
        PushType cachedPushType = PushCacheHelper.getInstance().getConfigPushType(context);
        RLog.d(TAG, "preferPushType:" + (Object)((Object)preferPushType) + "; cachedPushType:" + (Object)((Object)cachedPushType));
        boolean isConfigChanged = !pushConfig.getEncodedEnabledPushTypes().equals(PushCacheHelper.getInstance().getCachedEnablePushTypes(context)) || !pushConfig.getPushDomain().equals(PushCacheHelper.getInstance().getCachedPushDomain(context));
        RLog.d(TAG, "isConfigChanged:" + isConfigChanged + "; cachedTypes:" + PushCacheHelper.getInstance().getCachedEnablePushTypes(context));
        if ((preferPushType.equals((Object)PushType.RONG) || PushCacheHelper.getInstance().isConfigDone(context)) && !isConfigChanged) {
            this.register(context, cachedPushType);
        } else {
            this.initPushConfig(context);
            this.pushConfigManager.startConfig(context);
        }
        PushCacheHelper.getInstance().savePushDomain(context, pushConfig.getPushDomain());
        PushCacheHelper.getInstance().saveEnablePushTypes(context, pushConfig.getEncodedEnabledPushTypes());
    }

    private void initPushConfig(final Context context) {
        if (this.pushConfigManager != null) {
            RLog.e(TAG, "pushConfigManager already init. Return directly.");
            return;
        }
        this.pushConfigManager = new PushConfigManager();
        this.pushConfigManager.init(context, this.pushConfig, new IPushConfigObserver(){

            @Override
            public void onSuccess(PushType pushType) {
                if (PushManager.this.pushConfigManager != null) {
                    RLog.d(TAG, "Success to config push: " + pushType.getName());
                    PushManager.this.pushConfigManager.finishConfig(context, pushType.getName());
                    PushManager.this.token = null;
                    if (pushType.equals((Object)PushType.RONG)) {
                        PushManager.this.register(context, PushType.RONG);
                    }
                }
            }

            @Override
            public void onGetPushType(PushType pushType) {
                RLog.d(TAG, "Success to get pushType. Go to register : " + pushType.getName());
                PushManager.this.register(context, pushType);
            }

            @Override
            public void onError(PushErrorCode code) {
                RLog.e(TAG, "error when config push. Will reConfig when network changed!");
            }

            @Override
            public void onFail(PushType pushType, PushErrorCode code) {
                RLog.e(TAG, "Failed to config push. type:" + (Object)((Object)pushType) + "; errorCode:" + (Object)((Object)code));
                if (code.equals((Object)PushErrorCode.NOT_REGISTER_IN_ADMIN)) {
                    RLog.e(TAG, "Please fill in the parameters of " + pushType.getName() + " in your RongCloud Admin.");
                }
                PushManager.this.onErrorResponse(context, pushType, "queryType", code.getCode());
            }
        });
    }

    public void register(Context context, PushType pushType) {
        IPush iPush;
        RLog.d(TAG, "register. type:" + (Object)((Object)pushType));
        if (!pushType.equals((Object)PushType.RONG)) {
            try {
                RLog.d(TAG, "stop PushReceiver.");
                ComponentName receiver = new ComponentName(context, PushReceiver.class);
                context.getPackageManager().setComponentEnabledSetting(receiver, 2, 1);
            }
            catch (Exception receiver) {
                // empty catch block
            }
        }
        if ((iPush = this.registeredPushMap.get(pushType.getName())) == null) {
            iPush = PushFactory.getPushCenterByType(pushType);
        }
        if (iPush != null) {
            iPush.register(context, this.pushConfig);
            this.registeredPushMap.put(pushType.getName(), iPush);
        }
    }

    public void onNetworkReconfigEvent(Context context) {
        if (PushCacheHelper.getInstance().isConfigDone(context)) {
            RLog.d(TAG, "Config finished. Ignore this event. ");
            return;
        }
        if (this.pushConfigManager != null) {
            if (!TextUtils.isEmpty((CharSequence)this.token)) {
                this.pushConfigManager.setToken(context, this.pushConfig, this.token);
            } else {
                this.pushConfigManager.reConfig(context);
            }
        } else {
            RLog.d(TAG, "Ignore this reconfig event.");
        }
    }

    public void onReceiveToken(Context context, PushType pushType, String token) {
        RLog.d(TAG, "onReceiveToken. token:" + token);
        String cachedToken = PushCacheHelper.getInstance().getCachedTokenInfo(context);
        String currentToken = pushType.getName() + "|" + token;
        if (!cachedToken.equals(currentToken)) {
            if (this.pushConfigManager == null) {
                this.initPushConfig(context);
            }
            this.pushConfigManager.setToken(context, this.pushConfig, currentToken);
            token = currentToken;
        } else {
            RLog.d(TAG, "token is same with cached, do nothing!");
        }
    }

    public void onTokenRefresh(Context context, PushType pushType) {
        PushType cachedPushType = PushCacheHelper.getInstance().getConfigPushType(context);
        if (cachedPushType.equals((Object)pushType)) {
            this.register(context, pushType);
        }
    }

    public void onErrorResponse(Context context, PushType pushType, String action, long resultCode) {
        RLog.d(TAG, "onErrorResponse. pushType:" + (Object)((Object)pushType) + "; errorCode:" + resultCode);
        if (resultCode == (long)PushErrorCode.NOT_SUPPORT_BY_OFFICIAL_PUSH.getCode()) {
            this.register(context, PushType.RONG);
            if (this.pushConfigManager != null) {
                this.pushConfigManager.finishConfig(context, PushType.RONG.getName());
            }
        } else {
            Intent intent = new Intent();
            intent.setAction("io.rong.push.intent.THIRD_PARTY_PUSH_STATE");
            intent.putExtra("pushType", pushType.getName());
            intent.putExtra("action", action);
            intent.putExtra("resultCode", resultCode);
            intent.setPackage(context.getPackageName());
            context.sendBroadcast(intent);
        }
    }

    public void onNotificationMessageArrived(Context context, PushType pushType, PushNotificationMessage pushNotificationMessage) {
        RLog.d(TAG, "onNotificationMessageArrived is called. " + pushNotificationMessage.toString());
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_ARRIVED");
        intent.putExtra("pushType", pushType.getName());
        intent.putExtra("message", (Parcelable)pushNotificationMessage);
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }

    public void onNotificationMessageClicked(Context context, PushType pushType, PushNotificationMessage pushNotificationMessage) {
        RLog.d(TAG, "onNotificationMessageClicked is called. " + pushNotificationMessage.toString());
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_CLICKED");
        intent.putExtra("pushType", pushType.getName());
        intent.putExtra("message", (Parcelable)pushNotificationMessage);
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }

    public void onPushRawData(Context context, PushType pushType, String data) {
        PushNotificationMessage notificationMessage = PushUtils.transformToPushMessage(data);
        if (notificationMessage == null) {
            RLog.e(TAG, "notification message is null. Ignore this event.");
            return;
        }
        Intent intent = new Intent();
        intent.setAction("io.rong.push.intent.MESSAGE_ARRIVED");
        intent.putExtra("pushType", pushType.getName());
        intent.putExtra("message", (Parcelable)notificationMessage);
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }

    private static class SingletonHolder {
        private static PushManager sIns = new PushManager();

        private SingletonHolder() {
        }
    }
}

