/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RLog {
    static final boolean DEBUG = true;
    private static String RongLog = "RongLog-Push";
    private static Boolean IS_WRITE_TO_FILE = true;
    private static String LOG_PATH = "/sdcard/";
    private static int LOG_FILE_SAVE_DAYS = 1;
    private static String FILE_NAME = "PushLog.txt";
    private static SimpleDateFormat logFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static void i(String tag, String msg) {
        RLog.log(tag, msg, 'i');
    }

    public static void v(String tag, String msg) {
        RLog.log(tag, msg, 'v');
    }

    public static void d(String tag, String msg) {
        RLog.log(tag, msg, 'd');
    }

    public static void e(String tag, String msg) {
        RLog.log(tag, msg, 'e');
    }

    private static void log(String tag, String msg, char level) {
        tag = RongLog + "[" + tag + "]";
        if ('e' == level) {
            Log.e((String)tag, (String)msg);
        } else if ('w' == level) {
            Log.w((String)tag, (String)msg);
        } else if ('d' == level) {
            Log.d((String)tag, (String)msg);
        } else if ('i' == level) {
            Log.i((String)tag, (String)msg);
        } else {
            Log.v((String)tag, (String)msg);
        }
    }

    private static void writeLogtoFile(String mylogtype, String tag, String text) {
        Date nowtime = new Date();
        String fileDate = fileNameFormat.format(nowtime);
        String needWriteMessage = logFormat.format(nowtime) + "  " + mylogtype + "  " + Process.myPid() + "    " + tag + "    " + text;
        File file = new File(LOG_PATH, fileDate + FILE_NAME);
        RLog.delFile();
        try {
            FileWriter filerWriter = new FileWriter(file, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(needWriteMessage);
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delFile() {
        String needDelFiel = fileNameFormat.format(RLog.getDateBefore());
        File file = new File(LOG_PATH, needDelFiel + FILE_NAME);
        if (file.exists()) {
            file.delete();
        }
    }

    private static Date getDateBefore() {
        Date nowtime = new Date();
        Calendar now = Calendar.getInstance();
        now.setTime(nowtime);
        now.set(5, now.get(5) - LOG_FILE_SAVE_DAYS);
        return now.getTime();
    }

    public static void sendLog(Context context, List<String> emails) {
        Uri uri = null;
        try {
            Date nowtime = new Date();
            String fileDate = fileNameFormat.format(nowtime);
            File file = new File(LOG_PATH, fileDate + FILE_NAME);
            uri = Uri.fromFile((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (uri != null) {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("message/rfc822");
            intent.putExtra("android.intent.extra.EMAIL", (Serializable)emails.toArray());
            intent.putExtra("android.intent.extra.SUBJECT", "RongCloud log");
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            context.startActivity(intent);
        }
    }
}

