/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.hms;

import android.content.Context;
import android.os.Bundle;
import com.huawei.hms.support.api.push.PushReceiver;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;

public class HMSReceiver
extends PushReceiver {
    private final String TAG = "HMSReceiver";

    public void onToken(Context context, String token, Bundle bundle) {
        PushManager.getInstance().onReceiveToken(context, PushType.HUAWEI, token);
    }

    public boolean onPushMsg(Context context, byte[] msg, Bundle bundle) {
        RLog.d("HMSReceiver", "onPushMsg");
        try {
            String content = new String(msg, "UTF-8");
            PushManager.getInstance().onPushRawData(context, PushType.HUAWEI, content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void onPushState(Context context, boolean pushState) {
        RLog.e("HMSReceiver", "The current push status\uff1a " + (pushState ? "Connected" : "Disconnected"));
    }
}

