/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.hms.common;

import android.util.Log;

public final class HMSAgentLog {
    private static final int START_STACK_INDEX = 4;
    private static final int PRINT_STACK_COUTN = 2;
    private static IHMSAgentLogCallback logCallback = null;

    public static void setHMSAgentLogCallback(IHMSAgentLogCallback callback) {
        logCallback = callback;
    }

    public static void d(String log) {
        StringBuilder sb = new StringBuilder();
        HMSAgentLog.appendStack(sb);
        sb.append(log);
        if (logCallback != null) {
            logCallback.logD("HMSAgent", sb.toString());
        } else {
            Log.d((String)"HMSAgent", (String)sb.toString());
        }
    }

    public static void v(String log) {
        StringBuilder sb = new StringBuilder();
        HMSAgentLog.appendStack(sb);
        sb.append(log);
        if (logCallback != null) {
            logCallback.logV("HMSAgent", sb.toString());
        } else {
            Log.v((String)"HMSAgent", (String)sb.toString());
        }
    }

    public static void i(String log) {
        StringBuilder sb = new StringBuilder();
        HMSAgentLog.appendStack(sb);
        sb.append(log);
        if (logCallback != null) {
            logCallback.logI("HMSAgent", sb.toString());
        } else {
            Log.i((String)"HMSAgent", (String)sb.toString());
        }
    }

    public static void w(String log) {
        StringBuilder sb = new StringBuilder();
        HMSAgentLog.appendStack(sb);
        sb.append(log);
        if (logCallback != null) {
            logCallback.logW("HMSAgent", sb.toString());
        } else {
            Log.w((String)"HMSAgent", (String)sb.toString());
        }
    }

    public static void e(String log) {
        StringBuilder sb = new StringBuilder();
        HMSAgentLog.appendStack(sb);
        sb.append(log);
        if (logCallback != null) {
            logCallback.logE("HMSAgent", sb.toString());
        } else {
            Log.e((String)"HMSAgent", (String)sb.toString());
        }
    }

    private static void appendStack(StringBuilder sb) {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        if (stacks != null && stacks.length > 4) {
            int lastIndex;
            for (int i = lastIndex = Math.min(stacks.length - 1, 6); i >= 4; --i) {
                int dotIndx;
                if (stacks[i] == null) continue;
                String fileName = stacks[i].getFileName();
                if (fileName != null && (dotIndx = fileName.indexOf(46)) > 0) {
                    fileName = fileName.substring(0, dotIndx);
                }
                sb.append(fileName);
                sb.append('(');
                sb.append(stacks[i].getLineNumber());
                sb.append(")");
                sb.append("->");
            }
            sb.append(stacks[4].getMethodName());
        }
        sb.append('\n');
    }

    public static interface IHMSAgentLogCallback {
        public void logD(String var1, String var2);

        public void logV(String var1, String var2);

        public void logI(String var1, String var2);

        public void logW(String var1, String var2);

        public void logE(String var1, String var2);
    }
}

