/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.meizu;

import android.content.Context;
import android.text.TextUtils;
import io.rong.push.PushErrorCode;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;

public class MeizuPush
implements IPush {
    private final String TAG = MeizuPush.class.getSimpleName();

    @Override
    public void register(Context context, PushConfig pushConfig) {
        if (TextUtils.isEmpty((CharSequence)pushConfig.getMzAppId()) || TextUtils.isEmpty((CharSequence)pushConfig.getMzAppKey())) {
            RLog.e(this.TAG, "appId or appKey can't be empty!");
            PushManager.getInstance().onErrorResponse(context, PushType.MEIZU, "request_token", PushErrorCode.PARAMETER_ERROR.getCode());
            return;
        }
        String pushId = com.meizu.cloud.pushsdk.PushManager.getPushId((Context)context);
        if (TextUtils.isEmpty((CharSequence)pushId)) {
            com.meizu.cloud.pushsdk.PushManager.register((Context)context, (String)pushConfig.getMzAppId(), (String)pushConfig.getMzAppKey());
        } else {
            PushManager.getInstance().onReceiveToken(context, PushType.MEIZU, pushId);
        }
    }
}

