/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.platform.oppo;

import android.content.Context;
import com.coloros.mcssdk.callback.PushAdapter;
import com.coloros.mcssdk.callback.PushCallback;
import io.rong.push.PushErrorCode;
import io.rong.push.PushManager;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.pushconfig.PushConfig;

public class OppoPush
implements IPush {
    private final String TAG = OppoPush.class.getSimpleName();

    @Override
    public void register(final Context context, PushConfig pushConfig) {
        if (!com.coloros.mcssdk.PushManager.isSupportPush((Context)context.getApplicationContext())) {
            RLog.e(this.TAG, "the phone is not support oppo push!");
            PushManager.getInstance().onErrorResponse(context, PushType.OPPO, "request_token", PushErrorCode.NOT_SUPPORT_BY_OFFICIAL_PUSH.getCode());
            return;
        }
        RLog.d(this.TAG, "Oppo push start to register");
        com.coloros.mcssdk.PushManager.getInstance().register(context.getApplicationContext(), pushConfig.getOppoAppKey(), pushConfig.getOppoAppSecret(), (PushCallback)new PushAdapter(){

            public void onRegister(int responseCode, String registerID) {
                super.onRegister(responseCode, registerID);
                RLog.d(OppoPush.this.TAG, "Oppo Push onRegister responseCode " + String.valueOf(responseCode) + ",registerID:" + registerID);
                if (responseCode == 0) {
                    PushManager.getInstance().onReceiveToken(context, PushType.OPPO, registerID);
                } else {
                    PushManager.getInstance().onErrorResponse(context, PushType.OPPO, "request_token", responseCode);
                }
            }

            public void onGetPushStatus(int responseCode, int status) {
                super.onGetPushStatus(responseCode, status);
                RLog.d(OppoPush.this.TAG, "OPPO Push onGetPushStatus - responseCode:" + responseCode + ",status:" + status);
            }
        });
    }
}

