/*
 * Decompiled with CFR 0.152.
 */
package io.rong.push.pushconfig;

import io.rong.imlib.common.DeviceUtils;
import io.rong.push.PushType;
import io.rong.push.common.RLog;
import io.rong.push.platform.IPush;
import io.rong.push.platform.google.FCMPush;
import io.rong.push.platform.google.GCMPush;
import io.rong.push.platform.hms.HWPush;
import io.rong.push.platform.meizu.MeizuPush;
import io.rong.push.platform.mi.MiPush;
import io.rong.push.platform.oppo.OppoPush;
import io.rong.push.platform.vivo.VivoPush;
import io.rong.push.pushconfig.PushConfig;
import io.rong.push.rongpush.RongPush;

public class PushFactory {
    private static final String TAG = PushFactory.class.getSimpleName();

    public static boolean isOnlyDefaultPushOS(PushConfig pushConfig) {
        String os = DeviceUtils.getDeviceManufacturer();
        return (os.contains("Xiaomi") || os.contains("HUAWEI") || os.contains("Meizu")) && !pushConfig.getEnabledPushTypes().contains((Object)PushType.GOOGLE_GCM) && !pushConfig.getEnabledPushTypes().contains((Object)PushType.GOOGLE_FCM);
    }

    public static IPush getPushCenterByType(PushType pushType) {
        if (pushType.equals((Object)PushType.GOOGLE_GCM)) {
            return new GCMPush();
        }
        if (pushType.equals((Object)PushType.GOOGLE_FCM)) {
            return new FCMPush();
        }
        if (pushType.equals((Object)PushType.HUAWEI)) {
            return new HWPush();
        }
        if (pushType.equals((Object)PushType.XIAOMI)) {
            return new MiPush();
        }
        if (pushType.equals((Object)PushType.MEIZU)) {
            return new MeizuPush();
        }
        if (pushType.equals((Object)PushType.RONG)) {
            return new RongPush();
        }
        if (pushType.equals((Object)PushType.VIVO)) {
            return new VivoPush();
        }
        if (pushType.equals((Object)PushType.OPPO)) {
            return new OppoPush();
        }
        RLog.e(TAG, "unsupported push type!!");
        return null;
    }
}

