/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.share;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.kangxin.doctor.share.R;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXImageObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class WeChatShare {
    public static final String ACTION_SHARE_RESPONSE = "action_wx_share_response";
    public static final String EXTRA_RESULT = "result";
    private static final String TAG = "WeChatShare";
    private final Context context;
    private final IWXAPI api;
    private final int thumbBmpId;
    private OnResponseListener listener;
    private ResponseReceiver receiver;

    public WeChatShare(Context context, String appId, int thumbBmpId) {
        this.context = context;
        this.thumbBmpId = thumbBmpId;
        this.api = WXAPIFactory.createWXAPI((Context)context, (String)appId);
        this.api.registerApp(appId);
    }

    public void register() {
        this.receiver = new ResponseReceiver();
        IntentFilter filter = new IntentFilter(ACTION_SHARE_RESPONSE);
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    public void unregister() {
        try {
            this.api.unregisterApp();
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shareWebUrl(String title, String desc, String url, int shareType) {
        Log.i((String)TAG, (String)("url===>" + url));
        WXWebpageObject webpage = new WXWebpageObject();
        webpage.webpageUrl = url;
        WXMediaMessage msg = new WXMediaMessage((WXMediaMessage.IMediaObject)webpage);
        msg.title = title;
        msg.description = desc;
        Bitmap thumbBmp = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.thumbBmpId);
        msg.thumbData = this.bitmapToByteArray(thumbBmp, true);
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction("webpage");
        req.message = msg;
        req.scene = shareType;
        this.api.sendReq((BaseReq)req);
    }

    public void sharePicture(Bitmap bitmap, int shareType) {
        WXImageObject imgObj = new WXImageObject(bitmap);
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = imgObj;
        Bitmap thumbBmp = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)120, (int)150, (boolean)true);
        msg.thumbData = this.bitmapToByteArray(thumbBmp, true);
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction("img");
        req.message = msg;
        req.scene = shareType;
        this.api.sendReq((BaseReq)req);
    }

    public void shareText(String text, int shareType) {
        WXTextObject textObject = new WXTextObject(text);
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObject;
        msg.description = text;
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.message = msg;
        req.transaction = this.buildTransaction("text");
        req.scene = shareType;
        this.api.sendReq((BaseReq)req);
    }

    private byte[] bitmapToByteArray(Bitmap bitmap, boolean recycle) {
        return WeChatShare.bmpToByteArray2(bitmap);
    }

    public static byte[] bmpToByteArray2(Bitmap bitmap) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)output);
        for (int options = 100; output.toByteArray().length > 32768 && options >= 10; options -= 10) {
            output.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)output);
        }
        bitmap.recycle();
        try {
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toByteArray();
    }

    public IWXAPI getApi() {
        return this.api;
    }

    public void setListener(OnResponseListener listener) {
        this.listener = listener;
    }

    private String buildTransaction(String type) {
        return type == null ? String.valueOf(System.currentTimeMillis()) : type + System.currentTimeMillis();
    }

    private class ResponseReceiver
    extends BroadcastReceiver {
        private ResponseReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Response response = (Response)intent.getParcelableExtra(WeChatShare.EXTRA_RESULT);
            if (WeChatShare.this.listener != null) {
                if (response.errCode == 0) {
                    WeChatShare.this.listener.onSuccess();
                } else if (response.errCode == -2) {
                    WeChatShare.this.listener.onCancel();
                } else {
                    String result;
                    switch (response.errCode) {
                        case -4: {
                            result = context.getString(R.string.share_error_denied);
                            break;
                        }
                        case -5: {
                            result = context.getString(R.string.share_error_unsupport);
                            break;
                        }
                        default: {
                            result = context.getString(R.string.share_return);
                        }
                    }
                    WeChatShare.this.listener.onFail(result);
                }
            }
        }
    }

    public static class Response
    extends BaseResp
    implements Parcelable {
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

            public Response createFromParcel(Parcel source) {
                return new Response(source);
            }

            public Response[] newArray(int size) {
                return new Response[size];
            }
        };
        public int errCode;
        public String errStr;
        public String transaction;
        public String openId;
        private int type;
        private boolean checkResult;

        public Response(BaseResp baseResp) {
            this.errCode = baseResp.errCode;
            this.errStr = baseResp.errStr;
            this.transaction = baseResp.transaction;
            this.openId = baseResp.openId;
            this.type = baseResp.getType();
            this.checkResult = baseResp.checkArgs();
        }

        protected Response(Parcel in) {
            this.errCode = in.readInt();
            this.errStr = in.readString();
            this.transaction = in.readString();
            this.openId = in.readString();
            this.type = in.readInt();
            this.checkResult = in.readByte() != 0;
        }

        public int getType() {
            return this.type;
        }

        public boolean checkArgs() {
            return this.checkResult;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.errCode);
            dest.writeString(this.errStr);
            dest.writeString(this.transaction);
            dest.writeString(this.openId);
            dest.writeInt(this.type);
            dest.writeByte(this.checkResult ? (byte)1 : 0);
        }
    }

    public static interface OnResponseListener {
        public void onSuccess();

        public void onCancel();

        public void onFail(String var1);
    }
}

