package ezy.boost.update;

import android.content.Context;

import java.io.File;

import ezy.boost.update.download.CompleteListener;
import ezy.boost.update.download.ProgressListener;
import ezy.boost.update.download.Updater;

/**
 * @Package: ezy.boost.update
 * @ClassName: UpdateDownloader2
 * @Description:
 * @Author: SWY
 * @CreateDate: 2020/4/21 4:36 PM
 */
public class UpdateDownloader2 implements IUpdateDownloader {

    private final Context context;

    public UpdateDownloader2(Context mContext) {
        this.context = mContext;
    }

    @Override
    public void download(IDownloadAgent agent, String url, File temp) {
        agent.onStart();
        new Updater.Builder(context)
                .setDownloadUrl(url)
                .setApkFile(temp)
                .setNotificationTitle(context.getString(R.string.update_agent_apk_title))
                .start()
                .addProgressListener((totalBytes, curBytes, progress) -> agent.onProgress(progress))
                .bindCompleteListener(file -> {
                    if (temp != null && temp.exists())
                        temp.delete();
                    file.renameTo(temp);
                    agent.onFinish();
                });
    }
}
